/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.admin.client.resource;

import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.DELETE;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.PUT;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.QueryParam;
import java.util.List;
import java.util.Set;
import org.keycloak.representations.idm.RoleRepresentation;

public interface RoleByIdResource {
    @Path(value="{role-id}")
    @GET
    @Produces(value={"application/json"})
    public RoleRepresentation getRole(@PathParam(value="role-id") String var1);

    @Path(value="{role-id}")
    @DELETE
    public void deleteRole(@PathParam(value="role-id") String var1);

    @Path(value="{role-id}")
    @PUT
    @Consumes(value={"application/json"})
    public void updateRole(@PathParam(value="role-id") String var1, RoleRepresentation var2);

    @Path(value="{role-id}/composites")
    @POST
    @Consumes(value={"application/json"})
    public void addComposites(@PathParam(value="role-id") String var1, List<RoleRepresentation> var2);

    @Path(value="{role-id}/composites")
    @GET
    @Produces(value={"application/json"})
    public Set<RoleRepresentation> getRoleComposites(@PathParam(value="role-id") String var1);

    @Path(value="{role-id}/composites")
    @GET
    @Produces(value={"application/json"})
    public Set<RoleRepresentation> searchRoleComposites(@PathParam(value="role-id") String var1, @QueryParam(value="search") String var2, @QueryParam(value="first") Integer var3, @QueryParam(value="max") Integer var4);

    @Path(value="{role-id}/composites/realm")
    @GET
    @Produces(value={"application/json"})
    public Set<RoleRepresentation> getRealmRoleComposites(@PathParam(value="role-id") String var1);

    @Path(value="{role-id}/composites/clients/{clientUuid}")
    @GET
    @Produces(value={"application/json"})
    public Set<RoleRepresentation> getClientRoleComposites(@PathParam(value="role-id") String var1, @PathParam(value="clientUuid") String var2);

    @Path(value="{role-id}/composites")
    @DELETE
    @Consumes(value={"application/json"})
    public void deleteComposites(@PathParam(value="role-id") String var1, List<RoleRepresentation> var2);
}

