/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.admin.client.resource;

import java.util.List;
import java.util.Map;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import org.keycloak.admin.client.resource.RoleMappingResource;
import org.keycloak.representations.idm.CredentialRepresentation;
import org.keycloak.representations.idm.FederatedIdentityRepresentation;
import org.keycloak.representations.idm.GroupRepresentation;
import org.keycloak.representations.idm.UserRepresentation;
import org.keycloak.representations.idm.UserSessionRepresentation;

@Consumes(value={"application/json"})
@Produces(value={"application/json"})
public interface UserResource {
    @GET
    public UserRepresentation toRepresentation();

    @PUT
    public void update(UserRepresentation var1);

    @DELETE
    public void remove();

    @Path(value="groups")
    @GET
    public List<GroupRepresentation> groups();

    @Path(value="groups")
    @GET
    public List<GroupRepresentation> groups(@QueryParam(value="first") Integer var1, @QueryParam(value="max") Integer var2);

    @Path(value="groups")
    @GET
    public List<GroupRepresentation> groups(@QueryParam(value="search") String var1, @QueryParam(value="first") Integer var2, @QueryParam(value="max") Integer var3);

    @Path(value="groups")
    @GET
    public List<GroupRepresentation> groups(@QueryParam(value="first") Integer var1, @QueryParam(value="max") Integer var2, @QueryParam(value="briefRepresentation") @DefaultValue(value="true") boolean var3);

    @Path(value="groups")
    @GET
    public List<GroupRepresentation> groups(@QueryParam(value="search") String var1, @QueryParam(value="first") Integer var2, @QueryParam(value="max") Integer var3, @QueryParam(value="briefRepresentation") @DefaultValue(value="true") boolean var4);

    @Path(value="groups/{groupId}")
    @PUT
    public void joinGroup(@PathParam(value="groupId") String var1);

    @Path(value="groups/{groupId}")
    @DELETE
    public void leaveGroup(@PathParam(value="groupId") String var1);

    @POST
    @Path(value="logout")
    public void logout();

    @GET
    @Path(value="credentials")
    @Produces(value={"application/json"})
    public List<CredentialRepresentation> credentials();

    @GET
    @Path(value="configured-user-storage-credential-types")
    @Produces(value={"application/json"})
    public List<String> getConfiguredUserStorageCredentialTypes();

    @DELETE
    @Path(value="credentials/{credentialId}")
    public void removeCredential(@PathParam(value="credentialId") String var1);

    @PUT
    @Consumes(value={"text/plain"})
    @Path(value="credentials/{credentialId}/userLabel")
    public void setCredentialUserLabel(@PathParam(value="credentialId") String var1, String var2);

    @Path(value="credentials/{credentialId}/moveToFirst")
    @POST
    public void moveCredentialToFirst(@PathParam(value="credentialId") String var1);

    @Path(value="credentials/{credentialId}/moveAfter/{newPreviousCredentialId}")
    @POST
    public void moveCredentialAfter(@PathParam(value="credentialId") String var1, @PathParam(value="newPreviousCredentialId") String var2);

    @Path(value="disable-credential-types")
    @PUT
    @Consumes(value={"application/json"})
    @Deprecated
    public void disableCredentialType(List<String> var1);

    @PUT
    @Path(value="reset-password")
    public void resetPassword(CredentialRepresentation var1);

    @PUT
    @Path(value="reset-password-email")
    @Deprecated
    public void resetPasswordEmail();

    @PUT
    @Path(value="reset-password-email")
    @Deprecated
    public void resetPasswordEmail(@QueryParam(value="client_id") String var1);

    @PUT
    @Path(value="execute-actions-email")
    public void executeActionsEmail(List<String> var1);

    @PUT
    @Path(value="execute-actions-email")
    public void executeActionsEmail(List<String> var1, @QueryParam(value="lifespan") Integer var2);

    @PUT
    @Path(value="execute-actions-email")
    public void executeActionsEmail(@QueryParam(value="client_id") String var1, @QueryParam(value="redirect_uri") String var2, @QueryParam(value="lifespan") Integer var3, List<String> var4);

    @PUT
    @Path(value="execute-actions-email")
    public void executeActionsEmail(@QueryParam(value="client_id") String var1, @QueryParam(value="redirect_uri") String var2, List<String> var3);

    @PUT
    @Path(value="send-verify-email")
    public void sendVerifyEmail();

    @PUT
    @Path(value="send-verify-email")
    public void sendVerifyEmail(@QueryParam(value="client_id") String var1);

    @GET
    @Path(value="sessions")
    public List<UserSessionRepresentation> getUserSessions();

    @GET
    @Path(value="offline-sessions/{clientId}")
    public List<UserSessionRepresentation> getOfflineSessions(@PathParam(value="clientId") String var1);

    @GET
    @Path(value="federated-identity")
    public List<FederatedIdentityRepresentation> getFederatedIdentity();

    @POST
    @Path(value="federated-identity/{provider}")
    public Response addFederatedIdentity(@PathParam(value="provider") String var1, FederatedIdentityRepresentation var2);

    @Path(value="federated-identity/{provider}")
    @DELETE
    public void removeFederatedIdentity(@PathParam(value="provider") String var1);

    @Path(value="role-mappings")
    public RoleMappingResource roles();

    @GET
    @Path(value="consents")
    public List<Map<String, Object>> getConsents();

    @DELETE
    @Path(value="consents/{client}")
    public void revokeConsent(@PathParam(value="client") String var1);

    @POST
    @Path(value="impersonation")
    @Produces(value={"application/json"})
    public Map<String, Object> impersonate();
}

