/** SNOWPACK INJECT STYLE: @patternfly/react-styles/css/components/Chip/chip.css */
function __snowpack__injectStyle(css) {
  const headEl = document.head || document.getElementsByTagName('head')[0];
  const styleEl = document.createElement('style');
  styleEl.type = 'text/css';
  if (styleEl.styleSheet) {
    styleEl.styleSheet.cssText = css;
  } else {
    styleEl.appendChild(document.createTextNode(css));
  }
  headEl.appendChild(styleEl);
}
__snowpack__injectStyle(".pf-c-chip {\n  --pf-global--Color--100: var(--pf-global--Color--dark-100);\n  --pf-global--Color--200: var(--pf-global--Color--dark-200);\n  --pf-global--BorderColor--100: var(--pf-global--BorderColor--dark-100);\n  --pf-global--primary-color--100: var(--pf-global--primary-color--dark-100);\n  --pf-global--link--Color: var(--pf-global--link--Color--dark);\n  --pf-global--link--Color--hover: var(--pf-global--link--Color--dark--hover);\n  --pf-global--BackgroundColor--100: var(--pf-global--BackgroundColor--light-100);\n}\n\n.pf-c-chip {\n  --pf-c-chip--PaddingTop: var(--pf-global--spacer--xs);\n  --pf-c-chip--PaddingRight: var(--pf-global--spacer--sm);\n  --pf-c-chip--PaddingBottom: var(--pf-global--spacer--xs);\n  --pf-c-chip--PaddingLeft: var(--pf-global--spacer--sm);\n  --pf-c-chip--BackgroundColor: var(--pf-global--Color--light-100);\n  --pf-c-chip--BorderRadius: var(--pf-global--BorderRadius--sm);\n  --pf-c-chip--before--BorderColor: var(--pf-global--BorderColor--300);\n  --pf-c-chip--before--BorderWidth: var(--pf-global--BorderWidth--sm);\n  --pf-c-chip--before--BorderRadius: var(--pf-c-chip--BorderRadius);\n  --pf-c-chip--m-overflow__text--Color: var(--pf-global--primary-color--100);\n  --pf-c-chip--m-draggable--BackgroundColor: var(--pf-global--BackgroundColor--200);\n  --pf-c-chip--m-draggable--BoxShadow: var(--pf-global--BoxShadow--sm);\n  --pf-c-chip--m-draggable__icon--FontSize: var(--pf-global--icon--FontSize--sm);\n  --pf-c-chip__text--FontSize: var(--pf-global--FontSize--xs);\n  --pf-c-chip__text--Color: var(--pf-global--Color--100);\n  --pf-c-chip__text--MaxWidth: 16ch;\n  --pf-c-chip__c-button--PaddingTop: var(--pf-global--spacer--xs);\n  --pf-c-chip__c-button--PaddingRight: var(--pf-global--spacer--sm);\n  --pf-c-chip__c-button--PaddingBottom: var(--pf-global--spacer--xs);\n  --pf-c-chip__c-button--PaddingLeft: var(--pf-global--spacer--sm);\n  --pf-c-chip__c-button--MarginTop: calc(var(--pf-c-chip--PaddingTop) * -1);\n  --pf-c-chip__c-button--MarginRight: calc(var(--pf-c-chip--PaddingRight) / 2 * -1);\n  --pf-c-chip__c-button--MarginBottom: calc(var(--pf-c-chip--PaddingBottom) * -1);\n  --pf-c-chip__c-button--FontSize: var(--pf-global--FontSize--xs);\n  --pf-c-chip__c-badge--MarginLeft: var(--pf-global--spacer--xs);\n  --pf-c-chip__icon--MarginLeft: var(--pf-global--spacer--sm);\n  color: var(--pf-global--Color--100);\n  position: relative;\n  display: inline-flex;\n  align-items: center;\n  min-width: 0;\n  padding: var(--pf-c-chip--PaddingTop) var(--pf-c-chip--PaddingRight) var(--pf-c-chip--PaddingBottom) var(--pf-c-chip--PaddingLeft);\n  list-style: none;\n  background-color: var(--pf-c-chip--BackgroundColor);\n  border-radius: var(--pf-c-chip--BorderRadius);\n}\n.pf-c-chip::before {\n  position: absolute;\n  top: 0;\n  right: 0;\n  bottom: 0;\n  left: 0;\n  content: \"\";\n  border: var(--pf-c-chip--before--BorderWidth) solid var(--pf-c-chip--before--BorderColor);\n  border-radius: var(--pf-c-chip--before--BorderRadius);\n}\n.pf-c-chip.pf-m-overflow {\n  border: 0;\n}\n.pf-c-chip.pf-m-overflow .pf-c-chip__text {\n  color: var(--pf-c-chip--m-overflow__text--Color);\n}\n.pf-c-chip.pf-m-draggable {\n  --pf-c-chip--BackgroundColor: var(--pf-c-chip--m-draggable--BackgroundColor);\n  box-shadow: var(--pf-c-chip--m-draggable--BoxShadow);\n}\n.pf-c-chip.pf-m-draggable .pf-c-chip__icon {\n  font-size: var(--pf-c-chip--m-draggable__icon--FontSize);\n}\n.pf-c-chip .pf-c-button {\n  --pf-c-button--PaddingTop: var(--pf-c-chip__c-button--PaddingTop);\n  --pf-c-button--PaddingRight: var(--pf-c-chip__c-button--PaddingRight);\n  --pf-c-button--PaddingBottom: var(--pf-c-chip__c-button--PaddingBottom);\n  --pf-c-button--PaddingLeft: var(--pf-c-chip__c-button--PaddingLeft);\n  --pf-c-button--FontSize: var(--pf-c-chip__c-button--FontSize);\n  margin-top: var(--pf-c-chip__c-button--MarginTop);\n  margin-right: var(--pf-c-chip__c-button--MarginRight);\n  margin-bottom: var(--pf-c-chip__c-button--MarginBottom);\n}\n.pf-c-chip .pf-c-badge {\n  margin-left: var(--pf-c-chip__c-badge--MarginLeft);\n}\n\n.pf-c-chip__text {\n  overflow: hidden;\n  text-overflow: ellipsis;\n  white-space: nowrap;\n  position: relative;\n  max-width: var(--pf-c-chip__text--MaxWidth);\n  font-size: var(--pf-c-chip__text--FontSize);\n  color: var(--pf-c-chip__text--Color);\n}\n\n.pf-c-chip__icon + .pf-c-chip__text,\n.pf-c-chip__text + .pf-c-chip__icon {\n  margin-left: var(--pf-c-chip__icon--MarginLeft);\n}\n\n:where(.pf-theme-dark) .pf-c-chip {\n  --pf-c-chip--BackgroundColor: var(--pf-global--BackgroundColor--100);\n  --pf-c-chip--before--BorderColor: var(--pf-global--BorderColor--100);\n  --pf-c-chip--m-draggable--BackgroundColor: var(--pf-global--palette--black-600);\n}");
