/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.platform.mbean;

import java.util.Locale;
import java.util.ResourceBundle;
import org.jboss.as.controller.client.helpers.MeasurementUnit;
import org.jboss.as.controller.descriptions.StandardResourceDescriptionResolver;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;

public class PlatformMBeanDescriptions {
    static final String RESOURCE_NAME = PlatformMBeanDescriptions.class.getPackage().getName() + ".LocalDescriptions";

    static StandardResourceDescriptionResolver getResolver(String ... keyPrefix) {
        StringBuilder prefix = new StringBuilder("");
        for (String kp : keyPrefix) {
            if (prefix.length() > 0) {
                prefix.append('.');
            }
            prefix.append(kp);
        }
        return new StandardResourceDescriptionResolver(prefix.toString(), RESOURCE_NAME, PlatformMBeanDescriptions.class.getClassLoader(), true, false);
    }

    private PlatformMBeanDescriptions() {
    }

    public static ModelNode getGetThreadInfoDescription(Locale locale) {
        ResourceBundle bundle2 = PlatformMBeanDescriptions.getResourceBundle(locale);
        ModelNode node = PlatformMBeanDescriptions.getThreadInfoOperation(bundle2, "get-thread-info", "threading");
        node.get(new String[]{"request-properties", "max-depth", "description"}).set(bundle2.getString("threading.max-depth"));
        node.get(new String[]{"request-properties", "max-depth", "type"}).set(ModelType.INT);
        node.get(new String[]{"request-properties", "max-depth", "min"}).set(1);
        node.get(new String[]{"request-properties", "max-depth", "required"}).set(false);
        node.get(new String[]{"request-properties", "max-depth", "default"}).set(0);
        ModelNode reply = node.get("reply-properties");
        reply.get("description").set(bundle2.getString("threading.get-thread-info.reply"));
        reply.get("type").set(ModelType.OBJECT);
        reply.get("nillable").set(true);
        PlatformMBeanDescriptions.populateThreadInfo(reply.get("value-type"), bundle2);
        return node;
    }

    public static ModelNode getGetThreadInfosDescription(Locale locale) {
        ResourceBundle bundle2 = PlatformMBeanDescriptions.getResourceBundle(locale);
        ModelNode node = new ModelNode();
        node.get("operation-name").set("get-thread-infos");
        node.get("description").set(bundle2.getString("threading.get-thread-infos"));
        node.get(new String[]{"request-properties", "ids", "description"}).set(bundle2.getString("threading.ids"));
        node.get(new String[]{"request-properties", "ids", "type"}).set(ModelType.LIST);
        node.get(new String[]{"request-properties", "ids", "value-type"}).set(ModelType.LONG);
        node.get(new String[]{"request-properties", "ids", "required"}).set(true);
        node.get(new String[]{"request-properties", "max-depth", "description"}).set(bundle2.getString("threading.max-depth"));
        node.get(new String[]{"request-properties", "max-depth", "type"}).set(ModelType.INT);
        node.get(new String[]{"request-properties", "max-depth", "min"}).set(1);
        node.get(new String[]{"request-properties", "max-depth", "required"}).set(false);
        node.get(new String[]{"request-properties", "max-depth", "default"}).set(0);
        node.get(new String[]{"request-properties", "locked-monitors", "description"}).set(bundle2.getString("threading.locked-monitors"));
        node.get(new String[]{"request-properties", "locked-monitors", "type"}).set(ModelType.BOOLEAN);
        node.get(new String[]{"request-properties", "locked-monitors", "required"}).set(false);
        node.get(new String[]{"request-properties", "locked-monitors", "default"}).set(false);
        node.get(new String[]{"request-properties", "locked-synchronizers", "description"}).set(bundle2.getString("threading.locked-monitors"));
        node.get(new String[]{"request-properties", "locked-synchronizers", "type"}).set(ModelType.BOOLEAN);
        node.get(new String[]{"request-properties", "locked-synchronizers", "required"}).set(false);
        node.get(new String[]{"request-properties", "locked-synchronizers", "default"}).set(false);
        ModelNode reply = node.get("reply-properties");
        reply.get("description").set(bundle2.getString("threading.get-thread-infos.reply"));
        reply.get("type").set(ModelType.LIST);
        reply.get("nillable").set(false);
        PlatformMBeanDescriptions.populateThreadInfo(reply.get("value-type"), bundle2);
        return node;
    }

    public static ModelNode getDumpThreadsDescription(Locale locale) {
        ResourceBundle bundle2 = PlatformMBeanDescriptions.getResourceBundle(locale);
        ModelNode node = new ModelNode();
        node.get("operation-name").set("dump-all-threads");
        node.get("description").set(bundle2.getString("threading.dump-all-threads"));
        node.get(new String[]{"request-properties", "locked-monitors", "description"}).set(bundle2.getString("threading.locked-monitors"));
        node.get(new String[]{"request-properties", "locked-monitors", "type"}).set(ModelType.BOOLEAN);
        node.get(new String[]{"request-properties", "locked-monitors", "required"}).set(true);
        node.get(new String[]{"request-properties", "locked-synchronizers", "description"}).set(bundle2.getString("threading.locked-synchronizers"));
        node.get(new String[]{"request-properties", "locked-synchronizers", "type"}).set(ModelType.BOOLEAN);
        node.get(new String[]{"request-properties", "locked-synchronizers", "required"}).set(true);
        ModelNode reply = node.get("reply-properties");
        reply.get("description").set(bundle2.getString("threading.dump-threads.reply"));
        reply.get("type").set(ModelType.LIST);
        reply.get("nillable").set(false);
        PlatformMBeanDescriptions.populateThreadInfo(reply.get("value-type"), bundle2);
        return node;
    }

    public static ModelNode getThreadCpuTimeOperation(Locale locale) {
        ResourceBundle bundle2 = PlatformMBeanDescriptions.getResourceBundle(locale);
        ModelNode node = PlatformMBeanDescriptions.getThreadInfoOperation(bundle2, "get-thread-cpu-time", "threading");
        node.get(new String[]{"reply-properties", "type"}).set(ModelType.LONG);
        return node;
    }

    public static ModelNode getThreadUserTimeOperation(Locale locale) {
        ResourceBundle bundle2 = PlatformMBeanDescriptions.getResourceBundle(locale);
        ModelNode node = PlatformMBeanDescriptions.getThreadInfoOperation(bundle2, "get-thread-user-time", "threading");
        node.get(new String[]{"reply-properties", "type"}).set(ModelType.LONG);
        return node;
    }

    public static ModelNode getFindThreadsOperation(Locale locale, String name, String descriptionKeyBase) {
        ResourceBundle bundle2 = PlatformMBeanDescriptions.getResourceBundle(locale);
        ModelNode node = new ModelNode();
        node.get("operation-name").set(name);
        node.get("description").set(bundle2.getString(descriptionKeyBase + "." + name));
        node.get("request-properties").setEmptyObject();
        ModelNode reply = node.get("reply-properties");
        reply.get("description").set(bundle2.getString("threading.find-threads.reply"));
        reply.get("type").set(ModelType.LIST);
        reply.get("value-type").set(ModelType.LONG);
        reply.get("nillable").set(true);
        return node;
    }

    private static ModelNode getThreadInfoOperation(ResourceBundle bundle2, String name, String descriptionKeyBase) {
        ModelNode node = new ModelNode();
        node.get("operation-name").set(name);
        node.get("description").set(bundle2.getString(descriptionKeyBase + "." + name));
        node.get(new String[]{"request-properties", "id", "description"}).set(bundle2.getString("threading.id"));
        node.get(new String[]{"request-properties", "id", "type"}).set(ModelType.LONG);
        node.get(new String[]{"request-properties", "id", "min"}).set(1);
        node.get(new String[]{"request-properties", "id", "required"}).set(true);
        return node;
    }

    private static void populateThreadInfo(ModelNode toPopulate, ResourceBundle bundle2) {
        toPopulate.get(new String[]{"thread-id", "description"}).set(bundle2.getString("threading.thread-info.thread-id"));
        toPopulate.get(new String[]{"thread-id", "type"}).set(ModelType.LONG);
        toPopulate.get(new String[]{"thread-id", "nillable"}).set(true);
        toPopulate.get(new String[]{"thread-name", "description"}).set(bundle2.getString("threading.thread-info.thread-name"));
        toPopulate.get(new String[]{"thread-name", "type"}).set(ModelType.STRING);
        toPopulate.get(new String[]{"thread-name", "nillable"}).set(true);
        ModelNode threadState = toPopulate.get("thread-state");
        threadState.get("description").set(bundle2.getString("threading.thread-info.thread-state"));
        threadState.get("type").set(ModelType.STRING);
        threadState.get("nillable").set(true);
        ModelNode allowed = threadState.get("allowed");
        for (Thread.State state : Thread.State.values()) {
            allowed.add(state.name());
        }
        toPopulate.get(new String[]{"blocked-time", "description"}).set(bundle2.getString("threading.thread-info.blocked-time"));
        toPopulate.get(new String[]{"blocked-time", "type"}).set(ModelType.LONG);
        toPopulate.get(new String[]{"blocked-time", "nillable"}).set(false);
        toPopulate.get(new String[]{"blocked-time", "unit"}).set(MeasurementUnit.MILLISECONDS.getName());
        toPopulate.get(new String[]{"blocked-count", "description"}).set(bundle2.getString("threading.thread-info.blocked-count"));
        toPopulate.get(new String[]{"blocked-count", "type"}).set(ModelType.LONG);
        toPopulate.get(new String[]{"blocked-count", "nillable"}).set(true);
        toPopulate.get(new String[]{"waited-time", "description"}).set(bundle2.getString("threading.thread-info.waited-time"));
        toPopulate.get(new String[]{"waited-time", "type"}).set(ModelType.LONG);
        toPopulate.get(new String[]{"waited-time", "nillable"}).set(false);
        toPopulate.get(new String[]{"waited-time", "unit"}).set(MeasurementUnit.MILLISECONDS.getName());
        toPopulate.get(new String[]{"waited-count", "description"}).set(bundle2.getString("threading.thread-info.waited-count"));
        toPopulate.get(new String[]{"waited-count", "type"}).set(ModelType.STRING);
        toPopulate.get(new String[]{"waited-count", "nillable"}).set(true);
        toPopulate.get(new String[]{"lock-info", "description"}).set(bundle2.getString("threading.thread-info.lock-info"));
        toPopulate.get(new String[]{"lock-info", "type"}).set(ModelType.OBJECT);
        toPopulate.get(new String[]{"lock-info", "nillable"}).set(true);
        PlatformMBeanDescriptions.populateLockInfo(toPopulate.get(new String[]{"lock-info", "value-type"}), bundle2);
        toPopulate.get(new String[]{"lock-name", "description"}).set(bundle2.getString("threading.thread-info.lock-name"));
        toPopulate.get(new String[]{"lock-name", "type"}).set(ModelType.STRING);
        toPopulate.get(new String[]{"lock-name", "nillable"}).set(true);
        toPopulate.get(new String[]{"lock-owner-id", "description"}).set(bundle2.getString("threading.thread-info.lock-owner-id"));
        toPopulate.get(new String[]{"lock-owner-id", "type"}).set(ModelType.LONG);
        toPopulate.get(new String[]{"lock-owner-id", "nillable"}).set(true);
        toPopulate.get(new String[]{"lock-owner-name", "description"}).set(bundle2.getString("threading.thread-info.lock-owner-name"));
        toPopulate.get(new String[]{"lock-owner-name", "type"}).set(ModelType.STRING);
        toPopulate.get(new String[]{"lock-owner-name", "nillable"}).set(true);
        toPopulate.get(new String[]{"stack-trace", "description"}).set(bundle2.getString("threading.thread-info.stack-trace"));
        toPopulate.get(new String[]{"stack-trace", "type"}).set(ModelType.LIST);
        toPopulate.get(new String[]{"stack-trace", "nillable"}).set(true);
        PlatformMBeanDescriptions.populateStackTraceElement(toPopulate.get(new String[]{"stack-trace", "value-type"}), bundle2);
        toPopulate.get(new String[]{"suspended", "description"}).set(bundle2.getString("threading.thread-info.suspended"));
        toPopulate.get(new String[]{"suspended", "type"}).set(ModelType.BOOLEAN);
        toPopulate.get(new String[]{"suspended", "nillable"}).set(true);
        toPopulate.get(new String[]{"in-native", "description"}).set(bundle2.getString("threading.thread-info.in-native"));
        toPopulate.get(new String[]{"in-native", "type"}).set(ModelType.BOOLEAN);
        toPopulate.get(new String[]{"in-native", "nillable"}).set(true);
        toPopulate.get(new String[]{"locked-monitors", "description"}).set(bundle2.getString("threading.thread-info.locked-monitors"));
        toPopulate.get(new String[]{"locked-monitors", "type"}).set(ModelType.LIST);
        toPopulate.get(new String[]{"locked-monitors", "nillable"}).set(true);
        PlatformMBeanDescriptions.populateMonitorInfo(toPopulate.get(new String[]{"locked-monitors", "value-type"}), bundle2);
        toPopulate.get(new String[]{"locked-synchronizers", "description"}).set(bundle2.getString("threading.thread-info.locked-synchronizers"));
        toPopulate.get(new String[]{"locked-synchronizers", "type"}).set(ModelType.LIST);
        toPopulate.get(new String[]{"locked-synchronizers", "nillable"}).set(true);
        PlatformMBeanDescriptions.populateLockInfo(toPopulate.get(new String[]{"locked-synchronizers", "value-type"}), bundle2);
    }

    private static void populateLockInfo(ModelNode toPopulate, ResourceBundle bundle2) {
        toPopulate.get(new String[]{"class-name", "description"}).set(bundle2.getString("threading.lock.class-name"));
        toPopulate.get(new String[]{"class-name", "type"}).set(ModelType.STRING);
        toPopulate.get(new String[]{"class-name", "nillable"}).set(true);
        toPopulate.get(new String[]{"identity-hash-code", "description"}).set(bundle2.getString("threading.lock.identity-hash-code"));
        toPopulate.get(new String[]{"identity-hash-code", "type"}).set(ModelType.INT);
        toPopulate.get(new String[]{"identity-hash-code", "nillable"}).set(true);
    }

    private static void populateMonitorInfo(ModelNode toPopulate, ResourceBundle bundle2) {
        PlatformMBeanDescriptions.populateLockInfo(toPopulate, bundle2);
        toPopulate.get(new String[]{"locked-stack-depth", "description"}).set(bundle2.getString("threading.monitor.locked-stack-depth"));
        toPopulate.get(new String[]{"locked-stack-depth", "type"}).set(ModelType.INT);
        toPopulate.get(new String[]{"locked-stack-depth", "nillable"}).set(true);
        toPopulate.get(new String[]{"locked-stack-frame", "description"}).set(bundle2.getString("threading.monitor.locked-stack-frame"));
        toPopulate.get(new String[]{"locked-stack-frame", "type"}).set(ModelType.OBJECT);
        toPopulate.get(new String[]{"locked-stack-frame", "nillable"}).set(true);
        ModelNode valType = toPopulate.get(new String[]{"locked-stack-frame", "value-type"});
        PlatformMBeanDescriptions.populateStackTraceElement(valType, bundle2);
    }

    private static void populateStackTraceElement(ModelNode toPopulate, ResourceBundle bundle2) {
        toPopulate.get(new String[]{"file-name", "description"}).set(bundle2.getString("threading.stack.file-name"));
        toPopulate.get(new String[]{"file-name", "type"}).set(ModelType.STRING);
        toPopulate.get(new String[]{"file-name", "nillable"}).set(true);
        toPopulate.get(new String[]{"line-number", "description"}).set(bundle2.getString("threading.stack.line-number"));
        toPopulate.get(new String[]{"line-number", "type"}).set(ModelType.INT);
        toPopulate.get(new String[]{"line-number", "nillable"}).set(true);
        toPopulate.get(new String[]{"class-name", "description"}).set(bundle2.getString("threading.stack.class-name"));
        toPopulate.get(new String[]{"class-name", "type"}).set(ModelType.STRING);
        toPopulate.get(new String[]{"class-name", "nillable"}).set(true);
        toPopulate.get(new String[]{"method-name", "description"}).set(bundle2.getString("threading.stack.method-name"));
        toPopulate.get(new String[]{"method-name", "type"}).set(ModelType.STRING);
        toPopulate.get(new String[]{"method-name", "nillable"}).set(true);
        toPopulate.get(new String[]{"native-method", "description"}).set(bundle2.getString("threading.stack.native-method"));
        toPopulate.get(new String[]{"native-method", "type"}).set(ModelType.STRING);
        toPopulate.get(new String[]{"native-method", "nillable"}).set(true);
    }

    public static ModelNode getGetLoggerLevelDescription(Locale locale) {
        ResourceBundle bundle2 = PlatformMBeanDescriptions.getResourceBundle(locale);
        ModelNode node = new ModelNode();
        node.get("operation-name").set("get-logger-level");
        node.get("description").set(bundle2.getString("logging.get-logger-level"));
        PlatformMBeanDescriptions.addLoggerNameParam(node.get("request-properties"), bundle2);
        node.get("reply-properties");
        node.get(new String[]{"reply-properties", "type"}).set(ModelType.STRING);
        node.get(new String[]{"reply-properties", "nillable"}).set(true);
        return node;
    }

    public static ModelNode getSetLoggerLevelDescription(Locale locale) {
        ResourceBundle bundle2 = PlatformMBeanDescriptions.getResourceBundle(locale);
        ModelNode node = new ModelNode();
        node.get("operation-name").set("set-logger-level");
        node.get("description").set(bundle2.getString("logging.set-logger-level"));
        ModelNode reqProps = node.get("request-properties");
        PlatformMBeanDescriptions.addLoggerNameParam(reqProps, bundle2);
        ModelNode level = reqProps.get("level-name");
        level.get("description").set(bundle2.getString("logging.level-name"));
        level.get("type").set(ModelType.STRING);
        level.get("required").set(false);
        node.get("reply-properties").setEmptyObject();
        return node;
    }

    public static ModelNode getGetParentLoggerNameDescription(Locale locale) {
        ResourceBundle bundle2 = PlatformMBeanDescriptions.getResourceBundle(locale);
        ModelNode node = new ModelNode();
        node.get("operation-name").set("get-parent-logger-name");
        node.get("description").set(bundle2.getString("logging.get-parent-logger-name"));
        PlatformMBeanDescriptions.addLoggerNameParam(node.get("request-properties"), bundle2);
        node.get("reply-properties");
        node.get(new String[]{"reply-properties", "type"}).set(ModelType.STRING);
        node.get(new String[]{"reply-properties", "nillable"}).set(true);
        return node;
    }

    private static void addLoggerNameParam(ModelNode requestProperties, ResourceBundle bundle2) {
        ModelNode param = requestProperties.get("logger-name");
        param.get("description").set(bundle2.getString("logging.logger-name"));
        param.get("type").set(ModelType.STRING);
        param.get("min-length").set(0);
        param.get("required").set(true);
    }

    public static ModelNode getDescriptionOnlyOperation(Locale locale, String name, String descriptionKeyBase) {
        ResourceBundle bundle2 = PlatformMBeanDescriptions.getResourceBundle(locale);
        ModelNode node = new ModelNode();
        node.get("operation-name").set(name);
        node.get("description").set(bundle2.getString(descriptionKeyBase + "." + name));
        node.get("request-properties").setEmptyObject();
        node.get("reply-properties").setEmptyObject();
        return node;
    }

    private static ResourceBundle getResourceBundle(Locale locale) {
        if (locale == null) {
            locale = Locale.getDefault();
        }
        return ResourceBundle.getBundle(RESOURCE_NAME, locale);
    }
}

