/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.util.encoding;

import java.io.IOException;
import org.apache.lucene.util.encoding.ChunksIntEncoder;
import org.apache.lucene.util.encoding.EightFlagsIntDecoder;
import org.apache.lucene.util.encoding.IntDecoder;

public class EightFlagsIntEncoder
extends ChunksIntEncoder {
    private static byte[] encodeTable = new byte[]{1, 2, 4, 8, 16, 32, 64, -128};

    public EightFlagsIntEncoder() {
        super(8);
    }

    public void encode(int data) throws IOException {
        if (data == 1) {
            this.indicator |= encodeTable[this.ordinal];
        } else {
            this.encodeQueue[this.encodeQueueSize++] = data - 2;
        }
        this.ordinal = (byte)(this.ordinal + 1);
        if ((this.ordinal & 7) == 0) {
            this.encodeChunk();
        }
    }

    public IntDecoder createMatchingDecoder() {
        return new EightFlagsIntDecoder();
    }

    public String toString() {
        return "EightFlags (" + this.encoder.toString() + ")";
    }
}

