/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.server.handlers;

import io.undertow.server.ExchangeCompletionListener;
import io.undertow.server.HttpHandler;
import io.undertow.server.HttpServerExchange;
import io.undertow.server.handlers.ResponseCodeHandler;
import java.util.Queue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.atomic.AtomicLongFieldUpdater;
import org.xnio.Bits;

public class RequestLimit {
    private volatile long state;
    private static final AtomicLongFieldUpdater<RequestLimit> stateUpdater = AtomicLongFieldUpdater.newUpdater(RequestLimit.class, "state");
    private static final long MASK_MAX = Bits.longBitMask((int)32, (int)63);
    private static final long MASK_CURRENT = Bits.longBitMask((int)0, (int)30);
    private volatile HttpHandler failureHandler = new ResponseCodeHandler(513);
    private final Queue<SuspendedRequest> queue;
    private final ExchangeCompletionListener COMPLETION_LISTENER = new ExchangeCompletionListener(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void exchangeEvent(HttpServerExchange exchange, ExchangeCompletionListener.NextListener nextListener) {
            try {
                SuspendedRequest task = (SuspendedRequest)RequestLimit.this.queue.poll();
                if (task != null) {
                    task.exchange.dispatch(task.next);
                } else {
                    RequestLimit.this.decrementRequests();
                }
            }
            finally {
                nextListener.proceed();
            }
        }
    };

    public RequestLimit(int maximumConcurrentRequests) {
        this(maximumConcurrentRequests, -1);
    }

    public RequestLimit(int maximumConcurrentRequests, int queueSize) {
        if (maximumConcurrentRequests < 1) {
            throw new IllegalArgumentException("Maximum concurrent requests must be at least 1");
        }
        this.state = ((long)maximumConcurrentRequests & 0xFFFFFFFFL) << 32;
        this.queue = new LinkedBlockingQueue<SuspendedRequest>(queueSize <= 0 ? Integer.MAX_VALUE : queueSize);
    }

    public void handleRequest(HttpServerExchange exchange, HttpHandler next) throws Exception {
        long newVal;
        long oldVal;
        exchange.addExchangeCompleteListener(this.COMPLETION_LISTENER);
        do {
            long max;
            long current;
            if ((current = (oldVal = this.state) & MASK_CURRENT) < (max = (oldVal & MASK_MAX) >> 32)) continue;
            if (!this.queue.offer(new SuspendedRequest(exchange, next))) {
                this.failureHandler.handleRequest(exchange);
            }
            return;
        } while (!stateUpdater.compareAndSet(this, oldVal, newVal = oldVal + 1L));
        next.handleRequest(exchange);
    }

    public int getMaximumConcurrentRequests() {
        return (int)(this.state >> 32);
    }

    public int setMaximumConcurrentRequests(int newMax) {
        int oldMax;
        int current;
        long newVal;
        long oldVal;
        if (newMax < 1) {
            throw new IllegalArgumentException("Maximum concurrent requests must be at least 1");
        }
        do {
            oldVal = this.state;
            current = (int)(oldVal & MASK_CURRENT);
            oldMax = (int)((oldVal & MASK_MAX) >> 32);
        } while (!stateUpdater.compareAndSet(this, oldVal, newVal = (long)current | (long)newMax & 0xFFFFFFFF00000000L));
        while (current < newMax) {
            SuspendedRequest request = this.queue.poll();
            if (request == null) continue;
            newVal = stateUpdater.getAndIncrement(this);
            current = (int)(newVal & MASK_CURRENT);
            request.exchange.dispatch(request.next);
        }
        return oldMax;
    }

    private void decrementRequests() {
        stateUpdater.decrementAndGet(this);
    }

    public HttpHandler getFailureHandler() {
        return this.failureHandler;
    }

    public void setFailureHandler(HttpHandler failureHandler) {
        this.failureHandler = failureHandler;
    }

    private static final class SuspendedRequest {
        final HttpServerExchange exchange;
        final HttpHandler next;

        private SuspendedRequest(HttpServerExchange exchange, HttpHandler next) {
            this.exchange = exchange;
            this.next = next;
        }
    }
}

