/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resource.adapter.jms.inflow;

import java.lang.reflect.Method;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.jms.Connection;
import javax.jms.ConnectionFactory;
import javax.jms.Destination;
import javax.jms.ExceptionListener;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageListener;
import javax.jms.Queue;
import javax.jms.Topic;
import javax.jms.XAConnectionFactory;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.resource.ResourceException;
import javax.resource.spi.endpoint.MessageEndpointFactory;
import javax.resource.spi.work.Work;
import javax.resource.spi.work.WorkManager;
import javax.transaction.TransactionManager;
import org.jboss.logging.Logger;
import org.jboss.resource.adapter.jms.JmsResourceAdapter;
import org.jboss.resource.adapter.jms.inflow.JmsActivationSpec;
import org.jboss.resource.adapter.jms.inflow.JmsServerSessionPool;

public class JmsActivation
implements ExceptionListener {
    private static final Logger log = Logger.getLogger(JmsActivation.class);
    private static final String JNDI_NAME = "java:jboss/TransactionManager";
    public static final Method ONMESSAGE;
    protected JmsResourceAdapter ra;
    protected JmsActivationSpec spec;
    protected MessageEndpointFactory endpointFactory;
    protected AtomicBoolean deliveryActive = new AtomicBoolean(false);
    private AtomicBoolean inFailure = new AtomicBoolean(false);
    protected Destination destination;
    protected boolean isTopic = false;
    protected Connection connection;
    protected JmsServerSessionPool pool;
    protected boolean isDeliveryTransacted;
    protected TransactionManager tm;

    public JmsActivation(JmsResourceAdapter ra, MessageEndpointFactory endpointFactory, JmsActivationSpec spec) throws ResourceException {
        this.ra = ra;
        this.endpointFactory = endpointFactory;
        this.spec = spec;
        try {
            this.isDeliveryTransacted = endpointFactory.isDeliveryTransacted(ONMESSAGE);
        }
        catch (Exception e) {
            throw new ResourceException((Throwable)e);
        }
    }

    public JmsActivationSpec getActivationSpec() {
        return this.spec;
    }

    public MessageEndpointFactory getMessageEndpointFactory() {
        return this.endpointFactory;
    }

    public boolean isDeliveryTransacted() {
        return this.isDeliveryTransacted;
    }

    public WorkManager getWorkManager() {
        return this.ra.getWorkManager();
    }

    public TransactionManager getTransactionManager() {
        if (this.tm == null) {
            try {
                InitialContext ctx = new InitialContext();
                this.tm = (TransactionManager)ctx.lookup(JNDI_NAME);
                if (log.isTraceEnabled()) {
                    log.trace((Object)("Got a transaction manager from jndi " + this.tm));
                }
            }
            catch (NamingException e) {
                log.debug((Object)"Unable to lookup: java:jboss/TransactionManager", (Throwable)e);
            }
        }
        return this.tm;
    }

    public Connection getConnection() {
        return this.connection;
    }

    public Destination getDestination() {
        return this.destination;
    }

    public boolean isTopic() {
        return this.isTopic;
    }

    public void start() throws ResourceException {
        this.deliveryActive.set(true);
        this.ra.getWorkManager().scheduleWork((Work)new SetupActivation());
    }

    public void stop() {
        this.deliveryActive.set(false);
        this.teardown();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleFailure(Throwable failure) {
        log.warn((Object)("Failure in jms activation " + this.spec), failure);
        if (this.inFailure.getAndSet(true)) {
            return;
        }
        try {
            for (int reconnectCount = 0; this.deliveryActive.get() && (reconnectCount < this.spec.getReconnectAttempts() || this.spec.getReconnectAttempts() == -1); ++reconnectCount) {
                this.teardown();
                try {
                    Thread.sleep(this.spec.getReconnectIntervalLong());
                }
                catch (InterruptedException e) {
                    log.debug((Object)("Interrupted trying to reconnect " + this.spec), (Throwable)e);
                    break;
                }
                log.info((Object)("Attempting to reconnect " + this.spec));
                try {
                    this.setupActivation();
                    log.info((Object)"Reconnected with messaging provider.");
                    break;
                }
                catch (Throwable t) {
                    log.error((Object)("Unable to reconnect " + this.spec), t);
                    continue;
                }
            }
        }
        finally {
            this.inFailure.set(false);
        }
    }

    public void onException(JMSException exception) {
        this.handleFailure((Throwable)exception);
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append(JmsActivation.defaultToString(this)).append('(');
        buffer.append("spec=").append(JmsActivation.defaultToString(this.spec));
        buffer.append(" endpointFactory=").append(JmsActivation.defaultToString(this.endpointFactory));
        buffer.append(" deliveryActive=").append(this.deliveryActive.get());
        if (this.destination != null) {
            buffer.append(" destination=").append(this.destination);
        }
        if (this.connection != null) {
            buffer.append(" connection=").append(this.connection);
        }
        if (this.pool != null) {
            buffer.append(" pool=").append(JmsActivation.defaultToString(this.pool));
        }
        buffer.append(" isDeliveryTransacted=").append(this.isDeliveryTransacted);
        buffer.append(')');
        return buffer.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setupActivation() throws Exception {
        log.debug((Object)("Setting up " + this.spec));
        Context ctx = JmsActivation.convertStringToContext(this.spec.getJndiParameters());
        log.debug((Object)("Using context " + ctx.getEnvironment() + " for " + this.spec));
        try {
            this.setupDestination(ctx);
            this.setupConnection(ctx);
        }
        finally {
            ctx.close();
        }
        this.setupSessionPool();
        log.debug((Object)("Setup complete " + this));
    }

    public static Context convertStringToContext(String jndiParameters) throws NamingException {
        InitialContext result = null;
        if (jndiParameters == null) {
            result = new InitialContext();
        } else {
            String[] elements;
            Properties properties = new Properties();
            for (String element : elements = jndiParameters.split(";")) {
                String[] nameValue = element.split("=");
                if (nameValue.length != 2) continue;
                properties.setProperty(nameValue[0], nameValue[1]);
            }
            result = new InitialContext(properties);
        }
        return result;
    }

    protected void teardown() {
        log.debug((Object)("Tearing down " + this.spec));
        this.teardownSessionPool();
        this.teardownConnection();
        this.teardownDestination();
        log.debug((Object)("Tearing down complete " + this));
    }

    protected void setupDestination(Context ctx) throws Exception {
        String destinationName = this.spec.getDestination();
        String destinationTypeString = this.spec.getDestinationType();
        log.debug((Object)("Destination type defined as " + destinationTypeString));
        Class destinationType = Topic.class.getName().equals(destinationTypeString) ? Topic.class : (Queue.class.getName().equals(destinationTypeString) ? Queue.class : Destination.class);
        log.debug((Object)("Retrieving destination " + destinationName + " of type " + destinationType.getName()));
        this.destination = (Destination)JmsActivation.lookup(ctx, destinationName, destinationType);
        if (this.destination instanceof Topic) {
            this.isTopic = true;
        }
        log.debug((Object)("Got destination " + this.destination + " from " + destinationName));
    }

    protected void teardownDestination() {
        this.destination = null;
    }

    protected void setupConnection(Context ctx) throws Exception {
        log.debug((Object)("setup connection " + this));
        String user = this.spec.getUser();
        String pass = this.spec.getPassword();
        String clientID = this.spec.getClientId();
        String connectionFactory = this.spec.getConnectionFactory();
        this.connection = this.setupConnection(ctx, user, pass, clientID, connectionFactory);
        log.debug((Object)("established connection " + this));
    }

    protected Connection setupConnection(Context ctx, String user, String pass, String clientID, String connectionFactory) throws Exception {
        Connection result;
        log.debug((Object)("Attempting to lookup connection factory " + connectionFactory));
        Object preliminaryObject = JmsActivation.lookup(ctx, connectionFactory, Object.class);
        log.debug((Object)("Got connection factory " + preliminaryObject + " from " + connectionFactory));
        log.debug((Object)("Attempting to create connection with user " + user));
        if (preliminaryObject instanceof XAConnectionFactory && this.isDeliveryTransacted) {
            XAConnectionFactory xagcf = (XAConnectionFactory)preliminaryObject;
            result = user != null ? xagcf.createXAConnection(user, pass) : xagcf.createXAConnection();
        } else {
            ConnectionFactory gcf = (ConnectionFactory)preliminaryObject;
            result = user != null ? gcf.createConnection(user, pass) : gcf.createConnection();
        }
        try {
            if (clientID != null) {
                result.setClientID(clientID);
            }
            result.setExceptionListener((ExceptionListener)this);
            log.debug((Object)("Using generic connection " + result));
            return result;
        }
        catch (Throwable t) {
            try {
                result.close();
            }
            catch (Exception e) {
                log.trace((Object)"Ignored error closing connection", (Throwable)e);
            }
            if (t instanceof Exception) {
                throw (Exception)t;
            }
            throw new RuntimeException("Error configuring connection", t);
        }
    }

    protected void teardownConnection() {
        try {
            if (this.connection != null) {
                log.debug((Object)("Closing the " + this.connection));
                this.connection.close();
            }
        }
        catch (Throwable t) {
            log.debug((Object)("Error closing the connection " + this.connection), t);
        }
        this.connection = null;
    }

    protected void setupSessionPool() throws Exception {
        this.pool = new JmsServerSessionPool(this);
        log.debug((Object)("Created session pool " + this.pool));
        log.debug((Object)("Starting session pool " + this.pool));
        this.pool.start();
        log.debug((Object)("Started session pool " + this.pool));
        log.debug((Object)("Starting delivery " + this.connection));
        this.connection.start();
        log.debug((Object)("Started delivery " + this.connection));
    }

    protected void teardownSessionPool() {
        try {
            if (this.connection != null) {
                log.debug((Object)("Stopping delivery " + this.connection));
                this.connection.stop();
            }
        }
        catch (Throwable t) {
            log.debug((Object)("Error stopping delivery " + this.connection), t);
        }
        try {
            if (this.pool != null) {
                log.debug((Object)("Stopping the session pool " + this.pool));
                this.pool.stop();
            }
        }
        catch (Throwable t) {
            log.debug((Object)("Error clearing the pool " + this.pool), t);
        }
        this.pool = null;
    }

    public static final String defaultToString(Object object) {
        if (object == null) {
            return "null";
        }
        return object.getClass().getName() + '@' + Integer.toHexString(System.identityHashCode(object));
    }

    private static Object lookup(Context context, String name, Class clazz) throws Exception {
        Object result = context.lookup(name);
        Class<?> objectClass = result.getClass();
        if (!clazz.isAssignableFrom(objectClass)) {
            StringBuffer buffer = new StringBuffer(100);
            buffer.append("Object at '").append(name);
            buffer.append("' in context ").append(context.getEnvironment());
            buffer.append(" is not an instance of ");
            JmsActivation.appendClassInfo(buffer, clazz);
            buffer.append(" object class is ");
            JmsActivation.appendClassInfo(buffer, result.getClass());
            throw new ClassCastException(buffer.toString());
        }
        return result;
    }

    private static void appendClassInfo(StringBuffer buffer, Class clazz) {
        buffer.append("[class=").append(clazz.getName());
        buffer.append(" classloader=").append(clazz.getClassLoader());
        buffer.append(" interfaces={");
        Class<?>[] interfaces = clazz.getInterfaces();
        for (int i = 0; i < interfaces.length; ++i) {
            if (i > 0) {
                buffer.append(", ");
            }
            buffer.append("interface=").append(interfaces[i].getName());
            buffer.append(" classloader=").append(interfaces[i].getClassLoader());
        }
        buffer.append("}]");
    }

    static {
        try {
            ONMESSAGE = MessageListener.class.getMethod("onMessage", Message.class);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private class SetupActivation
    implements Work {
        private SetupActivation() {
        }

        public void run() {
            try {
                JmsActivation.this.setupActivation();
            }
            catch (Throwable t) {
                JmsActivation.this.handleFailure(t);
            }
        }

        public void release() {
        }
    }
}

