/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.server.group;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import org.infinispan.Cache;
import org.infinispan.distribution.DistributionManager;
import org.infinispan.notifications.Listener;
import org.infinispan.notifications.cachelistener.annotation.TopologyChanged;
import org.infinispan.notifications.cachelistener.event.TopologyChangedEvent;
import org.infinispan.remoting.transport.Address;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StopContext;
import org.wildfly.clustering.group.Group;
import org.wildfly.clustering.group.Node;
import org.wildfly.clustering.server.group.CacheGroupConfiguration;
import org.wildfly.clustering.server.group.CacheNodeFactory;

@Listener
public class CacheGroupService
implements Group,
Service<Group> {
    private final CacheGroupConfiguration config;
    private final List<Group.Listener> listeners = new CopyOnWriteArrayList<Group.Listener>();
    private volatile Cache<?, ?> cache = null;
    private volatile CacheNodeFactory factory = null;

    public CacheGroupService(CacheGroupConfiguration config) {
        this.config = config;
    }

    public Group getValue() {
        return this;
    }

    public void start(StartContext context) {
        this.cache = this.config.getCache();
        this.factory = this.config.getNodeFactory();
        this.cache.addListener((Object)this);
    }

    public void stop(StopContext context) {
        this.cache.removeListener((Object)this);
        this.factory = null;
        this.cache = null;
    }

    public String getName() {
        return this.cache.getCacheManager().getClusterName();
    }

    public boolean isCoordinator() {
        return this.cache.getCacheManager().getAddress().equals(this.getCoordinator());
    }

    public Node getLocalNode() {
        return this.factory.createNode(this.cache.getCacheManager().getAddress());
    }

    public Node getCoordinatorNode() {
        return this.factory.createNode(this.getCoordinator());
    }

    private Address getCoordinator() {
        DistributionManager dist = this.cache.getAdvancedCache().getDistributionManager();
        return dist != null ? (Address)dist.getConsistentHash().getMembers().get(0) : this.cache.getCacheManager().getCoordinator();
    }

    public List<Node> getNodes() {
        List<Address> addresses = this.getAddresses();
        ArrayList<Node> nodes = new ArrayList<Node>(addresses.size());
        for (Address address : addresses) {
            nodes.add(this.factory.createNode(address));
        }
        return nodes;
    }

    @TopologyChanged
    public void topologyChanged(TopologyChangedEvent<?, ?> event) {
        if (event.isPre()) {
            return;
        }
        List oldAddresses = event.getConsistentHashAtStart().getMembers();
        List<Node> oldNodes = this.getNodes(oldAddresses);
        List newAddresses = event.getConsistentHashAtEnd().getMembers();
        List<Node> newNodes = this.getNodes(newAddresses);
        HashSet obsolete = new HashSet(oldAddresses);
        obsolete.removeAll(newAddresses);
        this.factory.invalidate(obsolete);
        for (Group.Listener listener : this.listeners) {
            listener.membershipChanged(oldNodes, newNodes, false);
        }
    }

    private List<Node> getNodes(List<Address> addresses) {
        ArrayList<Node> nodes = new ArrayList<Node>(addresses.size());
        for (Address address : addresses) {
            nodes.add(this.factory.createNode(address));
        }
        return nodes;
    }

    public void addListener(Group.Listener listener) {
        this.listeners.add(listener);
    }

    public void removeListener(Group.Listener listener) {
        this.listeners.remove(listener);
    }

    private List<Address> getAddresses() {
        DistributionManager dist = this.cache.getAdvancedCache().getDistributionManager();
        return dist != null ? dist.getConsistentHash().getMembers() : this.cache.getCacheManager().getMembers();
    }
}

