/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.ejb3.component.stateful;

import java.lang.reflect.Method;
import org.jboss.as.ee.component.Component;
import org.jboss.as.ee.component.ComponentInstance;
import org.jboss.as.ee.component.ComponentView;
import org.jboss.as.ejb3.EjbMessages;
import org.jboss.as.ejb3.component.EJBComponent;
import org.jboss.as.ejb3.component.Ejb2xViewType;
import org.jboss.as.ejb3.component.stateful.StatefulSessionComponent;
import org.jboss.as.ejb3.component.stateful.StatefulSessionComponentInstance;
import org.jboss.as.ejb3.component.stateful.StatefulTransactionMarker;
import org.jboss.ejb.client.SessionID;
import org.jboss.invocation.Interceptor;
import org.jboss.invocation.InterceptorContext;

public class StatefulRemoveInterceptor
implements Interceptor {
    private final boolean retainIfException;

    public StatefulRemoveInterceptor(boolean retainIfException) {
        this.retainIfException = retainIfException;
    }

    public Object processInvocation(InterceptorContext context) throws Exception {
        StatefulTransactionMarker marker;
        Ejb2xViewType viewType;
        Component component = (Component)context.getPrivateData(Component.class);
        ComponentView view = (ComponentView)context.getPrivateData(ComponentView.class);
        if (view != null && (viewType = (Ejb2xViewType)((Object)view.getPrivateData(Ejb2xViewType.class))) != null && (marker = (StatefulTransactionMarker)context.getPrivateData(StatefulTransactionMarker.class)) != null && !marker.isFirstInvocation()) {
            throw EjbMessages.MESSAGES.cannotRemoveWhileParticipatingInTransaction();
        }
        if (!(component instanceof StatefulSessionComponent)) {
            throw EjbMessages.MESSAGES.unexpectedComponent(component, StatefulSessionComponent.class);
        }
        StatefulSessionComponent statefulComponent = (StatefulSessionComponent)component;
        Object invocationResult = null;
        try {
            invocationResult = context.proceed();
        }
        catch (Exception e) {
            if (this.isApplicationException(statefulComponent, e.getClass(), context.getMethod()) && this.retainIfException) {
                throw e;
            }
            StatefulSessionComponentInstance statefulComponentInstance = (StatefulSessionComponentInstance)context.getPrivateData(ComponentInstance.class);
            SessionID sessionId = statefulComponentInstance.getId();
            statefulComponent.removeSession(sessionId);
            throw e;
        }
        StatefulSessionComponentInstance statefulComponentInstance = (StatefulSessionComponentInstance)context.getPrivateData(ComponentInstance.class);
        SessionID sessionId = statefulComponentInstance.getId();
        statefulComponent.removeSession(sessionId);
        return invocationResult;
    }

    private boolean isApplicationException(EJBComponent ejbComponent, Class<?> exceptionClass, Method invokedMethod) {
        return ejbComponent.getApplicationException(exceptionClass, invokedMethod) != null;
    }
}

