/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.ejb3.iiop.stub;

import org.jboss.as.ejb3.EjbLogger;
import org.jboss.as.ejb3.EjbMessages;
import org.jboss.as.ejb3.iiop.stub.IIOPStubCompiler;
import org.jboss.classfilewriter.ClassFile;
import org.jboss.com.sun.corba.se.impl.presentation.rmi.StubFactoryBase;
import org.jboss.com.sun.corba.se.impl.presentation.rmi.StubFactoryFactoryDynamicBase;
import org.jboss.com.sun.corba.se.spi.presentation.rmi.PresentationManager;
import org.omg.CORBA.Object;
import org.wildfly.security.manager.WildFlySecurityManager;

public class DynamicStubFactoryFactory
extends StubFactoryFactoryDynamicBase {
    public PresentationManager.StubFactory makeDynamicStubFactory(PresentationManager pm, PresentationManager.ClassData classData, ClassLoader classLoader) {
        Class myClass = classData.getMyClass();
        Class<?> theClass = DynamicStubFactoryFactory.makeStubClass(myClass);
        return new StubFactory(classData, theClass);
    }

    public static Class<?> makeStubClass(Class<?> myClass) {
        Class theClass;
        String stubClassName = myClass + "_Stub";
        ClassLoader cl = WildFlySecurityManager.getCurrentContextClassLoaderPrivileged();
        if (cl == null) {
            cl = myClass.getClassLoader();
        }
        if (cl == null) {
            throw EjbMessages.MESSAGES.couldNotFindClassLoaderForStub(stubClassName);
        }
        try {
            theClass = cl.loadClass(stubClassName);
        }
        catch (ClassNotFoundException e) {
            try {
                ClassFile clazz = IIOPStubCompiler.compile(myClass, stubClassName);
                theClass = clazz.define(cl, myClass.getProtectionDomain());
            }
            catch (RuntimeException ex) {
                try {
                    theClass = cl.loadClass(stubClassName);
                }
                catch (ClassNotFoundException e1) {
                    EjbLogger.EJB3_LOGGER.dynamicStubCreationFailed(stubClassName, ex);
                    throw ex;
                }
            }
        }
        return theClass;
    }

    private static final class StubFactory
    extends StubFactoryBase {
        private final Class<?> clazz;

        protected StubFactory(PresentationManager.ClassData classData, Class<?> clazz) {
            super(classData);
            this.clazz = clazz;
        }

        public Object makeStub() {
            try {
                return (Object)this.clazz.newInstance();
            }
            catch (InstantiationException e) {
                throw new RuntimeException(e);
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException(e);
            }
        }
    }
}

