/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.ejb3.subsystem;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import org.jboss.as.controller.AbstractAddStepHandler;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.ServiceVerificationHandler;
import org.jboss.as.ejb3.cache.CacheFactoryBuilderService;
import org.jboss.as.ejb3.cache.DelegateCacheFactoryBuilderService;
import org.jboss.as.ejb3.cache.distributable.DistributableCacheFactoryBuilderService;
import org.jboss.as.ejb3.cache.simple.SimpleCacheFactoryBuilderService;
import org.jboss.as.ejb3.subsystem.CacheFactoryResourceDefinition;
import org.jboss.dmr.ModelNode;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceListener;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceTarget;

public class CacheFactoryAdd
extends AbstractAddStepHandler {
    private final AttributeDefinition[] attributes;

    CacheFactoryAdd(AttributeDefinition ... attributes) {
        this.attributes = attributes;
    }

    protected void populateModel(ModelNode operation, ModelNode model) throws OperationFailedException {
        for (AttributeDefinition attr : this.attributes) {
            attr.validateAndSet(operation, model);
        }
    }

    protected void performRuntime(OperationContext context, ModelNode operation, ModelNode model, ServiceVerificationHandler verificationHandler, List<ServiceController<?>> serviceControllers) throws OperationFailedException {
        serviceControllers.addAll(this.installRuntimeServices(context, operation, model, verificationHandler));
    }

    Collection<ServiceController<?>> installRuntimeServices(OperationContext context, ModelNode operation, ModelNode model, ServiceVerificationHandler verificationHandler) throws OperationFailedException {
        String name = PathAddress.pathAddress((ModelNode)operation.get("address")).getLastElement().getValue();
        ModelNode passivationStoreModel = CacheFactoryResourceDefinition.PASSIVATION_STORE.resolveModelAttribute(context, model);
        String passivationStore = passivationStoreModel.isDefined() ? passivationStoreModel.asString() : null;
        List unwrappedAliasValues = CacheFactoryResourceDefinition.ALIASES.unwrap(context, model);
        HashSet aliases = unwrappedAliasValues != null ? new HashSet(unwrappedAliasValues) : Collections.emptySet();
        ServiceTarget target = context.getServiceTarget();
        ServiceBuilder<?> builder = CacheFactoryAdd.buildCacheFactoryBuilder(target, name, passivationStore);
        for (String alias : aliases) {
            builder.addAliases(new ServiceName[]{CacheFactoryBuilderService.getServiceName(alias)});
        }
        if (verificationHandler != null) {
            builder.addListener((ServiceListener)verificationHandler);
        }
        return Collections.singleton(builder.install());
    }

    private static ServiceBuilder<?> buildCacheFactoryBuilder(ServiceTarget target, String name, String passivationStore) {
        if (passivationStore == null) {
            return new SimpleCacheFactoryBuilderService(name).build(target);
        }
        return new DelegateCacheFactoryBuilderService(name, DistributableCacheFactoryBuilderService.getServiceName(passivationStore)).build(target);
    }
}

