/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.webservices.deployers;

import javax.jws.WebService;
import org.jboss.as.server.deployment.Attachments;
import org.jboss.as.server.deployment.DeploymentPhaseContext;
import org.jboss.as.server.deployment.DeploymentUnit;
import org.jboss.as.server.deployment.DeploymentUnitProcessingException;
import org.jboss.as.server.deployment.DeploymentUnitProcessor;
import org.jboss.as.server.deployment.reflect.DeploymentReflectionIndex;
import org.jboss.as.webservices.WSLogger;
import org.jboss.as.webservices.WSMessages;
import org.jboss.as.webservices.metadata.model.AbstractEndpoint;
import org.jboss.as.webservices.metadata.model.JAXWSDeployment;
import org.jboss.as.webservices.util.WSAttachmentKeys;
import org.jboss.as.webservices.verification.JwsWebServiceEndpointVerifier;
import org.jboss.modules.Module;
import org.jboss.modules.ModuleClassLoader;

public class WSClassVerificationProcessor
implements DeploymentUnitProcessor {
    public void deploy(DeploymentPhaseContext phaseContext) throws DeploymentUnitProcessingException {
        DeploymentUnit unit = phaseContext.getDeploymentUnit();
        JAXWSDeployment wsDeployment = (JAXWSDeployment)unit.getAttachment(WSAttachmentKeys.JAXWS_ENDPOINTS_KEY);
        if (wsDeployment != null) {
            Module module = (Module)unit.getAttachment(Attachments.MODULE);
            DeploymentReflectionIndex deploymentReflectionIndex = (DeploymentReflectionIndex)unit.getAttachment(Attachments.REFLECTION_INDEX);
            ModuleClassLoader moduleClassLoader = module.getClassLoader();
            for (AbstractEndpoint pojoEndpoint : wsDeployment.getPojoEndpoints()) {
                this.verifyEndpoint(pojoEndpoint, (ClassLoader)moduleClassLoader, deploymentReflectionIndex);
            }
            for (AbstractEndpoint ejbEndpoint : wsDeployment.getEjbEndpoints()) {
                this.verifyEndpoint(ejbEndpoint, (ClassLoader)moduleClassLoader, deploymentReflectionIndex);
            }
        }
    }

    private void verifyEndpoint(AbstractEndpoint pojoEndpoint, ClassLoader moduleClassLoader, DeploymentReflectionIndex deploymentReflectionIndex) throws DeploymentUnitProcessingException {
        WSLogger.ROOT_LOGGER.tracef("Verifying web service endpoint class %s", pojoEndpoint.getClassName());
        try {
            Class<?> endpointClass = moduleClassLoader.loadClass(pojoEndpoint.getClassName());
            WebService webServiceAnnotation = endpointClass.getAnnotation(WebService.class);
            if (webServiceAnnotation != null) {
                this.verifyJwsEndpoint(endpointClass, webServiceAnnotation, moduleClassLoader, deploymentReflectionIndex);
            }
        }
        catch (ClassNotFoundException e) {
            throw WSMessages.MESSAGES.endpointClassNotFound(pojoEndpoint.getClassName());
        }
    }

    void verifyJwsEndpoint(Class<?> endpointClass, WebService webServiceAnnotation, ClassLoader moduleClassLoader, DeploymentReflectionIndex deploymentReflectionIndex) throws DeploymentUnitProcessingException {
        String endpointInterfaceClassName = webServiceAnnotation.endpointInterface();
        try {
            Class<?> endpointInterfaceClass = endpointInterfaceClassName.length() > 0 ? moduleClassLoader.loadClass(endpointInterfaceClassName) : null;
            JwsWebServiceEndpointVerifier wsEndpointVerifier = new JwsWebServiceEndpointVerifier(endpointClass, endpointInterfaceClass, deploymentReflectionIndex);
            wsEndpointVerifier.verify();
            if (wsEndpointVerifier.failed()) {
                wsEndpointVerifier.logFailures();
                throw WSMessages.MESSAGES.jwsWebServiceClassVerificationFailed(endpointClass);
            }
        }
        catch (ClassNotFoundException e) {
            throw WSMessages.MESSAGES.declaredEndpointInterfaceClassNotFound(endpointInterfaceClassName, endpointClass);
        }
    }

    public void undeploy(DeploymentUnit context) {
    }
}

