/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.webservices.deployers;

import java.util.List;
import org.jboss.as.ee.component.ComponentDescription;
import org.jboss.as.server.deployment.DeploymentUnit;
import org.jboss.as.server.deployment.DeploymentUnitProcessingException;
import org.jboss.as.server.deployment.annotation.CompositeIndex;
import org.jboss.as.webservices.deployers.AbstractIntegrationProcessorJAXWS;
import org.jboss.as.webservices.metadata.model.JAXWSDeployment;
import org.jboss.as.webservices.metadata.model.POJOEndpoint;
import org.jboss.as.webservices.util.ASHelper;
import org.jboss.as.webservices.util.DotNames;
import org.jboss.as.webservices.util.WSAttachmentKeys;
import org.jboss.as.webservices.util.WebMetaDataHelper;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.AnnotationValue;
import org.jboss.jandex.ClassInfo;
import org.jboss.metadata.web.jboss.JBossWebMetaData;
import org.jboss.metadata.web.spec.ServletMappingMetaData;
import org.jboss.metadata.web.spec.ServletMetaData;
import org.jboss.msc.service.ServiceName;
import org.jboss.wsf.spi.metadata.jms.JMSEndpointMetaData;
import org.jboss.wsf.spi.metadata.jms.JMSEndpointsMetaData;

public class WSIntegrationProcessorJAXWS_POJO
extends AbstractIntegrationProcessorJAXWS {
    public WSIntegrationProcessorJAXWS_POJO() {
        super(DotNames.WEB_SERVICE_ANNOTATION, DotNames.WEB_SERVICE_PROVIDER_ANNOTATION);
    }

    @Override
    protected void processAnnotation(DeploymentUnit unit, ClassInfo classInfo, AnnotationInstance wsAnnotation, CompositeIndex compositeIndex) throws DeploymentUnitProcessingException {
        if (WSIntegrationProcessorJAXWS_POJO.isEjb3(classInfo)) {
            return;
        }
        if (WSIntegrationProcessorJAXWS_POJO.isJmsEndpoint(unit, classInfo)) {
            return;
        }
        String endpointClassName = classInfo.name().toString();
        JBossWebMetaData jbossWebMD = ASHelper.getJBossWebMetaData(unit);
        if (jbossWebMD != null) {
            JAXWSDeployment jaxwsDeployment = ASHelper.getJaxwsDeployment(unit);
            boolean found = false;
            for (ServletMetaData servletMD : WebMetaDataHelper.getServlets(jbossWebMD)) {
                if (!endpointClassName.equals(ASHelper.getEndpointClassName(servletMD))) continue;
                found = true;
                String endpointName = ASHelper.getEndpointName(servletMD);
                ComponentDescription pojoComponent = WSIntegrationProcessorJAXWS_POJO.createComponentDescription(unit, endpointName, endpointClassName, endpointName);
                ServiceName pojoViewName = WSIntegrationProcessorJAXWS_POJO.registerView(pojoComponent, endpointClassName);
                String urlPattern = WSIntegrationProcessorJAXWS_POJO.getUrlPattern(endpointName, unit);
                jaxwsDeployment.addEndpoint(new POJOEndpoint(endpointName, endpointClassName, pojoViewName, urlPattern));
            }
            if (!found) {
                ComponentDescription pojoComponent = WSIntegrationProcessorJAXWS_POJO.createComponentDescription(unit, endpointClassName, endpointClassName, endpointClassName);
                ServiceName pojoViewName = WSIntegrationProcessorJAXWS_POJO.registerView(pojoComponent, endpointClassName);
                String urlPattern = WSIntegrationProcessorJAXWS_POJO.getUrlPattern(classInfo);
                jaxwsDeployment.addEndpoint(new POJOEndpoint(endpointClassName, pojoViewName, urlPattern));
            }
        }
    }

    private static String getUrlPattern(ClassInfo clazz) {
        AnnotationInstance webServiceAnnotation = WSIntegrationProcessorJAXWS_POJO.getWebServiceAnnotation(clazz);
        String serviceName = WSIntegrationProcessorJAXWS_POJO.getStringAttribute(webServiceAnnotation, "serviceName");
        return "/" + (serviceName != null ? serviceName : clazz.name().local());
    }

    private static String getUrlPattern(String servletName, DeploymentUnit unit) {
        JBossWebMetaData jbossWebMD = ASHelper.getJBossWebMetaData(unit);
        for (ServletMappingMetaData servletMappingMD : jbossWebMD.getServletMappings()) {
            if (!servletName.equals(servletMappingMD.getServletName())) continue;
            return (String)servletMappingMD.getUrlPatterns().get(0);
        }
        throw new IllegalStateException();
    }

    private static boolean isJmsEndpoint(DeploymentUnit unit, ClassInfo classInfo) {
        String endpointClassName = classInfo.name().toString();
        JMSEndpointsMetaData jmsEndpointsMD = ASHelper.getRequiredAttachment(unit, WSAttachmentKeys.JMS_ENDPOINT_METADATA_KEY);
        for (JMSEndpointMetaData endpoint : jmsEndpointsMD.getEndpointsMetaData()) {
            if (!endpointClassName.equals(endpoint.getImplementor())) continue;
            return true;
        }
        return false;
    }

    private static String getStringAttribute(AnnotationInstance annotation, String attributeName) {
        AnnotationValue attributeValue = annotation.value(attributeName);
        if (attributeValue != null) {
            String trimmedAttributeValue = attributeValue.asString().trim();
            return "".equals(trimmedAttributeValue) ? null : trimmedAttributeValue;
        }
        return null;
    }

    private static AnnotationInstance getWebServiceAnnotation(ClassInfo clazz) {
        List webServiceAnnotations = (List)clazz.annotations().get(DotNames.WEB_SERVICE_ANNOTATION);
        if (webServiceAnnotations != null && webServiceAnnotations.size() > 0) {
            return (AnnotationInstance)webServiceAnnotations.get(0);
        }
        List webServiceProviderAnnotations = (List)clazz.annotations().get(DotNames.WEB_SERVICE_PROVIDER_ANNOTATION);
        if (webServiceProviderAnnotations != null && webServiceProviderAnnotations.size() > 0) {
            return (AnnotationInstance)webServiceProviderAnnotations.get(0);
        }
        throw new IllegalStateException();
    }
}

