/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.account.freemarker.model;

import java.net.URI;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.ws.rs.core.UriBuilder;
import org.keycloak.models.RealmModel;
import org.keycloak.models.SocialLinkModel;
import org.keycloak.models.UserModel;
import org.keycloak.services.resources.flows.Urls;
import org.keycloak.social.SocialLoader;
import org.keycloak.social.SocialProvider;

public class AccountSocialBean {
    private final List<SocialLinkEntry> socialLinks;
    private final boolean removeLinkPossible;

    public AccountSocialBean(RealmModel realm, UserModel user, URI baseUri) {
        URI accountSocialUpdateUri = Urls.accountSocialUpdate((URI)baseUri, (String)realm.getName());
        this.socialLinks = new LinkedList<SocialLinkEntry>();
        Map socialConfig = realm.getSocialConfig();
        Set userSocialLinks = realm.getSocialLinks(user);
        int availableLinks = 0;
        if (socialConfig != null && !socialConfig.isEmpty()) {
            for (SocialProvider provider : SocialLoader.load()) {
                String socialProviderId = provider.getId();
                if (!socialConfig.containsKey(socialProviderId + ".key")) continue;
                SocialLinkModel socialLink = this.getSocialLink(userSocialLinks, socialProviderId);
                if (socialLink != null) {
                    ++availableLinks;
                }
                String action = socialLink != null ? "remove" : "add";
                String actionUrl = UriBuilder.fromUri((URI)accountSocialUpdateUri).queryParam("action", new Object[]{action}).queryParam("provider_id", new Object[]{socialProviderId}).build(new Object[0]).toString();
                SocialLinkEntry entry = new SocialLinkEntry(socialLink, provider.getName(), actionUrl);
                this.socialLinks.add(entry);
            }
        }
        this.removeLinkPossible = availableLinks > 1 || realm.getAuthenticationLink(user) != null;
    }

    private SocialLinkModel getSocialLink(Set<SocialLinkModel> userSocialLinks, String socialProviderId) {
        for (SocialLinkModel link : userSocialLinks) {
            if (!socialProviderId.equals(link.getSocialProvider())) continue;
            return link;
        }
        return null;
    }

    public List<SocialLinkEntry> getLinks() {
        return this.socialLinks;
    }

    public boolean isRemoveLinkPossible() {
        return this.removeLinkPossible;
    }

    public class SocialLinkEntry {
        private SocialLinkModel link;
        private final String providerName;
        private final String actionUrl;

        public SocialLinkEntry(SocialLinkModel link, String providerName, String actionUrl) {
            this.link = link;
            this.providerName = providerName;
            this.actionUrl = actionUrl;
        }

        public String getProviderId() {
            return this.link != null ? this.link.getSocialProvider() : null;
        }

        public String getProviderName() {
            return this.providerName;
        }

        public String getSocialUserId() {
            return this.link != null ? this.link.getSocialUserId() : null;
        }

        public String getSocialUsername() {
            return this.link != null ? this.link.getSocialUsername() : null;
        }

        public boolean isConnected() {
            return this.link != null;
        }

        public String getActionUrl() {
            return this.actionUrl;
        }
    }
}

