/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.domain.http.server;

import io.undertow.server.HttpServerExchange;
import io.undertow.util.HeaderMap;
import io.undertow.util.Headers;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import org.jboss.as.domain.http.server.Common;
import org.jboss.as.domain.http.server.OperationParameter;
import org.jboss.dmr.ModelNode;

public class DomainUtil {
    public static void writeResponse(HttpServerExchange exchange, int status, ModelNode response, OperationParameter operationParameter) {
        exchange.setResponseCode(status);
        HeaderMap responseHeaders = exchange.getResponseHeaders();
        String contentType = operationParameter.isEncode() ? "application/dmr-encoded" : "application/json";
        responseHeaders.put(Headers.CONTENT_TYPE, contentType + "; charset=" + Common.UTF_8);
        DomainUtil.writeCacheHeaders(exchange, status, operationParameter);
        if (operationParameter.isGet() && status == 200) {
            response = response.get("result");
        }
        try {
            byte[] data = DomainUtil.getResponseBytes(response, operationParameter);
            responseHeaders.put(Headers.CONTENT_LENGTH, (long)data.length);
            exchange.getResponseSender().send(ByteBuffer.wrap(data));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private static byte[] getResponseBytes(ModelNode modelNode, OperationParameter operationParameter) throws IOException {
        if (operationParameter.isEncode()) {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            BufferedOutputStream out = new BufferedOutputStream(baos);
            modelNode.writeBase64((OutputStream)out);
            out.flush();
            return baos.toByteArray();
        }
        String json = modelNode.toJSONString(!operationParameter.isPretty());
        return json.getBytes(Common.UTF_8);
    }

    public static void writeCacheHeaders(HttpServerExchange exchange, int status, OperationParameter operationParameter) {
        HeaderMap responseHeaders = exchange.getResponseHeaders();
        if (operationParameter.getMaxAge() > 0 && status != 304) {
            responseHeaders.put(Headers.CACHE_CONTROL, "max-age=" + operationParameter.getMaxAge() + ", private, must-revalidate");
        }
        if (operationParameter.getEtag() != null) {
            responseHeaders.put(Headers.ETAG, operationParameter.getEtag().toString());
        }
    }

    public static String constructUrl(HttpServerExchange exchange, String path) {
        HeaderMap headers = exchange.getRequestHeaders();
        String host = headers.getFirst(Headers.HOST);
        String protocol = exchange.getConnection().getSslSessionInfo() != null ? "https" : "http";
        return protocol + "://" + host + path;
    }
}

