/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.services.managers;

import org.keycloak.models.ApplicationModel;
import org.keycloak.models.ClientModel;
import org.keycloak.models.RealmModel;
import org.keycloak.models.UserModel;
import org.keycloak.representations.AccessToken;

public class Auth {
    private final boolean cookie;
    private final RealmModel realm;
    private final AccessToken token;
    private final UserModel user;
    private final ClientModel client;

    public Auth(RealmModel realm, AccessToken token, UserModel user, ClientModel client, boolean cookie) {
        this.cookie = cookie;
        this.token = token;
        this.realm = realm;
        this.user = user;
        this.client = client;
    }

    public boolean isCookie() {
        return this.cookie;
    }

    public RealmModel getRealm() {
        return this.realm;
    }

    public UserModel getUser() {
        return this.user;
    }

    public ClientModel getClient() {
        return this.client;
    }

    public AccessToken getToken() {
        return this.token;
    }

    public boolean hasRealmRole(String role) {
        if (this.cookie) {
            return this.realm.hasRole(this.user, this.realm.getRole(role));
        }
        AccessToken.Access access = this.token.getRealmAccess();
        return access != null && access.isUserInRole(role);
    }

    public boolean hasOneOfRealmRole(String ... roles) {
        for (String r : roles) {
            if (!this.hasRealmRole(r)) continue;
            return true;
        }
        return false;
    }

    public boolean hasAppRole(ApplicationModel app, String role) {
        if (this.cookie) {
            return this.realm.hasRole(this.user, app.getRole(role));
        }
        AccessToken.Access access = this.token.getResourceAccess(app.getName());
        return access != null && access.isUserInRole(role);
    }

    public boolean hasOneOfAppRole(ApplicationModel app, String ... roles) {
        for (String r : roles) {
            if (!this.hasAppRole(app, r)) continue;
            return true;
        }
        return false;
    }
}

