/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.undertow;

import io.undertow.server.handlers.MetricsHandler;
import io.undertow.servlet.api.DeploymentInfo;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.SimpleAttributeDefinition;
import org.jboss.as.controller.SimpleAttributeDefinitionBuilder;
import org.jboss.as.controller.SimpleResourceDefinition;
import org.jboss.as.controller.descriptions.ResourceDescriptionResolver;
import org.jboss.as.controller.registry.ManagementResourceRegistration;
import org.jboss.as.controller.registry.Resource;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;
import org.jboss.msc.service.ServiceController;
import org.wildfly.extension.undertow.DeploymentDefinition;
import org.wildfly.extension.undertow.UndertowExtension;
import org.wildfly.extension.undertow.UndertowService;
import org.wildfly.extension.undertow.deployment.UndertowDeploymentService;
import org.wildfly.extension.undertow.deployment.UndertowMetricsCollector;

public class DeploymentServletDefinition
extends SimpleResourceDefinition {
    public static final DeploymentServletDefinition INSTANCE = new DeploymentServletDefinition();
    static final SimpleAttributeDefinition MAX_REQUEST_TIME = new SimpleAttributeDefinitionBuilder("max-request-time", ModelType.LONG, true).setStorageRuntime().build();
    static final SimpleAttributeDefinition MIN_REQUEST_TIME = new SimpleAttributeDefinitionBuilder("min-request-time", ModelType.LONG, true).setStorageRuntime().build();
    static final SimpleAttributeDefinition TOTAL_REQUEST_TIME = new SimpleAttributeDefinitionBuilder("total-request-time", ModelType.LONG, true).setStorageRuntime().build();
    static final SimpleAttributeDefinition REQUEST_COUNT = new SimpleAttributeDefinitionBuilder("request-count", ModelType.LONG, true).setStorageRuntime().build();

    private DeploymentServletDefinition() {
        super(PathElement.pathElement((String)"servlet"), (ResourceDescriptionResolver)UndertowExtension.getResolver("deployment.servlet"));
    }

    public void registerAttributes(ManagementResourceRegistration registration) {
        registration.registerMetric((AttributeDefinition)MAX_REQUEST_TIME, (OperationStepHandler)new AbstractMetricsHandler(){

            @Override
            void handle(ModelNode response, String name, MetricsHandler.MetricResult metricResult) {
                response.set(metricResult.getMaxRequestTime());
            }
        });
        registration.registerMetric((AttributeDefinition)MIN_REQUEST_TIME, (OperationStepHandler)new AbstractMetricsHandler(){

            @Override
            void handle(ModelNode response, String name, MetricsHandler.MetricResult metricResult) {
                response.set(metricResult.getMinRequestTime());
            }
        });
        registration.registerMetric((AttributeDefinition)TOTAL_REQUEST_TIME, (OperationStepHandler)new AbstractMetricsHandler(){

            @Override
            void handle(ModelNode response, String name, MetricsHandler.MetricResult metricResult) {
                response.set(metricResult.getTotalRequestTime());
            }
        });
        registration.registerMetric((AttributeDefinition)REQUEST_COUNT, (OperationStepHandler)new AbstractMetricsHandler(){

            @Override
            void handle(ModelNode response, String name, MetricsHandler.MetricResult metricResult) {
                response.set(metricResult.getTotalRequests());
            }
        });
    }

    static abstract class AbstractMetricsHandler
    implements OperationStepHandler {
        AbstractMetricsHandler() {
        }

        abstract void handle(ModelNode var1, String var2, MetricsHandler.MetricResult var3);

        public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
            final PathAddress address = PathAddress.pathAddress((ModelNode)operation.get("address"));
            Resource web = context.readResourceFromRoot(address.subAddress(0, address.size() - 1), false);
            ModelNode subModel = web.getModel();
            String host = DeploymentDefinition.VIRTUAL_HOST.resolveModelAttribute(context, subModel).asString();
            String path = DeploymentDefinition.CONTEXT_ROOT.resolveModelAttribute(context, subModel).asString();
            String server = DeploymentDefinition.SERVER.resolveModelAttribute(context, subModel).asString();
            final ServiceController controller = context.getServiceRegistry(false).getService(UndertowService.deploymentServiceName(server, host, path));
            UndertowDeploymentService deploymentService = (UndertowDeploymentService)controller.getService();
            DeploymentInfo deploymentInfo = (DeploymentInfo)deploymentService.getDeploymentInfoInjectedValue().getValue();
            final UndertowMetricsCollector collector = (UndertowMetricsCollector)deploymentInfo.getMetricsCollector();
            context.addStep(new OperationStepHandler(){

                public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
                    if (controller != null) {
                        MetricsHandler.MetricResult result;
                        String name = address.getLastElement().getValue();
                        ModelNode response = new ModelNode();
                        MetricsHandler.MetricResult metricResult = result = collector != null ? collector.getMetrics(name) : null;
                        if (result == null) {
                            response.set(0);
                        } else {
                            AbstractMetricsHandler.this.handle(response, name, result);
                        }
                        context.getResult().set(response);
                    }
                    context.stepCompleted();
                }
            }, OperationContext.Stage.RUNTIME);
            context.stepCompleted();
        }
    }
}

