/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.undertow.filters;

import io.undertow.predicate.Predicate;
import io.undertow.predicate.PredicateParser;
import java.util.List;
import org.jboss.as.controller.AbstractAddStepHandler;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.ServiceVerificationHandler;
import org.jboss.dmr.ModelNode;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceTarget;
import org.wildfly.extension.undertow.UndertowService;
import org.wildfly.extension.undertow.filters.FilterRef;
import org.wildfly.extension.undertow.filters.FilterRefDefinition;
import org.wildfly.extension.undertow.filters.FilterService;

class FilterRefAdd
extends AbstractAddStepHandler {
    FilterRefAdd() {
        super(new AttributeDefinition[]{FilterRefDefinition.PREDICATE});
    }

    protected void performRuntime(OperationContext context, ModelNode operation, ModelNode model, ServiceVerificationHandler verificationHandler, List<ServiceController<?>> newControllers) throws OperationFailedException {
        PathAddress address = PathAddress.pathAddress((ModelNode)operation.get("address"));
        String name = address.getLastElement().getValue();
        Predicate predicate = null;
        if (model.hasDefined(FilterRefDefinition.PREDICATE.getName())) {
            String predicateString = model.get(FilterRefDefinition.PREDICATE.getName()).asString();
            predicate = PredicateParser.parse((String)predicateString, (ClassLoader)((Object)((Object)this)).getClass().getClassLoader());
        }
        FilterRef service = new FilterRef(predicate);
        ServiceTarget target = context.getServiceTarget();
        ServiceController sc = target.addService(UndertowService.getFilterRefServiceName(address, name), (Service)service).addDependency(UndertowService.FILTER.append(new String[]{name}), FilterService.class, service.getFilter()).setInitialMode(ServiceController.Mode.ACTIVE).install();
        if (newControllers != null) {
            newControllers.add(sc);
        }
    }
}

