/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.ejb.infinispan.group;

import java.util.HashMap;
import org.infinispan.Cache;
import org.infinispan.context.Flag;
import org.jboss.as.clustering.infinispan.invoker.CacheInvoker;
import org.jboss.as.clustering.infinispan.invoker.Creator;
import org.jboss.as.clustering.infinispan.invoker.Locator;
import org.jboss.as.clustering.infinispan.invoker.Mutator;
import org.jboss.as.clustering.infinispan.invoker.Remover;
import org.jboss.as.clustering.marshalling.MarshalledValueFactory;
import org.jboss.as.clustering.marshalling.MarshallingContext;
import org.wildfly.clustering.ejb.infinispan.BeanGroup;
import org.wildfly.clustering.ejb.infinispan.BeanGroupEntry;
import org.wildfly.clustering.ejb.infinispan.BeanGroupFactory;
import org.wildfly.clustering.ejb.infinispan.InfinispanEjbLogger;
import org.wildfly.clustering.ejb.infinispan.group.InfinispanBeanGroup;
import org.wildfly.clustering.ejb.infinispan.group.InfinispanBeanGroupEntry;

public class InfinispanBeanGroupFactory<G, I, T>
implements BeanGroupFactory<G, I, T> {
    private final Cache<G, BeanGroupEntry<I, T>> cache;
    private final CacheInvoker invoker;
    private final MarshalledValueFactory<MarshallingContext> factory;
    private final MarshallingContext context;

    public InfinispanBeanGroupFactory(Cache<G, BeanGroupEntry<I, T>> cache, CacheInvoker invoker, MarshalledValueFactory<MarshallingContext> factory, MarshallingContext context) {
        this.cache = cache;
        this.invoker = invoker;
        this.factory = factory;
        this.context = context;
    }

    public BeanGroupEntry<I, T> createValue(G id) {
        HashMap beans = new HashMap();
        InfinispanBeanGroupEntry entry = new InfinispanBeanGroupEntry(this.factory.createMarshalledValue(beans));
        InfinispanBeanGroupEntry existing = (InfinispanBeanGroupEntry)this.invoker.invoke(this.cache, (CacheInvoker.Operation)new Creator.CreateOperation(id, entry), new Flag[0]);
        return existing != null ? existing : entry;
    }

    public BeanGroupEntry<I, T> findValue(G id) {
        return (BeanGroupEntry)this.invoker.invoke(this.cache, (CacheInvoker.Operation)new Locator.FindOperation(id), new Flag[0]);
    }

    public void evict(G id) {
        try {
            this.cache.evict(id);
        }
        catch (Throwable e) {
            InfinispanEjbLogger.ROOT_LOGGER.failedToPassivateBeanGroup(e, id);
        }
    }

    public void remove(G id) {
        this.invoker.invoke(this.cache, (CacheInvoker.Operation)new Remover.RemoveOperation(id), new Flag[]{Flag.IGNORE_RETURN_VALUES});
    }

    @Override
    public BeanGroup<G, I, T> createGroup(G id, BeanGroupEntry<I, T> entry) {
        BeanGroupMutator<G, I, T> mutator = new BeanGroupMutator<G, I, T>(this.invoker, this.cache, id, entry);
        return new InfinispanBeanGroup<G, I, T>(id, entry, this.context, mutator, this);
    }

    private static class BeanGroupMutator<G, I, T>
    implements Mutator {
        private final CacheInvoker invoker;
        private final Cache<G, BeanGroupEntry<I, T>> cache;
        private final G id;
        private final BeanGroupEntry<I, T> entry;

        BeanGroupMutator(CacheInvoker invoker, Cache<G, BeanGroupEntry<I, T>> cache, G id, BeanGroupEntry<I, T> entry) {
            this.invoker = invoker;
            this.cache = cache;
            this.id = id;
            this.entry = entry;
        }

        public void mutate() {
            this.invoker.invoke(this.cache, (CacheInvoker.Operation)new Mutator.MutateOperation(this.id, this.entry), new Flag[]{Flag.IGNORE_RETURN_VALUES});
        }
    }
}

