/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.controller.operations.validation;

import java.util.ArrayList;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.jboss.as.controller.ControllerMessages;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.operations.validation.AllowedValuesValidator;
import org.jboss.as.controller.operations.validation.ModelTypeValidator;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;

public class EnumValidator<E extends Enum<E>>
extends ModelTypeValidator
implements AllowedValuesValidator {
    private final EnumSet<E> allowedValues;
    private final Class<E> enumType;
    private final Map<String, E> toStringMap = new HashMap<String, E>();

    public EnumValidator(Class<E> enumType, boolean nullable, E ... allowed) {
        this(enumType, nullable, false, (Enum[])allowed);
    }

    public EnumValidator(Class<E> enumType, boolean nullable, boolean allowExpressions) {
        super(ModelType.STRING, nullable, allowExpressions);
        this.enumType = enumType;
        this.allowedValues = EnumSet.allOf(enumType);
        for (Enum value : this.allowedValues) {
            this.toStringMap.put(value.toString(), value);
        }
    }

    public EnumValidator(Class<E> enumType, boolean nullable, boolean allowExpressions, E ... allowed) {
        super(ModelType.STRING, nullable, allowExpressions);
        this.enumType = enumType;
        this.allowedValues = EnumSet.noneOf(enumType);
        for (E value : allowed) {
            this.allowedValues.add(value);
            this.toStringMap.put(((Enum)value).toString(), value);
        }
    }

    public static <E extends Enum<E>> EnumValidator<E> create(Class<E> enumType, boolean nullable, E ... allowed) {
        return new EnumValidator(enumType, nullable, allowed);
    }

    public static <E extends Enum<E>> EnumValidator<E> create(Class<E> enumType, boolean nullable, boolean allowExpressions) {
        return new EnumValidator<E>(enumType, nullable, allowExpressions);
    }

    public static <E extends Enum<E>> EnumValidator<E> create(Class<E> enumType, boolean nullable, boolean allowExpressions, E ... allowed) {
        return new EnumValidator(enumType, nullable, allowExpressions, allowed);
    }

    @Override
    public void validateParameter(String parameterName, ModelNode value) throws OperationFailedException {
        super.validateParameter(parameterName, value);
        ModelType type = value.getType();
        if (type == ModelType.STRING || type == ModelType.EXPRESSION) {
            Object enumValue;
            String tuString = value.resolve().asString();
            try {
                enumValue = Enum.valueOf(this.enumType, tuString.toUpperCase(Locale.ENGLISH));
            }
            catch (IllegalArgumentException e) {
                enumValue = (Enum)this.toStringMap.get(tuString);
            }
            if (enumValue == null || !this.allowedValues.contains(enumValue)) {
                throw ControllerMessages.MESSAGES.invalidEnumValue(tuString, parameterName, this.toStringMap.keySet());
            }
            if (type != ModelType.EXPRESSION) {
                try {
                    value.set(((Enum)enumValue).toString());
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
        }
    }

    @Override
    public List<ModelNode> getAllowedValues() {
        ArrayList<ModelNode> result = new ArrayList<ModelNode>();
        for (Enum value : this.allowedValues) {
            if (value.toString() != null) {
                result.add(new ModelNode().set(value.toString()));
                continue;
            }
            result.add(new ModelNode().set(value.name()));
        }
        return result;
    }
}

