/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.controller.registry;

import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.ControllerMessages;
import org.jboss.as.controller.OperationDefinition;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.ProxyController;
import org.jboss.as.controller.ResourceDefinition;
import org.jboss.as.controller.access.management.AccessConstraintDefinition;
import org.jboss.as.controller.descriptions.DescriptionProvider;
import org.jboss.as.controller.descriptions.OverrideDescriptionProvider;
import org.jboss.as.controller.registry.AbstractResourceRegistration;
import org.jboss.as.controller.registry.AliasEntry;
import org.jboss.as.controller.registry.AliasStepHandler;
import org.jboss.as.controller.registry.AttributeAccess;
import org.jboss.as.controller.registry.ManagementResourceRegistration;
import org.jboss.as.controller.registry.NodeSubregistry;
import org.jboss.as.controller.registry.OperationEntry;
import org.jboss.dmr.ModelNode;

final class AliasResourceRegistration
extends AbstractResourceRegistration
implements DescriptionProvider {
    private final AliasEntry aliasEntry;
    private final AliasStepHandler handler;
    private final AbstractResourceRegistration target;

    AliasResourceRegistration(String valueString, NodeSubregistry parent, AliasEntry aliasEntry, AbstractResourceRegistration target) {
        super(valueString, parent);
        this.aliasEntry = aliasEntry;
        this.handler = new AliasStepHandler(aliasEntry);
        this.target = target;
    }

    @Override
    OperationEntry getOperationEntry(ListIterator<PathElement> iterator, String operationName, OperationEntry inherited) {
        OperationEntry targetOp = this.target.getOperationEntry(iterator, operationName, inherited);
        if (targetOp == null) {
            return null;
        }
        return new OperationEntry(this.handler, targetOp.getDescriptionProvider(), targetOp.isInherited(), targetOp.getType(), targetOp.getFlags(), null);
    }

    @Override
    OperationEntry getInheritableOperationEntry(String operationName) {
        return this.target.getInheritableOperationEntry(operationName);
    }

    @Override
    public boolean isRuntimeOnly() {
        return this.target.isRuntimeOnly();
    }

    @Override
    public void setRuntimeOnly(boolean runtimeOnly) {
        throw this.alreadyRegistered();
    }

    @Override
    public boolean isRemote() {
        return this.target.isRemote();
    }

    @Override
    public boolean isAlias() {
        return true;
    }

    @Override
    public List<AccessConstraintDefinition> getAccessConstraints() {
        return this.target.getAccessConstraints();
    }

    @Override
    public ManagementResourceRegistration registerSubModel(ResourceDefinition resourceDefinition) {
        throw this.alreadyRegistered();
    }

    @Override
    public void unregisterSubModel(PathElement address) throws IllegalArgumentException {
        throw this.alreadyRegistered();
    }

    @Override
    public ManagementResourceRegistration registerOverrideModel(String name, OverrideDescriptionProvider descriptionProvider) {
        throw this.alreadyRegistered();
    }

    @Override
    public void unregisterOverrideModel(String name) {
        throw this.alreadyRegistered();
    }

    @Override
    public void registerOperationHandler(String operationName, OperationStepHandler handler, DescriptionProvider descriptionProvider, boolean inherited, OperationEntry.EntryType entryType) {
        throw this.alreadyRegistered();
    }

    @Override
    public void registerOperationHandler(String operationName, OperationStepHandler handler, DescriptionProvider descriptionProvider, boolean inherited, OperationEntry.EntryType entryType, EnumSet<OperationEntry.Flag> flags) {
        throw this.alreadyRegistered();
    }

    @Override
    public void registerOperationHandler(OperationDefinition definition, OperationStepHandler handler, boolean inherited) {
        throw this.alreadyRegistered();
    }

    @Override
    public void unregisterOperationHandler(String operationName) {
        throw this.alreadyRegistered();
    }

    @Override
    public void registerReadWriteAttribute(String attributeName, OperationStepHandler readHandler, OperationStepHandler writeHandler, AttributeAccess.Storage storage) {
        throw this.alreadyRegistered();
    }

    @Override
    public void registerReadWriteAttribute(String attributeName, OperationStepHandler readHandler, OperationStepHandler writeHandler, EnumSet<AttributeAccess.Flag> flags) {
        throw this.alreadyRegistered();
    }

    @Override
    public void registerReadWriteAttribute(AttributeDefinition definition, OperationStepHandler readHandler, OperationStepHandler writeHandler) {
        throw this.alreadyRegistered();
    }

    @Override
    public void registerReadOnlyAttribute(String attributeName, OperationStepHandler readHandler, AttributeAccess.Storage storage) {
        throw this.alreadyRegistered();
    }

    @Override
    public void registerReadOnlyAttribute(String attributeName, OperationStepHandler readHandler, EnumSet<AttributeAccess.Flag> flags) {
        throw this.alreadyRegistered();
    }

    @Override
    public void registerReadOnlyAttribute(AttributeDefinition definition, OperationStepHandler readHandler) {
        throw this.alreadyRegistered();
    }

    @Override
    public void registerMetric(String attributeName, OperationStepHandler metricHandler) {
        throw this.alreadyRegistered();
    }

    @Override
    public void registerMetric(AttributeDefinition definition, OperationStepHandler metricHandler) {
        throw this.alreadyRegistered();
    }

    @Override
    public void registerMetric(String attributeName, OperationStepHandler metricHandler, EnumSet<AttributeAccess.Flag> flags) {
        throw this.alreadyRegistered();
    }

    @Override
    public void unregisterAttribute(String attributeName) {
        throw this.alreadyRegistered();
    }

    @Override
    public void registerProxyController(PathElement address, ProxyController proxyController) throws IllegalArgumentException {
        throw this.alreadyRegistered();
    }

    @Override
    public void unregisterProxyController(PathElement address) throws IllegalArgumentException {
        throw this.alreadyRegistered();
    }

    @Override
    public void registerAlias(PathElement address, AliasEntry alias) {
        throw this.alreadyRegistered();
    }

    @Override
    public void unregisterAlias(PathElement address) {
        throw this.alreadyRegistered();
    }

    @Override
    void getOperationDescriptions(ListIterator<PathElement> iterator, Map<String, OperationEntry> providers, boolean inherited) {
        HashMap<String, OperationEntry> temp = new HashMap<String, OperationEntry>();
        this.target.getOperationDescriptions(iterator, temp, inherited);
        for (Map.Entry<String, OperationEntry> entry : providers.entrySet()) {
            OperationEntry value = entry.getValue();
            providers.put(entry.getKey(), new OperationEntry(this.handler, value.getDescriptionProvider(), value.isInherited(), value.getType(), value.getFlags(), value.getAccessConstraints()));
        }
    }

    @Override
    void getInheritedOperationEntries(Map<String, OperationEntry> providers) {
        this.target.getInheritedOperationEntries(providers);
    }

    @Override
    DescriptionProvider getModelDescription(ListIterator<PathElement> iterator) {
        return this.target.getModelDescription(iterator);
    }

    @Override
    Set<String> getAttributeNames(ListIterator<PathElement> iterator) {
        return this.target.getAttributeNames(iterator);
    }

    @Override
    Set<String> getChildNames(ListIterator<PathElement> iterator) {
        return this.target.getChildNames(iterator);
    }

    @Override
    Set<PathElement> getChildAddresses(ListIterator<PathElement> iterator) {
        return this.target.getChildAddresses(iterator);
    }

    @Override
    AttributeAccess getAttributeAccess(ListIterator<PathElement> address, String attributeName) {
        return this.target.getAttributeAccess(address, attributeName);
    }

    @Override
    ProxyController getProxyController(ListIterator<PathElement> iterator) {
        return this.target.getProxyController(iterator);
    }

    @Override
    void getProxyControllers(ListIterator<PathElement> iterator, Set<ProxyController> controllers) {
    }

    @Override
    AbstractResourceRegistration getResourceRegistration(ListIterator<PathElement> iterator) {
        if (!iterator.hasNext()) {
            return this;
        }
        return this.target.getResourceRegistration(iterator);
    }

    @Override
    public ModelNode getModelDescription(Locale locale) {
        return new ModelNode();
    }

    private IllegalArgumentException alreadyRegistered() {
        return ControllerMessages.MESSAGES.aliasAlreadyRegistered(this.getLocationString());
    }

    @Override
    public AliasEntry getAliasEntry() {
        return this.aliasEntry;
    }

    @Override
    protected void registerAlias(PathElement address, AliasEntry alias, AbstractResourceRegistration target) {
        throw this.alreadyRegistered();
    }
}

