/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.query.collector.impl;

import java.io.IOException;
import org.apache.lucene.index.IndexReader;
import org.hibernate.search.bridge.TwoWayStringBridge;
import org.hibernate.search.query.collector.impl.FieldCacheCollector;
import org.hibernate.search.util.logging.impl.Log;
import org.hibernate.search.util.logging.impl.LoggerFactory;

public class TwoWayTransformingFieldCacheCollector
extends FieldCacheCollector {
    private static final Log log = LoggerFactory.make();
    private final TwoWayStringBridge stringBridge;
    private final FieldCacheCollector privateDelegate;

    public TwoWayTransformingFieldCacheCollector(FieldCacheCollector delegate, TwoWayStringBridge twoWayStringBridge) {
        super(delegate);
        this.privateDelegate = delegate;
        this.stringBridge = twoWayStringBridge;
    }

    @Override
    public void collect(int doc) throws IOException {
        this.delegate.collect(doc);
    }

    @Override
    public void setNextReader(IndexReader reader, int docBase) throws IOException {
        this.delegate.setNextReader(reader, docBase);
    }

    @Override
    public Object getValue(int docId) {
        String value = (String)this.privateDelegate.getValue(docId);
        if (value == null) {
            log.unexpectedValueMissingFromFieldCache();
            return null;
        }
        return this.stringBridge.stringToObject(value);
    }
}

