/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.domain.management.connections.ldap;

import java.util.List;
import org.jboss.as.controller.AbstractAddStepHandler;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.ServiceVerificationHandler;
import org.jboss.as.domain.management.SSLIdentity;
import org.jboss.as.domain.management.connections.ldap.LdapConnectionManagerService;
import org.jboss.as.domain.management.connections.ldap.LdapConnectionResourceDefinition;
import org.jboss.dmr.ModelNode;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceListener;
import org.jboss.msc.service.ServiceTarget;

public class LdapConnectionAddHandler
extends AbstractAddStepHandler {
    public static final LdapConnectionAddHandler INSTANCE = new LdapConnectionAddHandler();

    protected void populateModel(ModelNode operation, ModelNode model) throws OperationFailedException {
        for (AttributeDefinition attr : LdapConnectionResourceDefinition.ATTRIBUTE_DEFINITIONS) {
            attr.validateAndSet(operation, model);
        }
    }

    protected boolean requiresRuntime(OperationContext context) {
        return true;
    }

    protected void performRuntime(OperationContext context, ModelNode operation, ModelNode model, ServiceVerificationHandler verificationHandler, List<ServiceController<?>> controllers) throws OperationFailedException {
        ModelNode securityRealm;
        PathAddress address = PathAddress.pathAddress((ModelNode)operation.get("address"));
        String name = address.getLastElement().getValue();
        ServiceTarget serviceTarget = context.getServiceTarget();
        LdapConnectionManagerService connectionManagerService = new LdapConnectionManagerService();
        LdapConnectionAddHandler.updateRuntime(context, model, connectionManagerService);
        ServiceBuilder sb = serviceTarget.addService(LdapConnectionManagerService.ServiceUtil.createServiceName(name), (Service)connectionManagerService).setInitialMode(ServiceController.Mode.ON_DEMAND);
        if (verificationHandler != null) {
            sb.addListener((ServiceListener)verificationHandler);
        }
        if ((securityRealm = LdapConnectionResourceDefinition.SECURITY_REALM.resolveModelAttribute(context, model)).isDefined()) {
            SSLIdentity.ServiceUtil.addDependency(sb, connectionManagerService.getSSLIdentityInjector(), securityRealm.asString(), false);
        }
        ServiceController sc = sb.install();
        if (controllers != null) {
            controllers.add(sc);
        }
    }

    static LdapConnectionManagerService.Config updateRuntime(OperationContext context, ModelNode model, LdapConnectionManagerService connectionManagerService) throws OperationFailedException {
        String initialContextFactory = LdapConnectionResourceDefinition.INITIAL_CONTEXT_FACTORY.resolveModelAttribute(context, model).asString();
        String url = LdapConnectionResourceDefinition.URL.resolveModelAttribute(context, model).asString();
        ModelNode searchDnNode = LdapConnectionResourceDefinition.SEARCH_DN.resolveModelAttribute(context, model);
        String searchDn = searchDnNode.isDefined() ? searchDnNode.asString() : null;
        ModelNode searchCredentialNode = LdapConnectionResourceDefinition.SEARCH_CREDENTIAL.resolveModelAttribute(context, model);
        String searchCredential = searchCredentialNode.isDefined() ? searchCredentialNode.asString() : null;
        return connectionManagerService.setConfiguration(initialContextFactory, url, searchDn, searchCredential);
    }
}

