/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.domain.management.security;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.ServiceVerificationHandler;
import org.jboss.as.controller.registry.Resource;
import org.jboss.as.core.security.ServerSecurityManager;
import org.jboss.as.domain.management.AuthMechanism;
import org.jboss.as.domain.management.CallbackHandlerFactory;
import org.jboss.as.domain.management.SSLIdentity;
import org.jboss.as.domain.management.SecurityRealm;
import org.jboss.as.domain.management.connections.ldap.LdapConnectionManagerService;
import org.jboss.as.domain.management.security.AdvancedUserSearchResourceDefintion;
import org.jboss.as.domain.management.security.AuthenticationValidatingHandler;
import org.jboss.as.domain.management.security.AuthorizationValidatingHandler;
import org.jboss.as.domain.management.security.BaseLdapGroupSearchResource;
import org.jboss.as.domain.management.security.CallbackHandlerService;
import org.jboss.as.domain.management.security.ClientCertCallbackHandler;
import org.jboss.as.domain.management.security.FileKeystore;
import org.jboss.as.domain.management.security.FileKeystoreService;
import org.jboss.as.domain.management.security.GroupToPrincipalResourceDefinition;
import org.jboss.as.domain.management.security.JaasAuthenticationResourceDefinition;
import org.jboss.as.domain.management.security.JaasCallbackHandler;
import org.jboss.as.domain.management.security.KeystoreAttributes;
import org.jboss.as.domain.management.security.LdapAuthenticationResourceDefinition;
import org.jboss.as.domain.management.security.LdapAuthorizationResourceDefinition;
import org.jboss.as.domain.management.security.LdapCacheResourceDefinition;
import org.jboss.as.domain.management.security.LdapCacheService;
import org.jboss.as.domain.management.security.LdapEntry;
import org.jboss.as.domain.management.security.LdapGroupSearcherFactory;
import org.jboss.as.domain.management.security.LdapSearcher;
import org.jboss.as.domain.management.security.LdapSearcherCache;
import org.jboss.as.domain.management.security.LdapSubjectSupplementalService;
import org.jboss.as.domain.management.security.LdapUserSearcherFactory;
import org.jboss.as.domain.management.security.LocalAuthenticationResourceDefinition;
import org.jboss.as.domain.management.security.LocalCallbackHandlerService;
import org.jboss.as.domain.management.security.ManagementUtil;
import org.jboss.as.domain.management.security.PlugInAuthenticationCallbackHandler;
import org.jboss.as.domain.management.security.PlugInAuthenticationResourceDefinition;
import org.jboss.as.domain.management.security.PlugInAuthorizationResourceDefinition;
import org.jboss.as.domain.management.security.PlugInLoaderService;
import org.jboss.as.domain.management.security.PlugInSubjectSupplemental;
import org.jboss.as.domain.management.security.PrincipalToGroupResourceDefinition;
import org.jboss.as.domain.management.security.PropertiesAuthenticationResourceDefinition;
import org.jboss.as.domain.management.security.PropertiesAuthorizationResourceDefinition;
import org.jboss.as.domain.management.security.PropertiesCallbackHandler;
import org.jboss.as.domain.management.security.PropertiesSubjectSupplemental;
import org.jboss.as.domain.management.security.PropertyResourceDefinition;
import org.jboss.as.domain.management.security.SSLIdentityService;
import org.jboss.as.domain.management.security.SSLServerIdentityResourceDefinition;
import org.jboss.as.domain.management.security.SecretIdentityService;
import org.jboss.as.domain.management.security.SecretServerIdentityResourceDefinition;
import org.jboss.as.domain.management.security.SecurityRealmResourceDefinition;
import org.jboss.as.domain.management.security.SecurityRealmService;
import org.jboss.as.domain.management.security.SubjectSupplementalService;
import org.jboss.as.domain.management.security.UserDomainCallbackHandler;
import org.jboss.as.domain.management.security.UserIsDnResourceDefintion;
import org.jboss.as.domain.management.security.UserLdapCallbackHandler;
import org.jboss.as.domain.management.security.UserSearchResourceDefintion;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;
import org.jboss.dmr.Property;
import org.jboss.msc.inject.Injector;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceTarget;
import org.jboss.msc.value.InjectedSetValue;
import org.jboss.msc.value.InjectedValue;

public class SecurityRealmAddHandler
implements OperationStepHandler {
    public static final SecurityRealmAddHandler INSTANCE = new SecurityRealmAddHandler();

    public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
        ModelNode model = context.createResource(PathAddress.EMPTY_ADDRESS).getModel();
        SecurityRealmResourceDefinition.MAP_GROUPS_TO_ROLES.validateAndSet(operation, model);
        ModelNode validationOp = AuthenticationValidatingHandler.createOperation(operation);
        context.addStep(validationOp, (OperationStepHandler)AuthenticationValidatingHandler.INSTANCE, OperationContext.Stage.MODEL);
        validationOp = AuthorizationValidatingHandler.createOperation(operation);
        context.addStep(validationOp, (OperationStepHandler)AuthorizationValidatingHandler.INSTANCE, OperationContext.Stage.MODEL);
        context.addStep(new OperationStepHandler(){

            public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
                context.addStep((OperationStepHandler)ServiceInstallStepHandler.INSTANCE, OperationContext.Stage.RUNTIME);
                context.completeStep(OperationContext.RollbackHandler.NOOP_ROLLBACK_HANDLER);
            }
        }, OperationContext.Stage.RUNTIME);
        context.completeStep(OperationContext.RollbackHandler.NOOP_ROLLBACK_HANDLER);
    }

    protected void installServices(OperationContext context, String realmName, ModelNode model, ServiceVerificationHandler verificationHandler, List<ServiceController<?>> newControllers) throws OperationFailedException {
        ModelNode plugIns = model.hasDefined("plug-in") ? model.get("plug-in") : null;
        ModelNode authentication = model.hasDefined("authentication") ? model.get("authentication") : null;
        ModelNode authorization = model.hasDefined("authorization") ? model.get("authorization") : null;
        ModelNode serverIdentities = model.hasDefined("server-identity") ? model.get("server-identity") : null;
        ServiceTarget serviceTarget = context.getServiceTarget();
        boolean mapGroupsToRoles = SecurityRealmResourceDefinition.MAP_GROUPS_TO_ROLES.resolveModelAttribute(context, model).asBoolean();
        SecurityRealmService securityRealmService = new SecurityRealmService(realmName, mapGroupsToRoles);
        ServiceName realmServiceName = SecurityRealm.ServiceUtil.createServiceName(realmName);
        ServiceBuilder realmBuilder = serviceTarget.addService(realmServiceName, (Service)securityRealmService);
        boolean shareLdapConnections = this.shareLdapConnection(context, authentication, authorization);
        ModelNode authTruststore = null;
        if (plugIns != null) {
            this.addPlugInLoaderService(realmName, plugIns, serviceTarget, newControllers);
        }
        InjectedSetValue<CallbackHandlerService> injectorSet = securityRealmService.getCallbackHandlerService();
        if (authentication != null) {
            if (authentication.hasDefined("truststore")) {
                authTruststore = authentication.require("truststore");
                this.addClientCertService(realmName, serviceTarget, newControllers, realmBuilder, (Injector<CallbackHandlerService>)injectorSet.injector());
            }
            if (authentication.hasDefined("local")) {
                this.addLocalService(context, authentication.require("local"), realmName, serviceTarget, newControllers, realmBuilder, (Injector<CallbackHandlerService>)injectorSet.injector());
            }
            if (authentication.hasDefined("jaas")) {
                this.addJaasService(context, authentication.require("jaas"), realmName, serviceTarget, newControllers, context.isNormalServer(), realmBuilder, (Injector<CallbackHandlerService>)injectorSet.injector());
            } else if (authentication.hasDefined("ldap")) {
                this.addLdapService(context, authentication.require("ldap"), realmName, serviceTarget, newControllers, realmBuilder, (Injector<CallbackHandlerService>)injectorSet.injector(), shareLdapConnections);
            } else if (authentication.hasDefined("plug-in")) {
                this.addPlugInAuthenticationService(context, authentication.require("plug-in"), realmName, securityRealmService, serviceTarget, newControllers, realmBuilder, (Injector<CallbackHandlerService>)injectorSet.injector());
            } else if (authentication.hasDefined("properties")) {
                this.addPropertiesAuthenticationService(context, authentication.require("properties"), realmName, serviceTarget, newControllers, realmBuilder, (Injector<CallbackHandlerService>)injectorSet.injector());
            } else if (authentication.hasDefined("users")) {
                this.addUsersService(context, authentication.require("users"), realmName, serviceTarget, newControllers, realmBuilder, (Injector<CallbackHandlerService>)injectorSet.injector());
            }
        }
        if (authorization != null) {
            if (authorization.hasDefined("properties")) {
                this.addPropertiesAuthorizationService(context, authorization.require("properties"), realmName, serviceTarget, newControllers, realmBuilder, securityRealmService.getSubjectSupplementalInjector());
            } else if (authorization.hasDefined("plug-in")) {
                this.addPlugInAuthorizationService(context, authorization.require("plug-in"), realmName, serviceTarget, newControllers, realmBuilder, securityRealmService.getSubjectSupplementalInjector());
            } else if (authorization.hasDefined("ldap")) {
                this.addLdapAuthorizationService(context, authorization.require("ldap"), realmName, serviceTarget, newControllers, realmBuilder, securityRealmService.getSubjectSupplementalInjector(), shareLdapConnections);
            }
        }
        ModelNode ssl = null;
        if (serverIdentities != null) {
            if (serverIdentities.hasDefined("ssl")) {
                ssl = serverIdentities.require("ssl");
            }
            if (serverIdentities.hasDefined("secret")) {
                this.addSecretService(context, serverIdentities.require("secret"), realmName, serviceTarget, newControllers, (ServiceBuilder<?>)realmBuilder, (Injector<CallbackHandlerFactory>)securityRealmService.getSecretCallbackFactory());
            }
        }
        if (ssl != null || authTruststore != null) {
            this.addSSLService(context, ssl, authTruststore, realmName, serviceTarget, newControllers, realmBuilder, securityRealmService.getSSLIdentityInjector());
        }
        realmBuilder.setInitialMode(ServiceController.Mode.ACTIVE);
        ServiceController sc = realmBuilder.install();
        if (newControllers != null) {
            newControllers.add(sc);
        }
    }

    private boolean shareLdapConnection(OperationContext context, ModelNode authentication, ModelNode authorization) throws OperationFailedException {
        if (authentication == null || authorization == null || !authentication.hasDefined("ldap") || !authorization.hasDefined("ldap")) {
            return false;
        }
        String authConnectionManager = LdapAuthenticationResourceDefinition.CONNECTION.resolveModelAttribute(context, authentication.require("ldap")).asString();
        String authzConnectionManager = LdapAuthorizationResourceDefinition.CONNECTION.resolveModelAttribute(context, authorization.require("ldap")).asString();
        return authConnectionManager.equals(authzConnectionManager);
    }

    private ServiceName addPlugInLoaderService(String realmName, ModelNode plugInModel, ServiceTarget serviceTarget, List<ServiceController<?>> newControllers) {
        ServiceName plugInLoaderName = PlugInLoaderService.ServiceUtil.createServiceName(realmName);
        List plugIns = plugInModel.asPropertyList();
        ArrayList<String> knownNames = new ArrayList<String>(plugIns.size());
        for (Property current : plugIns) {
            knownNames.add(current.getName());
        }
        PlugInLoaderService loaderService = new PlugInLoaderService(Collections.unmodifiableList(knownNames));
        ServiceBuilder builder = serviceTarget.addService(plugInLoaderName, (Service)loaderService);
        ServiceController sc = builder.setInitialMode(ServiceController.Mode.ON_DEMAND).install();
        if (newControllers != null) {
            newControllers.add(sc);
        }
        return plugInLoaderName;
    }

    private void addClientCertService(String realmName, ServiceTarget serviceTarget, List<ServiceController<?>> newControllers, ServiceBuilder<?> realmBuilder, Injector<CallbackHandlerService> injector) {
        ServiceName clientCertServiceName = ClientCertCallbackHandler.ServiceUtil.createServiceName(realmName);
        ClientCertCallbackHandler clientCertCallbackHandler = new ClientCertCallbackHandler();
        ServiceBuilder ccBuilder = serviceTarget.addService(clientCertServiceName, (Service)clientCertCallbackHandler);
        ServiceController sc = ccBuilder.setInitialMode(ServiceController.Mode.ON_DEMAND).install();
        if (newControllers != null) {
            newControllers.add(sc);
        }
        CallbackHandlerService.ServiceUtil.addDependency(realmBuilder, injector, clientCertServiceName, false);
    }

    private void addJaasService(OperationContext context, ModelNode jaas, String realmName, ServiceTarget serviceTarget, List<ServiceController<?>> newControllers, boolean injectServerManager, ServiceBuilder<?> realmBuilder, Injector<CallbackHandlerService> injector) throws OperationFailedException {
        ServiceName jaasServiceName = JaasCallbackHandler.ServiceUtil.createServiceName(realmName);
        String name = JaasAuthenticationResourceDefinition.NAME.resolveModelAttribute(context, jaas).asString();
        JaasCallbackHandler jaasCallbackHandler = new JaasCallbackHandler(name);
        ServiceBuilder jaasBuilder = serviceTarget.addService(jaasServiceName, (Service)jaasCallbackHandler);
        if (injectServerManager) {
            jaasBuilder.addDependency(ServiceName.JBOSS.append(new String[]{"security", "simple-security-manager"}), ServerSecurityManager.class, jaasCallbackHandler.getSecurityManagerValue());
        }
        ServiceController sc = jaasBuilder.setInitialMode(ServiceController.Mode.ON_DEMAND).install();
        if (newControllers != null) {
            newControllers.add(sc);
        }
        CallbackHandlerService.ServiceUtil.addDependency(realmBuilder, injector, jaasServiceName, false);
    }

    private <R, K> LdapCacheService<R, K> createCacheService(OperationContext context, LdapSearcher<R, K> searcher, ModelNode cache) throws OperationFailedException {
        if (cache != null && cache.isDefined()) {
            ModelNode cacheDefinition = null;
            boolean byAccessTime = false;
            if (cache.hasDefined("by-access-time")) {
                cacheDefinition = cache.require("by-access-time");
                byAccessTime = true;
            } else if (cache.hasDefined("by-search-time")) {
                cacheDefinition = cache.require("by-search-time");
            }
            if (cacheDefinition != null) {
                int evictionTime = LdapCacheResourceDefinition.EVICTION_TIME.resolveModelAttribute(context, cacheDefinition).asInt();
                boolean cacheFailures = LdapCacheResourceDefinition.CACHE_FAILURES.resolveModelAttribute(context, cacheDefinition).asBoolean();
                int maxSize = LdapCacheResourceDefinition.MAX_CACHE_SIZE.resolveModelAttribute(context, cacheDefinition).asInt();
                return byAccessTime ? LdapCacheService.createByAccessCacheService(searcher, evictionTime, cacheFailures, maxSize) : LdapCacheService.createBySearchCacheService(searcher, evictionTime, cacheFailures, maxSize);
            }
        }
        return LdapCacheService.createNoCacheService(searcher);
    }

    private void addLdapService(OperationContext context, ModelNode ldap, String realmName, ServiceTarget serviceTarget, List<ServiceController<?>> newControllers, ServiceBuilder<?> realmBuilder, Injector<CallbackHandlerService> injector, boolean shareConnection) throws OperationFailedException {
        ServiceName ldapServiceName = UserLdapCallbackHandler.ServiceUtil.createServiceName(realmName);
        String baseDn = LdapAuthenticationResourceDefinition.BASE_DN.resolveModelAttribute(context, ldap).asString();
        ModelNode node = LdapAuthenticationResourceDefinition.USERNAME_FILTER.resolveModelAttribute(context, ldap);
        String usernameAttribute = node.isDefined() ? node.asString() : null;
        node = LdapAuthenticationResourceDefinition.ADVANCED_FILTER.resolveModelAttribute(context, ldap);
        String advancedFilter = node.isDefined() ? node.asString() : null;
        node = LdapAuthenticationResourceDefinition.USERNAME_LOAD.resolveModelAttribute(context, ldap);
        String usernameLoad = node.isDefined() ? node.asString() : null;
        boolean recursive = LdapAuthenticationResourceDefinition.RECURSIVE.resolveModelAttribute(context, ldap).asBoolean();
        boolean allowEmptyPasswords = LdapAuthenticationResourceDefinition.ALLOW_EMPTY_PASSWORDS.resolveModelAttribute(context, ldap).asBoolean();
        String userDn = LdapAuthenticationResourceDefinition.USER_DN.resolveModelAttribute(context, ldap).asString();
        UserLdapCallbackHandler ldapCallbackHandler = new UserLdapCallbackHandler(allowEmptyPasswords, shareConnection);
        LdapSearcher<LdapEntry, String> userSearcher = usernameAttribute != null ? LdapUserSearcherFactory.createForUsernameFilter(baseDn, recursive, userDn, usernameAttribute, usernameLoad) : LdapUserSearcherFactory.createForAdvancedFilter(baseDn, recursive, userDn, advancedFilter, usernameLoad);
        LdapCacheService<LdapEntry, String> cacheService = this.createCacheService(context, userSearcher, ldap.get("cache"));
        ServiceName userSearcherCacheName = LdapSearcherCache.ServiceUtil.createServiceName(true, true, realmName);
        ServiceController cacheServiceController = serviceTarget.addService(userSearcherCacheName, cacheService).setInitialMode(ServiceController.Mode.ON_DEMAND).install();
        newControllers.add(cacheServiceController);
        ServiceBuilder ldapBuilder = serviceTarget.addService(ldapServiceName, (Service)ldapCallbackHandler);
        String connectionManager = LdapAuthenticationResourceDefinition.CONNECTION.resolveModelAttribute(context, ldap).asString();
        LdapConnectionManagerService.ServiceUtil.addDependency(ldapBuilder, ldapCallbackHandler.getConnectionManagerInjector(), connectionManager, false);
        LdapSearcherCache.ServiceUtil.addDependency(ldapBuilder, LdapSearcherCache.class, ldapCallbackHandler.getLdapUserSearcherInjector(), true, true, realmName);
        ServiceController serviceController = ldapBuilder.setInitialMode(ServiceController.Mode.ON_DEMAND).install();
        if (newControllers != null) {
            newControllers.add(serviceController);
        }
        CallbackHandlerService.ServiceUtil.addDependency(realmBuilder, injector, ldapServiceName, false);
    }

    private void addLocalService(OperationContext context, ModelNode local, String realmName, ServiceTarget serviceTarget, List<ServiceController<?>> newControllers, ServiceBuilder<?> realmBuilder, Injector<CallbackHandlerService> injector) throws OperationFailedException {
        ServiceName localServiceName = LocalCallbackHandlerService.ServiceUtil.createServiceName(realmName);
        ModelNode node = LocalAuthenticationResourceDefinition.DEFAULT_USER.resolveModelAttribute(context, local);
        String defaultUser = node.isDefined() ? node.asString() : null;
        node = LocalAuthenticationResourceDefinition.ALLOWED_USERS.resolveModelAttribute(context, local);
        String allowedUsers = node.isDefined() ? node.asString() : null;
        LocalCallbackHandlerService localCallbackHandler = new LocalCallbackHandlerService(defaultUser, allowedUsers);
        ServiceBuilder jaasBuilder = serviceTarget.addService(localServiceName, (Service)localCallbackHandler);
        ServiceController serviceController = jaasBuilder.setInitialMode(ServiceController.Mode.ON_DEMAND).install();
        if (newControllers != null) {
            newControllers.add(serviceController);
        }
        CallbackHandlerService.ServiceUtil.addDependency(realmBuilder, injector, localServiceName, false);
    }

    private void addPlugInAuthenticationService(OperationContext context, ModelNode model, String realmName, SecurityRealmService registry, ServiceTarget serviceTarget, List<ServiceController<?>> newControllers, ServiceBuilder<?> realmBuilder, Injector<CallbackHandlerService> injector) throws OperationFailedException {
        ServiceName plugInServiceName = PlugInAuthenticationCallbackHandler.ServiceUtil.createServiceName(realmName);
        String pluginName = PlugInAuthorizationResourceDefinition.NAME.resolveModelAttribute(context, model).asString();
        Map<String, String> properties = SecurityRealmAddHandler.resolveProperties(context, model);
        String mechanismName = PlugInAuthenticationResourceDefinition.MECHANISM.resolveModelAttribute(context, model).asString();
        AuthMechanism mechanism = AuthMechanism.valueOf(mechanismName);
        PlugInAuthenticationCallbackHandler plugInService = new PlugInAuthenticationCallbackHandler(registry.getName(), pluginName, properties, mechanism);
        ServiceBuilder plugInBuilder = serviceTarget.addService(plugInServiceName, (Service)plugInService);
        PlugInLoaderService.ServiceUtil.addDependency(plugInBuilder, (InjectedValue<PlugInLoaderService>)plugInService.getPlugInLoaderServiceValue(), realmName, false);
        ServiceController sc = plugInBuilder.setInitialMode(ServiceController.Mode.ON_DEMAND).install();
        if (newControllers != null) {
            newControllers.add(sc);
        }
        CallbackHandlerService.ServiceUtil.addDependency(realmBuilder, injector, plugInServiceName, false);
    }

    private void addPropertiesAuthenticationService(OperationContext context, ModelNode properties, String realmName, ServiceTarget serviceTarget, List<ServiceController<?>> newControllers, ServiceBuilder<?> realmBuilder, Injector<CallbackHandlerService> injector) throws OperationFailedException {
        ServiceName propsServiceName = PropertiesCallbackHandler.ServiceUtil.createServiceName(realmName);
        String path = PropertiesAuthenticationResourceDefinition.PATH.resolveModelAttribute(context, properties).asString();
        ModelNode relativeTo = PropertiesAuthenticationResourceDefinition.RELATIVE_TO.resolveModelAttribute(context, properties);
        boolean plainText = PropertiesAuthenticationResourceDefinition.PLAIN_TEXT.resolveModelAttribute(context, properties).asBoolean();
        PropertiesCallbackHandler propsCallbackHandler = new PropertiesCallbackHandler(realmName, path, plainText);
        ServiceBuilder propsBuilder = serviceTarget.addService(propsServiceName, (Service)propsCallbackHandler);
        if (relativeTo.isDefined()) {
            propsBuilder.addDependency(SecurityRealmAddHandler.pathName(relativeTo.asString()), String.class, propsCallbackHandler.getRelativeToInjector());
        }
        ServiceController serviceController = propsBuilder.setInitialMode(ServiceController.Mode.ON_DEMAND).install();
        if (newControllers != null) {
            newControllers.add(serviceController);
        }
        CallbackHandlerService.ServiceUtil.addDependency(realmBuilder, injector, propsServiceName, false);
    }

    private void addPropertiesAuthorizationService(OperationContext context, ModelNode properties, String realmName, ServiceTarget serviceTarget, List<ServiceController<?>> newControllers, ServiceBuilder<?> realmBuilder, InjectedValue<SubjectSupplementalService> injector) throws OperationFailedException {
        ServiceName propsServiceName = PropertiesSubjectSupplemental.ServiceUtil.createServiceName(realmName);
        String path = PropertiesAuthorizationResourceDefinition.PATH.resolveModelAttribute(context, properties).asString();
        ModelNode relativeTo = PropertiesAuthorizationResourceDefinition.RELATIVE_TO.resolveModelAttribute(context, properties);
        PropertiesSubjectSupplemental propsSubjectSupplemental = new PropertiesSubjectSupplemental(realmName, path);
        ServiceBuilder propsBuilder = serviceTarget.addService(propsServiceName, (Service)propsSubjectSupplemental);
        if (relativeTo.isDefined()) {
            propsBuilder.addDependency(SecurityRealmAddHandler.pathName(relativeTo.asString()), String.class, propsSubjectSupplemental.getRelativeToInjector());
        }
        ServiceController serviceController = propsBuilder.setInitialMode(ServiceController.Mode.ON_DEMAND).install();
        if (newControllers != null) {
            newControllers.add(serviceController);
        }
        SubjectSupplementalService.ServiceUtil.addDependency(realmBuilder, injector, propsServiceName, false);
    }

    private void addPlugInAuthorizationService(OperationContext context, ModelNode model, String realmName, ServiceTarget serviceTarget, List<ServiceController<?>> newControllers, ServiceBuilder<?> realmBuilder, InjectedValue<SubjectSupplementalService> injector) throws OperationFailedException {
        ServiceName plugInServiceName = PlugInSubjectSupplemental.ServiceUtil.createServiceName(realmName);
        String pluginName = PlugInAuthorizationResourceDefinition.NAME.resolveModelAttribute(context, model).asString();
        Map<String, String> properties = SecurityRealmAddHandler.resolveProperties(context, model);
        PlugInSubjectSupplemental plugInSubjectSupplemental = new PlugInSubjectSupplemental(realmName, pluginName, properties);
        ServiceBuilder plugInBuilder = serviceTarget.addService(plugInServiceName, (Service)plugInSubjectSupplemental);
        PlugInLoaderService.ServiceUtil.addDependency(plugInBuilder, (InjectedValue<PlugInLoaderService>)plugInSubjectSupplemental.getPlugInLoaderServiceValue(), realmName, false);
        ServiceController serviceController = plugInBuilder.setInitialMode(ServiceController.Mode.ON_DEMAND).install();
        if (newControllers != null) {
            newControllers.add(serviceController);
        }
        SubjectSupplementalService.ServiceUtil.addDependency(realmBuilder, injector, plugInServiceName, false);
    }

    private void addLdapAuthorizationService(OperationContext context, ModelNode ldap, String realmName, ServiceTarget serviceTarget, List<ServiceController<?>> controllers, ServiceBuilder<?> realmBuilder, InjectedValue<SubjectSupplementalService> injector, boolean shareConnection) throws OperationFailedException {
        LdapSearcher<LdapEntry[], LdapEntry> groupSearcher;
        String groupNameAttribute;
        String groupDnAttribute;
        ServiceName ldapName = LdapSubjectSupplementalService.ServiceUtil.createServiceName(realmName);
        LdapSearcher<LdapEntry, String> userSearcher = null;
        boolean forceUserDnSearch = false;
        ModelNode userCache = null;
        if (ldap.hasDefined("username-to-dn")) {
            String userDnAttribute;
            boolean recursive;
            String baseDn;
            ModelNode usernameToDn = ldap.require("username-to-dn");
            if (usernameToDn.hasDefined("username-is-dn")) {
                ModelNode usernameIsDn = usernameToDn.require("username-is-dn");
                userCache = usernameIsDn.get("cache");
                forceUserDnSearch = UserIsDnResourceDefintion.FORCE.resolveModelAttribute(context, usernameIsDn).asBoolean();
                userSearcher = LdapUserSearcherFactory.createForUsernameIsDn();
            } else if (usernameToDn.hasDefined("username-filter")) {
                ModelNode usernameFilter = usernameToDn.require("username-filter");
                userCache = usernameFilter.get("cache");
                forceUserDnSearch = UserSearchResourceDefintion.FORCE.resolveModelAttribute(context, usernameFilter).asBoolean();
                baseDn = UserSearchResourceDefintion.BASE_DN.resolveModelAttribute(context, usernameFilter).asString();
                recursive = UserSearchResourceDefintion.RECURSIVE.resolveModelAttribute(context, usernameFilter).asBoolean();
                userDnAttribute = UserSearchResourceDefintion.USER_DN_ATTRIBUTE.resolveModelAttribute(context, usernameFilter).asString();
                String usernameAttribute = UserSearchResourceDefintion.ATTRIBUTE.resolveModelAttribute(context, usernameFilter).asString();
                userSearcher = LdapUserSearcherFactory.createForUsernameFilter(baseDn, recursive, userDnAttribute, usernameAttribute, null);
            } else if (usernameToDn.hasDefined("advanced-filter")) {
                ModelNode advancedFilter = usernameToDn.require("advanced-filter");
                userCache = advancedFilter.get("cache");
                forceUserDnSearch = AdvancedUserSearchResourceDefintion.FORCE.resolveModelAttribute(context, advancedFilter).asBoolean();
                baseDn = AdvancedUserSearchResourceDefintion.BASE_DN.resolveModelAttribute(context, advancedFilter).asString();
                recursive = AdvancedUserSearchResourceDefintion.RECURSIVE.resolveModelAttribute(context, advancedFilter).asBoolean();
                userDnAttribute = AdvancedUserSearchResourceDefintion.USER_DN_ATTRIBUTE.resolveModelAttribute(context, advancedFilter).asString();
                String filter = AdvancedUserSearchResourceDefintion.FILTER.resolveModelAttribute(context, advancedFilter).asString();
                userSearcher = LdapUserSearcherFactory.createForAdvancedFilter(baseDn, recursive, userDnAttribute, filter, null);
            }
        }
        if (userSearcher != null) {
            LdapCacheService userSearcherCache = this.createCacheService(context, userSearcher, userCache);
            ServiceName userSearcherCacheName = LdapSearcherCache.ServiceUtil.createServiceName(false, true, realmName);
            ServiceController userSearcherController = serviceTarget.addService(userSearcherCacheName, userSearcherCache).setInitialMode(ServiceController.Mode.ON_DEMAND).install();
            controllers.add(userSearcherController);
        }
        ModelNode groupSearch = ldap.require("group-search");
        boolean iterative = false;
        BaseLdapGroupSearchResource.GroupName groupName = BaseLdapGroupSearchResource.GroupName.DISTINGUISHED_NAME;
        ModelNode groupCache = null;
        if (groupSearch.hasDefined("group-to-principal")) {
            ModelNode groupToPrincipal = groupSearch.require("group-to-principal");
            groupCache = groupToPrincipal.get("cache");
            String baseDn = GroupToPrincipalResourceDefinition.BASE_DN.resolveModelAttribute(context, groupToPrincipal).asString();
            groupDnAttribute = GroupToPrincipalResourceDefinition.GROUP_DN_ATTRIBUTE.resolveModelAttribute(context, groupToPrincipal).asString();
            groupName = BaseLdapGroupSearchResource.GroupName.valueOf(GroupToPrincipalResourceDefinition.GROUP_NAME.resolveModelAttribute(context, groupToPrincipal).asString());
            groupNameAttribute = GroupToPrincipalResourceDefinition.GROUP_NAME_ATTRIBUTE.resolveModelAttribute(context, groupToPrincipal).asString();
            iterative = GroupToPrincipalResourceDefinition.ITERATIVE.resolveModelAttribute(context, groupToPrincipal).asBoolean();
            String principalAttribute = GroupToPrincipalResourceDefinition.PRINCIPAL_ATTRIBUTE.resolveModelAttribute(context, groupToPrincipal).asString();
            boolean recursive = GroupToPrincipalResourceDefinition.RECURSIVE.resolveModelAttribute(context, groupToPrincipal).asBoolean();
            BaseLdapGroupSearchResource.GroupName searchBy = BaseLdapGroupSearchResource.GroupName.valueOf(GroupToPrincipalResourceDefinition.SEARCH_BY.resolveModelAttribute(context, groupToPrincipal).asString());
            groupSearcher = LdapGroupSearcherFactory.createForGroupToPrincipal(baseDn, groupDnAttribute, groupNameAttribute, principalAttribute, recursive, searchBy);
        } else {
            ModelNode principalToGroup = groupSearch.require("principal-to-group");
            groupCache = principalToGroup.get("cache");
            String groupAttribute = PrincipalToGroupResourceDefinition.GROUP_ATTRIBUTE.resolveModelAttribute(context, principalToGroup).asString();
            groupDnAttribute = PrincipalToGroupResourceDefinition.GROUP_DN_ATTRIBUTE.resolveModelAttribute(context, principalToGroup).asString();
            groupName = BaseLdapGroupSearchResource.GroupName.valueOf(PrincipalToGroupResourceDefinition.GROUP_NAME.resolveModelAttribute(context, principalToGroup).asString());
            groupNameAttribute = PrincipalToGroupResourceDefinition.GROUP_NAME_ATTRIBUTE.resolveModelAttribute(context, principalToGroup).asString();
            iterative = PrincipalToGroupResourceDefinition.ITERATIVE.resolveModelAttribute(context, principalToGroup).asBoolean();
            groupSearcher = LdapGroupSearcherFactory.createForPrincipalToGroup(groupAttribute, groupNameAttribute);
        }
        LdapCacheService<LdapEntry[], LdapEntry> groupCacheService = this.createCacheService(context, groupSearcher, groupCache);
        ServiceName groupCacheServiceName = LdapSearcherCache.ServiceUtil.createServiceName(false, false, realmName);
        ServiceController groupSearcherCacheController = serviceTarget.addService(groupCacheServiceName, groupCacheService).setInitialMode(ServiceController.Mode.ON_DEMAND).install();
        controllers.add(groupSearcherCacheController);
        String connectionName = LdapAuthorizationResourceDefinition.CONNECTION.resolveModelAttribute(context, ldap).asString();
        LdapSubjectSupplementalService service = new LdapSubjectSupplementalService(realmName, shareConnection, forceUserDnSearch, iterative, groupName);
        ServiceBuilder ldapBuilder = serviceTarget.addService(ldapName, (Service)service).setInitialMode(ServiceController.Mode.ON_DEMAND);
        LdapConnectionManagerService.ServiceUtil.addDependency(ldapBuilder, service.getConnectionManagerInjector(), connectionName, false);
        if (userSearcher != null) {
            LdapSearcherCache.ServiceUtil.addDependency(ldapBuilder, LdapSearcherCache.class, service.getLdapUserSearcherInjector(), false, true, realmName);
        }
        LdapSearcherCache.ServiceUtil.addDependency(ldapBuilder, LdapSearcherCache.class, service.getLdapGroupSearcherInjector(), false, false, realmName);
        controllers.add(ldapBuilder.install());
        SubjectSupplementalService.ServiceUtil.addDependency(realmBuilder, injector, ldapName, false);
    }

    private void addSSLService(OperationContext context, ModelNode ssl, ModelNode trustStore, String realmName, ServiceTarget serviceTarget, List<ServiceController<?>> newControllers, ServiceBuilder<?> realmBuilder, InjectedValue<SSLIdentity> injector) throws OperationFailedException {
        ssl = ssl == null ? new ModelNode() : ssl;
        ServiceName sslServiceName = SSLIdentity.ServiceUtil.createServiceName(realmName);
        ServiceName keystoreServiceName = null;
        KeyPair pair = null;
        if (ssl.hasDefined("keystore-path")) {
            keystoreServiceName = FileKeystore.ServiceUtil.createKeystoreServiceName(realmName);
            pair = this.addFileKeystoreService(context, ssl, true, keystoreServiceName, serviceTarget, newControllers);
        }
        ServiceName truststoreServiceName = null;
        if (trustStore != null) {
            truststoreServiceName = FileKeystore.ServiceUtil.createTrusttoreServiceName(realmName);
            this.addFileKeystoreService(context, trustStore, false, truststoreServiceName, serviceTarget, newControllers);
        }
        String protocol = SSLServerIdentityResourceDefinition.PROTOCOL.resolveModelAttribute(context, ssl).asString();
        SSLIdentityService sslIdentityService = new SSLIdentityService(protocol, pair == null ? null : pair.keystorePassword, pair == null ? null : pair.keyPassword);
        ServiceBuilder sslBuilder = serviceTarget.addService(sslServiceName, (Service)sslIdentityService);
        if (keystoreServiceName != null) {
            FileKeystore.ServiceUtil.addDependency(sslBuilder, sslIdentityService.getKeyStoreInjector(), keystoreServiceName, false);
        }
        if (truststoreServiceName != null) {
            FileKeystore.ServiceUtil.addDependency(sslBuilder, sslIdentityService.getTrustStoreInjector(), truststoreServiceName, false);
        }
        ServiceController serviceController = sslBuilder.setInitialMode(ServiceController.Mode.ON_DEMAND).install();
        if (newControllers != null) {
            newControllers.add(serviceController);
        }
        SSLIdentity.ServiceUtil.addDependency(realmBuilder, injector, realmName, false);
    }

    private KeyPair addFileKeystoreService(OperationContext context, ModelNode ssl, boolean forKeyStore, ServiceName serviceName, ServiceTarget serviceTarget, List<ServiceController<?>> newControllers) throws OperationFailedException {
        FileKeystoreService fileKeystoreService;
        char[] keyPassword;
        char[] keystorePassword = KeystoreAttributes.KEYSTORE_PASSWORD.resolveModelAttribute(context, ssl).asString().toCharArray();
        String path = KeystoreAttributes.KEYSTORE_PATH.resolveModelAttribute(context, ssl).asString();
        if (forKeyStore) {
            ModelNode pwordNode = KeystoreAttributes.KEY_PASSWORD.resolveModelAttribute(context, ssl);
            keyPassword = pwordNode.isDefined() ? pwordNode.asString().toCharArray() : null;
            ModelNode aliasNode = KeystoreAttributes.ALIAS.resolveModelAttribute(context, ssl);
            String alias = aliasNode.isDefined() ? aliasNode.asString() : null;
            fileKeystoreService = FileKeystoreService.newKeyStoreService(path, keystorePassword, alias, keyPassword);
        } else {
            keyPassword = null;
            fileKeystoreService = FileKeystoreService.newTrustStoreService(path, keystorePassword);
        }
        ServiceBuilder serviceBuilder = serviceTarget.addService(serviceName, (Service)fileKeystoreService);
        ModelNode relativeTo = KeystoreAttributes.KEYSTORE_RELATIVE_TO.resolveModelAttribute(context, ssl);
        if (relativeTo.isDefined()) {
            serviceBuilder.addDependency(SecurityRealmAddHandler.pathName(relativeTo.asString()), String.class, fileKeystoreService.getRelativeToInjector());
        }
        ServiceController serviceController = serviceBuilder.setInitialMode(ServiceController.Mode.ON_DEMAND).install();
        if (newControllers != null) {
            newControllers.add(serviceController);
        }
        KeyPair pair = new KeyPair();
        KeyPair.access$102(pair, keystorePassword);
        KeyPair.access$202(pair, keyPassword);
        return pair;
    }

    private void addSecretService(OperationContext context, ModelNode secret, String realmName, ServiceTarget serviceTarget, List<ServiceController<?>> newControllers, ServiceBuilder<?> realmBuilder, Injector<CallbackHandlerFactory> injector) throws OperationFailedException {
        ServiceName secretServiceName = SecretIdentityService.ServiceUtil.createServiceName(realmName);
        ModelNode resolvedValueNode = SecretServerIdentityResourceDefinition.VALUE.resolveModelAttribute(context, secret);
        boolean base64 = secret.get(SecretServerIdentityResourceDefinition.VALUE.getName()).getType() != ModelType.EXPRESSION;
        SecretIdentityService sis = new SecretIdentityService(resolvedValueNode.asString(), base64);
        ServiceController serviceController = serviceTarget.addService(secretServiceName, (Service)sis).setInitialMode(ServiceController.Mode.ON_DEMAND).install();
        if (newControllers != null) {
            newControllers.add(serviceController);
        }
        CallbackHandlerFactory.ServiceUtil.addDependency(realmBuilder, injector, secretServiceName, false);
    }

    private void addUsersService(OperationContext context, ModelNode users, String realmName, ServiceTarget serviceTarget, List<ServiceController<?>> newControllers, ServiceBuilder<?> realmBuilder, Injector<CallbackHandlerService> injector) throws OperationFailedException {
        ServiceName usersServiceName = UserDomainCallbackHandler.ServiceUtil.createServiceName(realmName);
        UserDomainCallbackHandler usersCallbackHandler = new UserDomainCallbackHandler(realmName, this.unmaskUsersPasswords(context, users));
        ServiceBuilder usersBuilder = serviceTarget.addService(usersServiceName, (Service)usersCallbackHandler);
        ServiceController serviceController = usersBuilder.setInitialMode(ServiceController.Mode.ON_DEMAND).install();
        if (newControllers != null) {
            newControllers.add(serviceController);
        }
        CallbackHandlerService.ServiceUtil.addDependency(realmBuilder, injector, usersServiceName, false);
    }

    private static ServiceName pathName(String relativeTo) {
        return ServiceName.JBOSS.append(new String[]{"server", "path", relativeTo});
    }

    private ModelNode unmaskUsersPasswords(OperationContext context, ModelNode users) throws OperationFailedException {
        users = users.clone();
        for (Property property : users.get("user").asPropertyList()) {
            ModelNode user = users.get(new String[]{"user", property.getName()});
            if (!user.hasDefined("password")) continue;
            user.set("password", context.resolveExpressions(user.get("password")).asString());
        }
        return users;
    }

    private static Map<String, String> resolveProperties(OperationContext context, ModelNode model) throws OperationFailedException {
        Map<String, String> configurationProperties;
        if (model.hasDefined("property")) {
            List propertyList = model.require("property").asPropertyList();
            configurationProperties = new HashMap<String, String>(propertyList.size());
            for (Property current : propertyList) {
                String propertyName = current.getName();
                ModelNode valueNode = PropertyResourceDefinition.VALUE.resolveModelAttribute(context, current.getValue());
                String value = valueNode.isDefined() ? valueNode.asString() : null;
                configurationProperties.put(propertyName, value);
            }
            configurationProperties = Collections.unmodifiableMap(configurationProperties);
        } else {
            configurationProperties = Collections.emptyMap();
        }
        return configurationProperties;
    }

    private static class ServiceInstallStepHandler
    implements OperationStepHandler {
        private static final ServiceInstallStepHandler INSTANCE = new ServiceInstallStepHandler();

        private ServiceInstallStepHandler() {
        }

        public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
            final ArrayList newControllers = new ArrayList();
            String realmName = ManagementUtil.getSecurityRealmName(operation);
            ModelNode model = Resource.Tools.readModel((Resource)context.readResource(PathAddress.EMPTY_ADDRESS));
            INSTANCE.installServices(context, realmName, model, new ServiceVerificationHandler(), newControllers);
            context.completeStep(new OperationContext.RollbackHandler(){

                public void handleRollback(OperationContext context, ModelNode operation) {
                    for (ServiceController sc : newControllers) {
                        context.removeService(sc);
                    }
                }
            });
        }
    }

    private static class KeyPair {
        private char[] keystorePassword;
        private char[] keyPassword;

        private KeyPair() {
        }

        static /* synthetic */ char[] access$102(KeyPair x0, char[] x1) {
            x0.keystorePassword = x1;
            return x1;
        }

        static /* synthetic */ char[] access$202(KeyPair x0, char[] x1) {
            x0.keyPassword = x1;
            return x1;
        }
    }
}

