/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.domain.management.security;

import java.io.IOException;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import javax.naming.Context;
import javax.naming.NamingEnumeration;
import javax.naming.directory.DirContext;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.sasl.AuthorizeCallback;
import javax.security.sasl.RealmCallback;
import org.jboss.as.domain.management.AuthMechanism;
import org.jboss.as.domain.management.DomainManagementLogger;
import org.jboss.as.domain.management.DomainManagementMessages;
import org.jboss.as.domain.management.SecurityRealm;
import org.jboss.as.domain.management.connections.ConnectionManager;
import org.jboss.as.domain.management.security.CallbackHandlerService;
import org.jboss.as.domain.management.security.LdapEntry;
import org.jboss.as.domain.management.security.LdapSearcherCache;
import org.jboss.as.domain.management.security.SecurityRealmService;
import org.jboss.msc.inject.Injector;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.service.StopContext;
import org.jboss.msc.value.InjectedValue;
import org.jboss.sasl.callback.VerifyPasswordCallback;

public class UserLdapCallbackHandler
implements Service<CallbackHandlerService>,
CallbackHandlerService {
    private static final LdapSearcherCache.AttachmentKey<PasswordCredential> PASSWORD_KEY = LdapSearcherCache.AttachmentKey.create(PasswordCredential.class);
    private static final String SERVICE_SUFFIX = "ldap";
    public static final String DEFAULT_USER_DN = "dn";
    private final InjectedValue<ConnectionManager> connectionManager = new InjectedValue();
    private final InjectedValue<LdapSearcherCache<LdapEntry, String>> userSearcherInjector = new InjectedValue();
    private final boolean allowEmptyPassword;
    private final boolean shareConnection;
    protected final int searchTimeLimit = 10000;

    public UserLdapCallbackHandler(boolean allowEmptyPassword, boolean shareConnection) {
        this.allowEmptyPassword = allowEmptyPassword;
        this.shareConnection = shareConnection;
    }

    @Override
    public AuthMechanism getPreferredMechanism() {
        return AuthMechanism.PLAIN;
    }

    @Override
    public Set<AuthMechanism> getSupplementaryMechanisms() {
        return Collections.emptySet();
    }

    @Override
    public Map<String, String> getConfigurationOptions() {
        return Collections.singletonMap("org.jboss.as.domain.management.verify_password_callback_supported", Boolean.TRUE.toString());
    }

    @Override
    public boolean isReady() {
        return true;
    }

    @Override
    public CallbackHandler getCallbackHandler(Map<String, Object> sharedState) {
        return new LdapCallbackHandler(sharedState);
    }

    public void start(StartContext context) throws StartException {
    }

    public void stop(StopContext context) {
    }

    public CallbackHandlerService getValue() throws IllegalStateException, IllegalArgumentException {
        return this;
    }

    public InjectedValue<ConnectionManager> getConnectionManagerInjector() {
        return this.connectionManager;
    }

    public Injector<LdapSearcherCache<LdapEntry, String>> getLdapUserSearcherInjector() {
        return this.userSearcherInjector;
    }

    private void safeClose(Context context) {
        if (context != null) {
            try {
                context.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private void safeClose(NamingEnumeration ne) {
        if (ne != null) {
            try {
                ne.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private static final class PasswordCredential {
        private final String password;

        private PasswordCredential(String password) {
            this.password = password;
        }

        private boolean verify(String password) {
            return this.password.equals(password);
        }
    }

    public static final class ServiceUtil {
        private ServiceUtil() {
        }

        public static ServiceName createServiceName(String realmName) {
            return SecurityRealm.ServiceUtil.createServiceName(realmName).append(new String[]{UserLdapCallbackHandler.SERVICE_SUFFIX});
        }
    }

    private class LdapCallbackHandler
    implements CallbackHandler {
        private final Map<String, Object> sharedState;

        private LdapCallbackHandler(Map<String, Object> sharedState) {
            this.sharedState = sharedState;
        }

        @Override
        public void handle(Callback[] callbacks) throws IOException, UnsupportedCallbackException {
            if (callbacks.length == 1 && callbacks[0] instanceof AuthorizeCallback) {
                String authorizationId;
                AuthorizeCallback acb = (AuthorizeCallback)callbacks[0];
                String authenticationId = acb.getAuthenticationID();
                boolean authorized = authenticationId.equals(authorizationId = acb.getAuthorizationID());
                if (!authorized) {
                    DomainManagementLogger.SECURITY_LOGGER.tracef("Checking 'AuthorizeCallback', authorized=false, authenticationID=%s, authorizationID=%s.", authenticationId, authorizationId);
                }
                acb.setAuthorized(authorized);
                return;
            }
            final ConnectionManager connectionManager = (ConnectionManager)UserLdapCallbackHandler.this.connectionManager.getValue();
            VerifyPasswordCallback verifyPasswordCallback = null;
            String username = null;
            for (Callback current : callbacks) {
                if (current instanceof NameCallback) {
                    username = ((NameCallback)current).getDefaultName();
                    continue;
                }
                if (current instanceof RealmCallback) continue;
                if (current instanceof VerifyPasswordCallback) {
                    verifyPasswordCallback = (VerifyPasswordCallback)current;
                    continue;
                }
                throw new UnsupportedCallbackException(current);
            }
            if (username == null || username.length() == 0) {
                DomainManagementLogger.SECURITY_LOGGER.trace("No username or 0 length username supplied.");
                throw DomainManagementMessages.MESSAGES.noUsername();
            }
            if (verifyPasswordCallback == null) {
                DomainManagementLogger.SECURITY_LOGGER.trace("No password supplied.");
                throw DomainManagementMessages.MESSAGES.noPassword();
            }
            String password = verifyPasswordCallback.getPassword();
            if (password == null || !UserLdapCallbackHandler.this.allowEmptyPassword && password.length() == 0) {
                DomainManagementLogger.SECURITY_LOGGER.trace("No password or 0 length password supplied.");
                throw DomainManagementMessages.MESSAGES.noPassword();
            }
            final VerifyPasswordCallback theVpc = verifyPasswordCallback;
            LdapSearcherCache.DirContextFactory dcf = new LdapSearcherCache.DirContextFactory(){
                private DirContext context;

                @Override
                public DirContext getDirContext() throws IOException {
                    if (this.context != null) {
                        return this.context;
                    }
                    try {
                        this.context = (DirContext)connectionManager.getConnection();
                        return this.context;
                    }
                    catch (Exception e) {
                        if (e instanceof IOException) {
                            throw (IOException)e;
                        }
                        throw new IOException(e);
                    }
                }

                @Override
                public void close() {
                    LdapCallbackHandler.this.safeClose(theVpc, this.context);
                }
            };
            DirContext userContext = null;
            try {
                LdapSearcherCache.SearchResult searchResult = ((LdapSearcherCache)UserLdapCallbackHandler.this.userSearcherInjector.getValue()).search(dcf, username);
                LdapEntry ldapEntry = (LdapEntry)searchResult.getResult();
                PasswordCredential cachedCredential = (PasswordCredential)searchResult.getAttachment(PASSWORD_KEY);
                if (cachedCredential != null) {
                    if (cachedCredential.verify(password)) {
                        DomainManagementLogger.SECURITY_LOGGER.tracef("Password verified for user '%s' (using cached password)", username);
                        verifyPasswordCallback.setVerified(true);
                        this.sharedState.put(LdapEntry.class.getName(), ldapEntry);
                        if (!username.equals(ldapEntry.getSimpleName())) {
                            this.sharedState.put(SecurityRealmService.LOADED_USERNAME_KEY, ldapEntry.getSimpleName());
                        }
                    } else {
                        DomainManagementLogger.SECURITY_LOGGER.tracef("Password verification failed for user (using cached password) '%s'", username);
                        verifyPasswordCallback.setVerified(false);
                    }
                } else {
                    try {
                        userContext = (DirContext)connectionManager.getConnection(ldapEntry.getDistinguishedName(), password);
                        if (userContext != null) {
                            DomainManagementLogger.SECURITY_LOGGER.tracef("Password verified for user '%s' (using connection attempt)", username);
                            verifyPasswordCallback.setVerified(true);
                            searchResult.attach(PASSWORD_KEY, new PasswordCredential(password));
                            this.sharedState.put(LdapEntry.class.getName(), ldapEntry);
                            if (!username.equals(ldapEntry.getSimpleName())) {
                                this.sharedState.put(SecurityRealmService.LOADED_USERNAME_KEY, ldapEntry.getSimpleName());
                            }
                        }
                    }
                    catch (Exception e) {
                        DomainManagementLogger.SECURITY_LOGGER.tracef("Password verification failed for user (using connection attempt) '%s'", username);
                        verifyPasswordCallback.setVerified(false);
                    }
                }
                dcf.close();
            }
            catch (Exception e) {
                try {
                    DomainManagementLogger.SECURITY_LOGGER.trace("Unable to verify identity.", e);
                    throw DomainManagementMessages.MESSAGES.cannotPerformVerification(e);
                }
                catch (Throwable throwable) {
                    dcf.close();
                    UserLdapCallbackHandler.this.safeClose(userContext);
                    throw throwable;
                }
            }
            UserLdapCallbackHandler.this.safeClose(userContext);
        }

        private void safeClose(VerifyPasswordCallback vpc, DirContext context) {
            if (UserLdapCallbackHandler.this.shareConnection && context != null && vpc != null && vpc.isVerified()) {
                this.sharedState.put(DirContext.class.getName(), context);
            } else {
                UserLdapCallbackHandler.this.safeClose(context);
            }
        }
    }
}

