/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.configuration.parsing;

import java.util.ArrayDeque;
import java.util.Deque;
import javax.xml.namespace.NamespaceContext;
import javax.xml.namespace.QName;
import javax.xml.stream.Location;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.infinispan.configuration.parsing.ConfigurationBuilderHolder;
import org.infinispan.configuration.parsing.NamespaceMappingParser;
import org.infinispan.configuration.parsing.XMLExtendedStreamReader;

final class XMLExtendedStreamReaderImpl
implements XMLExtendedStreamReader {
    private final NamespaceMappingParser parser;
    private final XMLStreamReader streamReader;
    private final Deque<Context> stack = new ArrayDeque<Context>();

    XMLExtendedStreamReaderImpl(NamespaceMappingParser parser, XMLStreamReader streamReader) {
        this.parser = parser;
        this.streamReader = streamReader;
        this.stack.push(new Context());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void handleAny(ConfigurationBuilderHolder holder) throws XMLStreamException {
        this.require(1, null, null);
        boolean ok = false;
        try {
            Deque<Context> stack = this.stack;
            stack.push(new Context());
            try {
                this.parser.parseElement(this, holder);
            }
            finally {
                stack.pop();
            }
            ok = true;
        }
        finally {
            if (!ok) {
                this.safeClose();
            }
        }
    }

    @Override
    public Object getProperty(String name) throws IllegalArgumentException {
        return this.streamReader.getProperty(name);
    }

    @Override
    public int next() throws XMLStreamException {
        Context context = this.stack.getFirst();
        if (context.depth > 0) {
            int next = this.streamReader.next();
            if (next == 2) {
                --context.depth;
            } else if (next == 1) {
                ++context.depth;
            }
            return next;
        }
        try {
            throw XMLExtendedStreamReaderImpl.readPastEnd(this.getLocation());
        }
        catch (Throwable throwable) {
            this.safeClose();
            throw throwable;
        }
    }

    @Override
    public void require(int type, String namespaceURI, String localName) throws XMLStreamException {
        this.streamReader.require(type, namespaceURI, localName);
    }

    @Override
    public String getElementText() throws XMLStreamException {
        return this.streamReader.getElementText().trim();
    }

    @Override
    public int nextTag() throws XMLStreamException {
        Context context = this.stack.getFirst();
        if (context.depth > 0) {
            int next = this.streamReader.nextTag();
            if (next == 2) {
                --context.depth;
            } else if (next == 1) {
                ++context.depth;
            }
            return next;
        }
        try {
            throw XMLExtendedStreamReaderImpl.readPastEnd(this.getLocation());
        }
        catch (Throwable throwable) {
            this.safeClose();
            throw throwable;
        }
    }

    @Override
    public boolean hasNext() throws XMLStreamException {
        return this.stack.getFirst().depth > 0 && this.streamReader.hasNext();
    }

    @Override
    public void close() throws XMLStreamException {
        throw new UnsupportedOperationException();
    }

    @Override
    public String getNamespaceURI(String prefix) {
        return this.streamReader.getNamespaceURI(prefix);
    }

    @Override
    public boolean isStartElement() {
        return this.streamReader.isStartElement();
    }

    @Override
    public boolean isEndElement() {
        return this.streamReader.isEndElement();
    }

    @Override
    public boolean isCharacters() {
        return this.streamReader.isCharacters();
    }

    @Override
    public boolean isWhiteSpace() {
        return this.streamReader.isWhiteSpace();
    }

    @Override
    public String getAttributeValue(String namespaceURI, String localName) {
        return this.streamReader.getAttributeValue(namespaceURI, localName);
    }

    @Override
    public int getAttributeCount() {
        return this.streamReader.getAttributeCount();
    }

    @Override
    public QName getAttributeName(int index) {
        return this.streamReader.getAttributeName(index);
    }

    @Override
    public String getAttributeNamespace(int index) {
        return this.streamReader.getAttributeNamespace(index);
    }

    @Override
    public String getAttributeLocalName(int index) {
        return this.streamReader.getAttributeLocalName(index);
    }

    @Override
    public String getAttributePrefix(int index) {
        return this.streamReader.getAttributePrefix(index);
    }

    @Override
    public String getAttributeType(int index) {
        return this.streamReader.getAttributeType(index);
    }

    @Override
    public String getAttributeValue(int index) {
        return this.streamReader.getAttributeValue(index);
    }

    @Override
    public boolean isAttributeSpecified(int index) {
        return this.streamReader.isAttributeSpecified(index);
    }

    @Override
    public int getNamespaceCount() {
        return this.streamReader.getNamespaceCount();
    }

    @Override
    public String getNamespacePrefix(int index) {
        return this.streamReader.getNamespacePrefix(index);
    }

    @Override
    public String getNamespaceURI(int index) {
        return this.streamReader.getNamespaceURI(index);
    }

    @Override
    public NamespaceContext getNamespaceContext() {
        return this.streamReader.getNamespaceContext();
    }

    @Override
    public int getEventType() {
        return this.streamReader.getEventType();
    }

    @Override
    public String getText() {
        return this.streamReader.getText();
    }

    @Override
    public char[] getTextCharacters() {
        return this.streamReader.getTextCharacters();
    }

    @Override
    public int getTextCharacters(int sourceStart, char[] target, int targetStart, int length) throws XMLStreamException {
        return this.streamReader.getTextCharacters(sourceStart, target, targetStart, length);
    }

    @Override
    public int getTextStart() {
        return this.streamReader.getTextStart();
    }

    @Override
    public int getTextLength() {
        return this.streamReader.getTextLength();
    }

    @Override
    public String getEncoding() {
        return this.streamReader.getEncoding();
    }

    @Override
    public boolean hasText() {
        return this.streamReader.hasText();
    }

    @Override
    public Location getLocation() {
        return this.streamReader.getLocation();
    }

    @Override
    public QName getName() {
        return this.streamReader.getName();
    }

    @Override
    public String getLocalName() {
        return this.streamReader.getLocalName();
    }

    @Override
    public boolean hasName() {
        return this.streamReader.hasName();
    }

    @Override
    public String getNamespaceURI() {
        return this.streamReader.getNamespaceURI();
    }

    @Override
    public String getPrefix() {
        return this.streamReader.getPrefix();
    }

    @Override
    public String getVersion() {
        return this.streamReader.getVersion();
    }

    @Override
    public boolean isStandalone() {
        return this.streamReader.isStandalone();
    }

    @Override
    public boolean standaloneSet() {
        return this.streamReader.standaloneSet();
    }

    @Override
    public String getCharacterEncodingScheme() {
        return this.streamReader.getCharacterEncodingScheme();
    }

    @Override
    public String getPITarget() {
        return this.streamReader.getPITarget();
    }

    @Override
    public String getPIData() {
        return this.streamReader.getPIData();
    }

    private void safeClose() {
        try {
            this.streamReader.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private static XMLStreamException readPastEnd(Location location) {
        return new XMLStreamException("Attempt to read past end of element", location);
    }

    private static final class Context {
        int depth = 1;

        private Context() {
        }
    }
}

