/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.orb.giop;

import java.io.IOException;
import org.jacorb.orb.SystemExceptionHelper;
import org.jacorb.orb.giop.Messages;
import org.jacorb.orb.giop.ServiceContextTransportingInputStream;
import org.omg.CORBA.INTERNAL;
import org.omg.CORBA.MARSHAL;
import org.omg.CORBA.ORB;
import org.omg.CORBA.portable.ApplicationException;
import org.omg.GIOP.ReplyHeader_1_0;
import org.omg.GIOP.ReplyHeader_1_0Helper;
import org.omg.GIOP.ReplyHeader_1_2;
import org.omg.GIOP.ReplyHeader_1_2Helper;
import org.omg.GIOP.ReplyStatusType_1_2;
import org.omg.IOP.ServiceContext;
import org.omg.PortableServer.ForwardRequest;

public class ReplyInputStream
extends ServiceContextTransportingInputStream {
    public final ReplyHeader_1_2 rep_hdr;
    private final int body_start;

    public ReplyInputStream(ORB orb, byte[] buffer) {
        super(orb, buffer);
        if (Messages.getMsgType(buffer) != 1) {
            throw new MARSHAL("Not a reply!");
        }
        switch (this.giop_minor) {
            case 0: 
            case 1: {
                ReplyHeader_1_0 hdr = ReplyHeader_1_0Helper.read(this);
                this.body_start = this.pos;
                this.rep_hdr = new ReplyHeader_1_2(hdr.request_id, ReplyStatusType_1_2.from_int(hdr.reply_status.value()), hdr.service_context);
                break;
            }
            case 2: {
                this.rep_hdr = ReplyHeader_1_2Helper.read(this);
                this.skipHeaderPadding();
                this.body_start = this.pos;
                break;
            }
            default: {
                throw new MARSHAL("Unknown GIOP minor version: " + this.giop_minor);
            }
        }
    }

    public ReplyStatusType_1_2 getStatus() {
        return this.rep_hdr.reply_status;
    }

    public synchronized Exception getException() {
        switch (this.rep_hdr.reply_status.value()) {
            case 1: {
                this.mark(0);
                String id = this.read_string();
                try {
                    this.reset();
                }
                catch (IOException e) {
                    throw new INTERNAL("should never happen: " + e.toString());
                }
                return new ApplicationException(id, this);
            }
            case 2: {
                return SystemExceptionHelper.read(this);
            }
            case 3: 
            case 4: {
                return new ForwardRequest(this.read_Object());
            }
        }
        return null;
    }

    public ServiceContext getServiceContext(int id) {
        if (this.rep_hdr.service_context != null) {
            for (int i = 0; i < this.rep_hdr.service_context.length; ++i) {
                if (this.rep_hdr.service_context[i].context_id != id) continue;
                return this.rep_hdr.service_context[i];
            }
        }
        return null;
    }

    public byte[] getBody() {
        int body_length = this.msg_size - (this.body_start - 12);
        byte[] body = new byte[body_length];
        System.arraycopy(this.buffer, this.body_start, body, 0, body_length);
        return body;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void finalize() throws Throwable {
        try {
            this.close();
        }
        finally {
            super.finalize();
        }
    }
}

