/*
 * Decompiled with CFR 0.152.
 */
package org.jberet.repository;

import java.util.Properties;
import org.jberet._private.BatchMessages;
import org.jberet.repository.InMemoryRepository;
import org.jberet.repository.JdbcRepository;
import org.jberet.repository.JobRepository;
import org.jberet.spi.BatchEnvironment;

public final class JobRepositoryFactory {
    public static final String JOB_REPOSITORY_TYPE_KEY = "job-repository-type";
    public static final String REPOSITORY_TYPE_IN_MEMORY = "in-memory";
    public static final String REPOSITORY_TYPE_JDBC = "jdbc";

    private JobRepositoryFactory() {
    }

    public static JobRepository getJobRepository(BatchEnvironment batchEnvironment) {
        Properties configProperties;
        String repositoryType = null;
        if (batchEnvironment != null && (repositoryType = (configProperties = batchEnvironment.getBatchConfigurationProperties()).getProperty(JOB_REPOSITORY_TYPE_KEY)) != null) {
            repositoryType = repositoryType.trim();
        }
        if (repositoryType == null || repositoryType.isEmpty() || repositoryType.equalsIgnoreCase(REPOSITORY_TYPE_JDBC)) {
            return JdbcRepository.getInstance(batchEnvironment);
        }
        if (repositoryType.equalsIgnoreCase(REPOSITORY_TYPE_IN_MEMORY)) {
            return InMemoryRepository.getInstance(batchEnvironment);
        }
        throw BatchMessages.MESSAGES.unrecognizedJobRepositoryType(repositoryType);
    }
}

