/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aesh.console;

import java.util.Arrays;
import org.jboss.aesh.console.Prompt;
import org.jboss.aesh.console.settings.Settings;

public class Buffer {
    private int cursor = 0;
    private StringBuilder line;
    private Prompt prompt;
    private int delta;
    private Character mask;
    private boolean disablePrompt = false;
    private static final int TAB = 4;

    protected Buffer() {
        this(null, null);
    }

    protected Buffer(Prompt prompt) {
        this(prompt, null);
    }

    protected Buffer(Prompt prompt, Character mask) {
        this.prompt = prompt != null ? prompt : new Prompt("");
        this.line = new StringBuilder();
        this.delta = 0;
        this.mask = mask;
    }

    protected void reset(Prompt prompt) {
        this.reset(prompt, null);
    }

    protected void reset(Prompt prompt, Character mask) {
        this.prompt = prompt != null ? prompt : new Prompt("");
        this.cursor = 0;
        this.line = new StringBuilder();
        this.delta = 0;
        this.mask = mask;
    }

    protected int length() {
        if (this.mask != null && this.mask.charValue() == '\u0000') {
            return 1;
        }
        return this.line.length();
    }

    protected int totalLength() {
        if (this.mask != null && this.mask.charValue() == '\u0000') {
            return this.disablePrompt ? 1 : this.prompt.getLength() + 1;
        }
        return this.disablePrompt ? this.line.length() + 1 : this.line.length() + this.prompt.getLength() + 1;
    }

    protected int getCursor() {
        return this.mask != null && this.mask.charValue() == '\u0000' ? 0 : this.cursor;
    }

    protected int getCursorWithPrompt() {
        if (this.disablePrompt) {
            return this.getCursor() + 1;
        }
        return this.getCursor() + this.prompt.getLength() + 1;
    }

    protected Prompt getPrompt() {
        return this.prompt;
    }

    protected void setCursor(int cursor) {
        this.cursor = cursor;
    }

    public boolean isMasking() {
        return this.mask != null;
    }

    protected void disablePrompt(boolean disable) {
        this.disablePrompt = disable;
    }

    protected char[] move(int move, int termWidth) {
        return this.move(move, termWidth, false);
    }

    protected char[] move(int move, int termWidth, boolean viMode) {
        int newRow;
        move = this.moveCursor(move, viMode);
        int currentRow = this.getCursorWithPrompt() / termWidth;
        if (currentRow > 0 && this.getCursorWithPrompt() % termWidth == 0) {
            --currentRow;
        }
        if ((newRow = (move + this.getCursorWithPrompt()) / termWidth) > 0 && (move + this.getCursorWithPrompt()) % termWidth == 0) {
            --newRow;
        }
        int row = newRow - currentRow;
        this.setCursor(this.getCursor() + move);
        int cursor = this.getCursorWithPrompt() % termWidth;
        if (cursor == 0 && this.getCursorWithPrompt() > 0) {
            cursor = termWidth;
        }
        if (row > 0) {
            StringBuilder sb = new StringBuilder();
            sb.append(Buffer.printAnsi(row + "B")).append(Buffer.printAnsi(cursor + "G"));
            return sb.toString().toCharArray();
        }
        if (row < 0) {
            if (this.getCursor() <= termWidth) {
                // empty if block
            }
            StringBuilder sb = new StringBuilder();
            sb.append(Buffer.printAnsi(Math.abs(row) + "A")).append(Buffer.printAnsi(cursor + "G"));
            return sb.toString().toCharArray();
        }
        if (move < 0) {
            return Buffer.printAnsi(Math.abs(move) + "D");
        }
        if (move > 0) {
            return Buffer.printAnsi(move + "C");
        }
        return new char[0];
    }

    public static char[] printAnsi(String out) {
        return Buffer.printAnsi(out.toCharArray());
    }

    public static char[] printAnsi(char[] out) {
        if (!Settings.getInstance().isAnsiConsole()) {
            return new char[0];
        }
        int length = 0;
        for (char c : out) {
            if (c == '\t') {
                length += 4;
                continue;
            }
            ++length;
        }
        char[] ansi = new char[length + 2];
        ansi[0] = 27;
        ansi[1] = 91;
        int counter = 0;
        for (char anOut : out) {
            if (anOut == '\t') {
                Arrays.fill(ansi, counter + 2, counter + 2 + 4, ' ');
                counter += 3;
            } else {
                ansi[counter + 2] = anOut;
            }
            ++counter;
        }
        return ansi;
    }

    private int moveCursor(int move, boolean viMode) {
        if (this.getCursor() == 0 && move <= 0) {
            return 0;
        }
        if (viMode ? this.getCursor() == this.length() - 1 && move > 0 : this.getCursor() == this.length() && move > 0) {
            return 0;
        }
        if (this.getCursor() + move <= 0) {
            return -this.getCursor();
        }
        if (viMode) {
            if (this.getCursor() + move > this.length() - 1) {
                return this.length() - 1 - this.getCursor();
            }
        } else if (this.getCursor() + move > this.length()) {
            return this.length() - this.getCursor();
        }
        return move;
    }

    protected char[] getLineFrom(int position) {
        return this.line.substring(position).toCharArray();
    }

    public String getLine() {
        if (this.mask == null) {
            return this.line.toString();
        }
        if (this.line.length() > 0) {
            return String.format("%" + this.line.length() + "s", "").replace(' ', this.mask.charValue());
        }
        return "";
    }

    public String getLineNoMask() {
        return this.line.toString();
    }

    protected void setLine(String line) {
        this.delta = line.length() - this.line.length();
        this.line = new StringBuilder(line);
    }

    protected void delete(int start, int end) {
        this.delta = start - end;
        this.line.delete(start, end);
    }

    protected void insert(int start, String in) {
        this.line.insert(start, in);
    }

    public String getLineWithPrompt() {
        return this.prompt.getPromptAsString() + this.line;
    }

    public void write(char c) {
        this.line.insert(this.cursor++, c);
        this.delta = 1;
    }

    public void write(String str) {
        assert (str != null);
        if (this.line.length() == 0) {
            this.line.append(str);
        } else {
            this.line.insert(this.getCursor(), str);
        }
        this.cursor += str.length();
        this.delta = str.length();
    }

    protected void clear() {
        this.line = new StringBuilder();
        this.delta = 0;
    }

    public int getDelta() {
        return this.delta;
    }

    protected boolean changeCase() {
        char c = this.getLine().charAt(this.getCursor());
        if (Character.isLetter(c)) {
            if (Character.isLowerCase(c)) {
                this.line.setCharAt(this.getCursor(), Character.toUpperCase(c));
            } else {
                this.line.setCharAt(this.getCursor(), Character.toLowerCase(c));
            }
            return true;
        }
        return false;
    }

    protected void replaceChar(char rChar) {
        this.line.setCharAt(this.getCursor(), rChar);
    }

    protected boolean containRedirection() {
        return this.line.indexOf(">") > -1;
    }

    protected int getRedirectionPosition() {
        return this.line.indexOf(">");
    }
}

