/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.jpa;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.persistence.EntityManager;
import javax.persistence.TypedQuery;
import org.keycloak.models.ApplicationModel;
import org.keycloak.models.AuthenticationLinkModel;
import org.keycloak.models.RealmModel;
import org.keycloak.models.RoleContainerModel;
import org.keycloak.models.RoleModel;
import org.keycloak.models.UserCredentialModel;
import org.keycloak.models.UserCredentialValueModel;
import org.keycloak.models.UserModel;
import org.keycloak.models.jpa.entities.AuthenticationLinkEntity;
import org.keycloak.models.jpa.entities.CredentialEntity;
import org.keycloak.models.jpa.entities.RoleEntity;
import org.keycloak.models.jpa.entities.UserEntity;
import org.keycloak.models.jpa.entities.UserRoleMappingEntity;
import org.keycloak.models.utils.Pbkdf2PasswordEncoder;

public class UserAdapter
implements UserModel {
    protected UserEntity user;
    protected EntityManager em;
    protected RealmModel realm;

    public UserAdapter(RealmModel realm, EntityManager em, UserEntity user) {
        this.em = em;
        this.user = user;
        this.realm = realm;
    }

    public UserEntity getUser() {
        return this.user;
    }

    public String getId() {
        return this.user.getId();
    }

    public String getLoginName() {
        return this.user.getLoginName();
    }

    public void setLoginName(String loginName) {
        this.user.setLoginName(loginName);
    }

    public boolean isEnabled() {
        return this.user.isEnabled();
    }

    public boolean isTotp() {
        return this.user.isTotp();
    }

    public void setEnabled(boolean enabled) {
        this.user.setEnabled(enabled);
    }

    public void setAttribute(String name, String value) {
        Map<String, String> attributes = this.user.getAttributes();
        if (attributes == null) {
            attributes = new HashMap<String, String>();
        }
        attributes.put(name, value);
        this.user.setAttributes(attributes);
    }

    public void removeAttribute(String name) {
        Map<String, String> attributes = this.user.getAttributes();
        if (attributes == null) {
            attributes = new HashMap<String, String>();
        }
        attributes.remove(name);
        this.user.setAttributes(attributes);
    }

    public String getAttribute(String name) {
        if (this.user.getAttributes() == null) {
            return null;
        }
        return this.user.getAttributes().get(name);
    }

    public Map<String, String> getAttributes() {
        HashMap<String, String> result = new HashMap<String, String>();
        result.putAll(this.user.getAttributes());
        return result;
    }

    public Set<UserModel.RequiredAction> getRequiredActions() {
        HashSet<UserModel.RequiredAction> result = new HashSet<UserModel.RequiredAction>();
        result.addAll(this.user.getRequiredActions());
        return result;
    }

    public void addRequiredAction(UserModel.RequiredAction action) {
        this.user.getRequiredActions().add(action);
    }

    public void removeRequiredAction(UserModel.RequiredAction action) {
        this.user.getRequiredActions().remove(action);
    }

    public String getFirstName() {
        return this.user.getFirstName();
    }

    public void setFirstName(String firstName) {
        this.user.setFirstName(firstName);
    }

    public String getLastName() {
        return this.user.getLastName();
    }

    public void setLastName(String lastName) {
        this.user.setLastName(lastName);
    }

    public String getEmail() {
        return this.user.getEmail();
    }

    public void setEmail(String email) {
        this.user.setEmail(email);
    }

    public boolean isEmailVerified() {
        return this.user.isEmailVerified();
    }

    public void setEmailVerified(boolean verified) {
        this.user.setEmailVerified(verified);
    }

    public void setTotp(boolean totp) {
        this.user.setTotp(totp);
    }

    public int getNotBefore() {
        return this.user.getNotBefore();
    }

    public void setNotBefore(int notBefore) {
        this.user.setNotBefore(notBefore);
    }

    public void updateCredential(UserCredentialModel cred) {
        CredentialEntity credentialEntity = this.getCredentialEntity(this.user, cred.getType());
        if (credentialEntity == null) {
            credentialEntity = new CredentialEntity();
            credentialEntity.setType(cred.getType());
            credentialEntity.setDevice(cred.getDevice());
            credentialEntity.setUser(this.user);
            this.em.persist((Object)credentialEntity);
            this.user.getCredentials().add(credentialEntity);
        }
        if (cred.getType().equals("password")) {
            byte[] salt = Pbkdf2PasswordEncoder.getSalt();
            credentialEntity.setValue(new Pbkdf2PasswordEncoder(salt).encode(cred.getValue()));
            credentialEntity.setSalt(salt);
        } else {
            credentialEntity.setValue(cred.getValue());
        }
        credentialEntity.setDevice(cred.getDevice());
        this.em.flush();
    }

    private CredentialEntity getCredentialEntity(UserEntity userEntity, String credType) {
        for (CredentialEntity entity : userEntity.getCredentials()) {
            if (!entity.getType().equals(credType)) continue;
            return entity;
        }
        return null;
    }

    public List<UserCredentialValueModel> getCredentialsDirectly() {
        ArrayList<CredentialEntity> credentials = new ArrayList<CredentialEntity>(this.user.getCredentials());
        ArrayList<UserCredentialValueModel> result = new ArrayList<UserCredentialValueModel>();
        if (credentials != null) {
            for (CredentialEntity credEntity : credentials) {
                UserCredentialValueModel credModel = new UserCredentialValueModel();
                credModel.setType(credEntity.getType());
                credModel.setDevice(credEntity.getDevice());
                credModel.setValue(credEntity.getValue());
                credModel.setSalt(credEntity.getSalt());
                result.add(credModel);
            }
        }
        return result;
    }

    public void updateCredentialDirectly(UserCredentialValueModel credModel) {
        CredentialEntity credentialEntity = this.getCredentialEntity(this.user, credModel.getType());
        if (credentialEntity == null) {
            credentialEntity = new CredentialEntity();
            credentialEntity.setType(credModel.getType());
            credentialEntity.setUser(this.user);
            this.em.persist((Object)credentialEntity);
            this.user.getCredentials().add(credentialEntity);
        }
        credentialEntity.setValue(credModel.getValue());
        credentialEntity.setSalt(credModel.getSalt());
        credentialEntity.setDevice(credModel.getDevice());
        this.em.flush();
    }

    public boolean hasRole(RoleModel role) {
        Set<RoleModel> roles = this.getRoleMappings();
        if (roles.contains(role)) {
            return true;
        }
        for (RoleModel mapping : roles) {
            if (!mapping.hasRole(role)) continue;
            return true;
        }
        return false;
    }

    protected TypedQuery<UserRoleMappingEntity> getUserRoleMappingEntityTypedQuery(RoleModel role) {
        TypedQuery query = this.em.createNamedQuery("userHasRole", UserRoleMappingEntity.class);
        query.setParameter("user", (Object)this.getUser());
        RoleEntity roleEntity = (RoleEntity)this.em.getReference(RoleEntity.class, (Object)role.getId());
        query.setParameter("role", (Object)roleEntity);
        return query;
    }

    public void grantRole(RoleModel role) {
        if (this.hasRole(role)) {
            return;
        }
        UserRoleMappingEntity entity = new UserRoleMappingEntity();
        entity.setUser(this.getUser());
        RoleEntity roleEntity = (RoleEntity)this.em.getReference(RoleEntity.class, (Object)role.getId());
        entity.setRole(roleEntity);
        this.em.persist((Object)entity);
        this.em.flush();
        this.em.detach((Object)entity);
    }

    public Set<RoleModel> getRealmRoleMappings() {
        Set<RoleModel> roleMappings = this.getRoleMappings();
        HashSet<RoleModel> realmRoles = new HashSet<RoleModel>();
        for (RoleModel role : roleMappings) {
            RoleContainerModel container = role.getContainer();
            if (!(container instanceof RealmModel)) continue;
            realmRoles.add(role);
        }
        return realmRoles;
    }

    public Set<RoleModel> getRoleMappings() {
        TypedQuery query = this.em.createNamedQuery("userRoleMappingIds", String.class);
        query.setParameter("user", (Object)this.getUser());
        List ids = query.getResultList();
        HashSet<RoleModel> roles = new HashSet<RoleModel>();
        for (String roleId : ids) {
            RoleModel roleById = this.realm.getRoleById(roleId);
            if (roleById == null) continue;
            roles.add(roleById);
        }
        return roles;
    }

    public void deleteRoleMapping(RoleModel role) {
        if (this.user == null || role == null) {
            return;
        }
        TypedQuery<UserRoleMappingEntity> query = this.getUserRoleMappingEntityTypedQuery(role);
        List results = query.getResultList();
        if (results.size() == 0) {
            return;
        }
        for (UserRoleMappingEntity entity : results) {
            this.em.remove((Object)entity);
        }
        this.em.flush();
    }

    public Set<RoleModel> getApplicationRoleMappings(ApplicationModel app) {
        Set<RoleModel> roleMappings = this.getRoleMappings();
        HashSet<RoleModel> roles = new HashSet<RoleModel>();
        for (RoleModel role : roleMappings) {
            ApplicationModel appModel;
            RoleContainerModel container = role.getContainer();
            if (!(container instanceof ApplicationModel) || !(appModel = (ApplicationModel)container).getId().equals(app.getId())) continue;
            roles.add(role);
        }
        return roles;
    }

    public AuthenticationLinkModel getAuthenticationLink() {
        AuthenticationLinkEntity authLinkEntity = this.user.getAuthenticationLink();
        return authLinkEntity == null ? null : new AuthenticationLinkModel(authLinkEntity.getAuthProvider(), authLinkEntity.getAuthUserId());
    }

    public void setAuthenticationLink(AuthenticationLinkModel authenticationLink) {
        AuthenticationLinkEntity entity = new AuthenticationLinkEntity();
        entity.setAuthProvider(authenticationLink.getAuthProvider());
        entity.setAuthUserId(authenticationLink.getAuthUserId());
        this.user.setAuthenticationLink(entity);
        this.em.persist((Object)entity);
        this.em.persist((Object)this.user);
        this.em.flush();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || !(o instanceof UserModel)) {
            return false;
        }
        UserModel that = (UserModel)o;
        return that.getId().equals(this.getId());
    }

    public int hashCode() {
        return this.getId().hashCode();
    }
}

