/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.jpa;

import java.util.ArrayList;
import java.util.List;
import javax.persistence.EntityManager;
import org.keycloak.models.ClientModel;
import org.keycloak.models.ModelException;
import org.keycloak.models.RealmModel;
import org.keycloak.models.UserModel;
import org.keycloak.models.UserSessionModel;
import org.keycloak.models.jpa.entities.ClientUserSessionAssociationEntity;
import org.keycloak.models.jpa.entities.UserSessionEntity;

public class UserSessionAdapter
implements UserSessionModel {
    private RealmModel realm;
    private UserSessionEntity entity;
    private EntityManager em;

    public UserSessionAdapter(EntityManager em, RealmModel realm, UserSessionEntity entity) {
        this.entity = entity;
        this.em = em;
        this.realm = realm;
    }

    public UserSessionEntity getEntity() {
        return this.entity;
    }

    public String getId() {
        return this.entity.getId();
    }

    public void setId(String id) {
        this.entity.setId(id);
    }

    public UserModel getUser() {
        return this.realm.getUserById(this.entity.getUserId());
    }

    public void setUser(UserModel user) {
        this.entity.setUserId(user.getId());
    }

    public String getIpAddress() {
        return this.entity.getIpAddress();
    }

    public void setIpAddress(String ipAddress) {
        this.entity.setIpAddress(ipAddress);
    }

    public int getStarted() {
        return this.entity.getStarted();
    }

    public void setStarted(int started) {
        this.entity.setStarted(started);
    }

    public int getLastSessionRefresh() {
        return this.entity.getLastSessionRefresh();
    }

    public void setLastSessionRefresh(int seconds) {
        this.entity.setLastSessionRefresh(seconds);
    }

    public void associateClient(ClientModel client) {
        for (ClientUserSessionAssociationEntity ass : this.entity.getClients()) {
            if (!ass.getClientId().equals(client.getId())) continue;
            return;
        }
        ClientUserSessionAssociationEntity association = new ClientUserSessionAssociationEntity();
        association.setClientId(client.getId());
        association.setSession(this.entity);
        association.setUserId(this.entity.getUserId());
        association.setRealmId(this.realm.getId());
        this.em.persist((Object)association);
        this.entity.getClients().add(association);
    }

    public void removeAssociatedClient(ClientModel client) {
        this.em.createNamedQuery("removeClientUserSessionByClient").setParameter("clientId", (Object)client.getId()).executeUpdate();
    }

    public List<ClientModel> getClientAssociations() {
        ArrayList<ClientModel> clients = new ArrayList<ClientModel>();
        for (ClientUserSessionAssociationEntity association : this.entity.getClients()) {
            ClientModel client = this.realm.findClientById(association.getClientId());
            if (client == null) {
                throw new ModelException("couldnt find client");
            }
            clients.add(client);
        }
        return clients;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || !(o instanceof UserSessionModel)) {
            return false;
        }
        UserSessionModel that = (UserSessionModel)o;
        return that.getId().equals(this.getId());
    }

    public int hashCode() {
        return this.getId().hashCode();
    }
}

