/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.jpa.entities;

import java.util.HashSet;
import java.util.Set;
import javax.persistence.CollectionTable;
import javax.persistence.Column;
import javax.persistence.ElementCollection;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.Id;
import javax.persistence.Inheritance;
import javax.persistence.InheritanceType;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.Table;
import javax.persistence.UniqueConstraint;
import org.keycloak.models.jpa.entities.RealmEntity;

@Entity
@Inheritance(strategy=InheritanceType.SINGLE_TABLE)
@Table(uniqueConstraints={@UniqueConstraint(columnNames={"realm", "name"})})
public abstract class ClientEntity {
    @Id
    private String id;
    @Column(name="name")
    private String name;
    private boolean enabled;
    private String secret;
    private long allowedClaimsMask;
    private int notBefore;
    private boolean publicClient;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="realm")
    protected RealmEntity realm;
    @ElementCollection
    @CollectionTable
    protected Set<String> webOrigins = new HashSet<String>();
    @ElementCollection
    @CollectionTable
    protected Set<String> redirectUris = new HashSet<String>();

    public RealmEntity getRealm() {
        return this.realm;
    }

    public void setRealm(RealmEntity realm) {
        this.realm = realm;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public long getAllowedClaimsMask() {
        return this.allowedClaimsMask;
    }

    public void setAllowedClaimsMask(long allowedClaimsMask) {
        this.allowedClaimsMask = allowedClaimsMask;
    }

    public Set<String> getWebOrigins() {
        return this.webOrigins;
    }

    public void setWebOrigins(Set<String> webOrigins) {
        this.webOrigins = webOrigins;
    }

    public Set<String> getRedirectUris() {
        return this.redirectUris;
    }

    public void setRedirectUris(Set<String> redirectUris) {
        this.redirectUris = redirectUris;
    }

    public String getSecret() {
        return this.secret;
    }

    public void setSecret(String secret) {
        this.secret = secret;
    }

    public int getNotBefore() {
        return this.notBefore;
    }

    public void setNotBefore(int notBefore) {
        this.notBefore = notBefore;
    }

    public boolean isPublicClient() {
        return this.publicClient;
    }

    public void setPublicClient(boolean publicClient) {
        this.publicClient = publicClient;
    }
}

