/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.context;

import org.infinispan.configuration.cache.Configuration;
import org.infinispan.configuration.cache.Configurations;
import org.infinispan.configuration.global.GlobalConfiguration;
import org.infinispan.context.InvocationContext;
import org.infinispan.context.InvocationContextContainer;
import org.infinispan.factories.annotations.Inject;
import org.infinispan.factories.annotations.Stop;

public class InvocationContextContainerImpl
implements InvocationContextContainer {
    private final ThreadLocal<InvocationContext> ctxHolder = new ThreadLocal();
    private ClassLoader configuredClassLoader;

    @Inject
    public void init(Configuration configuration, GlobalConfiguration globalConfiguration) {
        this.configuredClassLoader = Configurations.getClassLoader(configuration, globalConfiguration);
    }

    @Stop(priority=999)
    public void stop() {
        this.configuredClassLoader = null;
    }

    @Override
    public InvocationContext getInvocationContext(boolean quiet) {
        InvocationContext ctx = this.ctxHolder.get();
        if (ctx == null && !quiet) {
            throw new IllegalStateException("No InvocationContext associated with current thread!");
        }
        return ctx;
    }

    @Override
    public void setThreadLocal(InvocationContext context) {
        if (this.isThreadLocalRequired(context)) {
            this.ctxHolder.set(context);
        }
    }

    @Override
    public void clearThreadLocal() {
        this.ctxHolder.remove();
    }

    private boolean isThreadLocalRequired(InvocationContext context) {
        return context.getClassLoader() != null && context.getClassLoader() != this.configuredClassLoader;
    }
}

