/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.server.handlers;

import io.undertow.UndertowOptions;
import io.undertow.server.HttpHandler;
import io.undertow.server.HttpServerExchange;
import io.undertow.util.URLUtils;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.Map;
import java.util.TreeMap;

public class URLDecodingHandler
implements HttpHandler {
    private final HttpHandler next;
    private final String charset;

    public URLDecodingHandler(HttpHandler next, String charset) {
        this.next = next;
        this.charset = charset;
    }

    @Override
    public void handleRequest(HttpServerExchange exchange) throws Exception {
        boolean decodeDone = exchange.getConnection().getUndertowOptions().get(UndertowOptions.DECODE_URL, true);
        if (!decodeDone) {
            StringBuilder sb = new StringBuilder();
            boolean decodeSlash = exchange.getConnection().getUndertowOptions().get(UndertowOptions.ALLOW_ENCODED_SLASH, false);
            exchange.setRequestPath(URLUtils.decode(exchange.getRequestPath(), this.charset, decodeSlash, sb));
            exchange.setRelativePath(URLUtils.decode(exchange.getRelativePath(), this.charset, decodeSlash, sb));
            exchange.setResolvedPath(URLUtils.decode(exchange.getResolvedPath(), this.charset, decodeSlash, sb));
            if (!exchange.getQueryString().isEmpty()) {
                TreeMap newParams = new TreeMap();
                for (Map.Entry<String, Deque<String>> param : exchange.getQueryParameters().entrySet()) {
                    ArrayDeque<String> newVales = new ArrayDeque<String>(param.getValue().size());
                    for (String val : param.getValue()) {
                        newVales.add(URLUtils.decode(val, this.charset, true, sb));
                    }
                    newParams.put(URLUtils.decode(param.getKey(), this.charset, true, sb), newVales);
                }
                exchange.getQueryParameters().clear();
                exchange.getQueryParameters().putAll(newParams);
            }
        }
        this.next.handleRequest(exchange);
    }
}

