/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.web.undertow.session;

import io.undertow.security.api.AuthenticatedSessionManager;
import io.undertow.security.idm.Account;
import io.undertow.server.HttpServerExchange;
import io.undertow.server.session.SessionConfig;
import io.undertow.server.session.SessionListener;
import io.undertow.server.session.SessionManager;
import io.undertow.servlet.handlers.security.CachedAuthenticatedSessionHandler;
import java.util.AbstractMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.wildfly.clustering.web.Batch;
import org.wildfly.clustering.web.session.Session;
import org.wildfly.clustering.web.undertow.session.AbstractDistributableSession;
import org.wildfly.clustering.web.undertow.session.LocalSessionContext;
import org.wildfly.clustering.web.undertow.session.UndertowSessionManager;

public class DistributableSession
extends AbstractDistributableSession<Session<LocalSessionContext>> {
    private static final String AUTHENTICATED_SESSION_ATTRIBUTE_NAME = CachedAuthenticatedSessionHandler.class.getName() + ".AuthenticatedSession";
    private final UndertowSessionManager manager;
    private volatile Map.Entry<Session<LocalSessionContext>, SessionConfig> entry;
    private final Batch batch;

    public DistributableSession(UndertowSessionManager manager, Session<LocalSessionContext> session, SessionConfig config, Batch batch) {
        this.manager = manager;
        this.entry = new AbstractMap.SimpleImmutableEntry<Session<LocalSessionContext>, SessionConfig>(session, config);
        this.batch = batch;
    }

    public SessionManager getSessionManager() {
        return this.manager;
    }

    @Override
    protected Session<LocalSessionContext> getSession() {
        return this.entry.getKey();
    }

    public void requestDone(HttpServerExchange exchange) {
        this.getSession().close();
        this.batch.close();
    }

    public void setMaxInactiveInterval(int interval) {
        this.getSession().getMetaData().setMaxInactiveInterval((long)interval, TimeUnit.SECONDS);
    }

    @Override
    public Object getAttribute(String name) {
        if (AUTHENTICATED_SESSION_ATTRIBUTE_NAME.equals(name)) {
            Account account = (Account)super.getAttribute(name);
            return account != null ? new AuthenticatedSessionManager.AuthenticatedSession(account, "FORM") : ((LocalSessionContext)this.getSession().getLocalContext()).getAuthenticatedSession();
        }
        return super.getAttribute(name);
    }

    public Object setAttribute(String name, Object value) {
        if (value == null) {
            return this.removeAttribute(name);
        }
        if (AUTHENTICATED_SESSION_ATTRIBUTE_NAME.equals(name)) {
            AuthenticatedSessionManager.AuthenticatedSession session = (AuthenticatedSessionManager.AuthenticatedSession)value;
            if (session.getMechanism().equals("FORM")) {
                Account account = (Account)this.getSession().getAttributes().setAttribute(name, (Object)session.getAccount());
                return account != null ? new AuthenticatedSessionManager.AuthenticatedSession(account, "FORM") : null;
            }
            LocalSessionContext context = (LocalSessionContext)this.getSession().getLocalContext();
            AuthenticatedSessionManager.AuthenticatedSession old = context.getAuthenticatedSession();
            context.setAuthenticatedSession(session);
            return old;
        }
        Object old = this.getSession().getAttributes().setAttribute(name, value);
        if (old == null) {
            this.manager.getSessionListeners().attributeAdded((io.undertow.server.session.Session)this, name, value);
        } else if (old != value) {
            this.manager.getSessionListeners().attributeUpdated((io.undertow.server.session.Session)this, name, value, old);
        }
        return old;
    }

    public Object removeAttribute(String name) {
        if (AUTHENTICATED_SESSION_ATTRIBUTE_NAME.equals(name)) {
            Account account = (Account)this.getSession().getAttributes().removeAttribute(name);
            if (account != null) {
                return new AuthenticatedSessionManager.AuthenticatedSession(account, "FORM");
            }
            LocalSessionContext context = (LocalSessionContext)this.getSession().getLocalContext();
            AuthenticatedSessionManager.AuthenticatedSession old = context.getAuthenticatedSession();
            context.setAuthenticatedSession(null);
            return old;
        }
        Object old = this.getSession().getAttributes().removeAttribute(name);
        if (old != null) {
            this.manager.getSessionListeners().attributeRemoved((io.undertow.server.session.Session)this, name, old);
        }
        return old;
    }

    public void invalidate(HttpServerExchange exchange) {
        Map.Entry<Session<LocalSessionContext>, SessionConfig> entry = this.entry;
        Session<LocalSessionContext> session = entry.getKey();
        this.manager.getSessionListeners().sessionDestroyed((io.undertow.server.session.Session)this, exchange, SessionListener.SessionDestroyedReason.INVALIDATED);
        session.invalidate();
        if (exchange != null) {
            String id = session.getId();
            entry.getValue().clearSession(exchange, id);
        }
        this.batch.close();
    }

    public String changeSessionId(HttpServerExchange exchange, SessionConfig config) {
        Session<LocalSessionContext> oldSession = this.getSession();
        org.wildfly.clustering.web.session.SessionManager<LocalSessionContext> manager = this.manager.getSessionManager();
        String id = (String)manager.createIdentifier();
        Session newSession = manager.createSession(id);
        for (String name : oldSession.getAttributes().getAttributeNames()) {
            newSession.getAttributes().setAttribute(name, oldSession.getAttributes().getAttribute(name));
        }
        newSession.getMetaData().setMaxInactiveInterval(oldSession.getMetaData().getMaxInactiveInterval(TimeUnit.MILLISECONDS), TimeUnit.MILLISECONDS);
        newSession.getMetaData().setLastAccessedTime(oldSession.getMetaData().getLastAccessedTime());
        ((LocalSessionContext)newSession.getLocalContext()).setAuthenticatedSession(((LocalSessionContext)oldSession.getLocalContext()).getAuthenticatedSession());
        config.setSessionId(exchange, id);
        this.entry = new AbstractMap.SimpleImmutableEntry<Session, SessionConfig>(newSession, config);
        oldSession.invalidate();
        return id;
    }
}

