/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.exportimport;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jboss.logging.Logger;
import org.keycloak.models.utils.reflection.Property;
import org.keycloak.models.utils.reflection.PropertyCriteria;
import org.keycloak.models.utils.reflection.PropertyQueries;

public class ExportImportPropertiesManager {
    private static final Logger logger = Logger.getLogger(ExportImportPropertiesManager.class);
    private Map<Class<?>, Map<String, Property<Object>>> objectProperties = new HashMap();

    protected void initClassProperties(Class<?> clazz) {
        Map classProps = PropertyQueries.createQuery(clazz).addCriteria((PropertyCriteria)new NonEmptyGetterCriteria()).getWritableResultList();
        this.objectProperties.put(clazz, classProps);
    }

    public void setBasicPropertiesFromModel(Object model, Object entity) {
        Class<?> modelClass = this.getModelClass(model);
        this.checkPropertiesAvailable(modelClass, entity.getClass());
        Map<String, Property<Object>> modelProps = this.objectProperties.get(modelClass);
        Map<String, Property<Object>> entityProps = this.objectProperties.get(entity.getClass());
        HashMap<String, Property<Object>> entityPropsCopy = new HashMap<String, Property<Object>>(entityProps);
        logger.debugf("Properties of entity %s: %s", entity, entityProps.keySet());
        for (Property<Object> modelProperty : modelProps.values()) {
            Property entityProperty = (Property)entityPropsCopy.get(modelProperty.getName());
            entityPropsCopy.remove(modelProperty.getName());
            if (entityProperty != null) {
                Object propertyValue = modelProperty.getValue(model);
                if (propertyValue instanceof Set) {
                    Set propValueAsSet = (Set)propertyValue;
                    entityProperty.setValue(entity, new ArrayList(propValueAsSet));
                } else {
                    entityProperty.setValue(entity, propertyValue);
                }
                if (!logger.isTraceEnabled()) continue;
                logger.tracef("Property %s successfully set in JSON to entity %s", (Object)modelProperty.getName(), entity);
                continue;
            }
            logger.debugf("Property %s not known in JSON for entity %s", (Object)modelProperty.getName(), entity);
        }
        logger.debugf("Entity properties for manual setup: %s", entityPropsCopy.keySet());
    }

    private void checkPropertiesAvailable(Class<?> modelClass, Class<?> entityClass) {
        if (!this.objectProperties.containsKey(modelClass)) {
            this.initClassProperties(modelClass);
        }
        if (!this.objectProperties.containsKey(entityClass)) {
            this.initClassProperties(entityClass);
        }
    }

    public void setBasicPropertiesToModel(Object model, Object entity) {
        Class<?> modelClass = this.getModelClass(model);
        this.checkPropertiesAvailable(modelClass, entity.getClass());
        Map<String, Property<Object>> modelProps = this.objectProperties.get(modelClass);
        Map<String, Property<Object>> entityProps = this.objectProperties.get(entity.getClass());
        HashMap<String, Property<Object>> entityPropsCopy = new HashMap<String, Property<Object>>(entityProps);
        logger.debugf("Properties of exported entity %s: %s", entity, entityProps.keySet());
        for (Property<Object> modelProperty : modelProps.values()) {
            Property entityProperty = (Property)entityPropsCopy.get(modelProperty.getName());
            entityPropsCopy.remove(modelProperty.getName());
            if (entityProperty != null) {
                Object propertyValue = entityProperty.getValue(entity);
                if (propertyValue instanceof List && Set.class.isAssignableFrom(modelProperty.getJavaClass())) {
                    List propValueAsList = (List)propertyValue;
                    modelProperty.setValue(model, new HashSet(propValueAsList));
                } else {
                    modelProperty.setValue(model, propertyValue);
                }
                if (!logger.isTraceEnabled()) continue;
                logger.tracef("Property %s successfully set in model from entity %s", (Object)modelProperty.getName(), entity);
                continue;
            }
            logger.debugf("Property %s not known for entity %s", (Object)modelProperty.getName(), entity);
        }
        logger.debugf("Entity properties for manual setup: %s", entityPropsCopy.keySet());
    }

    protected Class<?> getModelClass(Object model) {
        Class<?> modelClass = model.getClass();
        Class<?>[] interfaces = modelClass.getInterfaces();
        if (interfaces.length == 0) {
            return modelClass;
        }
        return interfaces[0];
    }

    public static class NonEmptyGetterCriteria
    implements PropertyCriteria {
        private static final List<String> IGNORED_METHODS = Arrays.asList("getPasswordPolicy", "getAuthenticationProviders", "getAuthenticationLink");

        public boolean methodMatches(Method m) {
            if (m.getParameterTypes().length > 0) {
                return false;
            }
            return !IGNORED_METHODS.contains(m.getName());
        }
    }
}

