/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.cache;

import org.keycloak.models.OAuthClientModel;
import org.keycloak.models.RealmModel;
import org.keycloak.models.cache.CacheKeycloakSession;
import org.keycloak.models.cache.ClientAdapter;
import org.keycloak.models.cache.KeycloakCache;
import org.keycloak.models.cache.entities.CachedOAuthClient;

public class OAuthClientAdapter
extends ClientAdapter
implements OAuthClientModel {
    protected OAuthClientModel updated;
    protected CachedOAuthClient cached;

    public OAuthClientAdapter(RealmModel cachedRealm, CachedOAuthClient cached, CacheKeycloakSession cacheSession, KeycloakCache cache) {
        super(cachedRealm, cached, cache, cacheSession);
        this.cached = cached;
    }

    @Override
    protected void getDelegateForUpdate() {
        if (this.updated == null) {
            this.cacheSession.registerOAuthClientInvalidation(this.getId());
            this.updated = this.cacheSession.getDelegate().getOAuthClientById(this.getId(), this.cachedRealm);
            this.updatedClient = this.updated;
            if (this.updated == null) {
                throw new IllegalStateException("Not found in database");
            }
        }
    }

    @Override
    public String getClientId() {
        if (this.updated != null) {
            return this.updated.getClientId();
        }
        return this.cached.getName();
    }

    public void setClientId(String id) {
        this.getDelegateForUpdate();
        this.updated.setClientId(id);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || !(o instanceof OAuthClientModel)) {
            return false;
        }
        OAuthClientModel that = (OAuthClientModel)o;
        return that.getId().equals(this.getId());
    }

    public int hashCode() {
        return this.getId().hashCode();
    }
}

