/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models;

import java.util.Collections;
import java.util.LinkedList;
import java.util.List;

public class PasswordPolicy {
    private List<Policy> policies;
    private String policyString;

    public PasswordPolicy(String policyString) {
        if (policyString == null || policyString.length() == 0) {
            this.policyString = null;
            this.policies = Collections.emptyList();
        } else {
            this.policyString = policyString;
            this.policies = PasswordPolicy.parse(policyString);
        }
    }

    private static List<Policy> parse(String policyString) {
        String[] policies;
        LinkedList<Policy> list = new LinkedList<Policy>();
        for (String policy : policies = policyString.split(" and ")) {
            String name;
            policy = policy.trim();
            String[] args = null;
            int i = policy.indexOf(40);
            if (i == -1) {
                name = policy.trim();
            } else {
                name = policy.substring(0, i).trim();
                args = policy.substring(i + 1, policy.length() - 1).split(",");
                for (int j = 0; j < args.length; ++j) {
                    args[j] = args[j].trim();
                }
            }
            if (name.equals("length")) {
                list.add(new Length(args));
                continue;
            }
            if (name.equals("digits")) {
                list.add(new Digits(args));
                continue;
            }
            if (name.equals("lowerCase")) {
                list.add(new LowerCase(args));
                continue;
            }
            if (name.equals("upperCase")) {
                list.add(new UpperCase(args));
                continue;
            }
            if (!name.equals("specialChars")) continue;
            list.add(new SpecialChars(args));
        }
        return list;
    }

    public String validate(String password) {
        for (Policy p : this.policies) {
            String error = p.validate(password);
            if (error == null) continue;
            return error;
        }
        return null;
    }

    private static int intArg(String policy, int defaultValue, String ... args) {
        if (args == null || args.length == 0) {
            return defaultValue;
        }
        if (args.length == 1) {
            return Integer.parseInt(args[0]);
        }
        throw new IllegalArgumentException("Invalid arguments to " + policy + ", expect no argument or single integer");
    }

    public String toString() {
        return this.policyString;
    }

    private static class SpecialChars
    implements Policy {
        private static final String NAME = "specialChars";
        private int min;

        public SpecialChars(String[] args) {
            this.min = PasswordPolicy.intArg(NAME, 1, args);
        }

        @Override
        public String validate(String password) {
            int count = 0;
            for (char c : password.toCharArray()) {
                if (Character.isLetterOrDigit(c)) continue;
                ++count;
            }
            return count < this.min ? "Invalid password: must contain at least " + count + " special characters" : null;
        }
    }

    private static class UpperCase
    implements Policy {
        private static final String NAME = "upperCase";
        private int min;

        public UpperCase(String[] args) {
            this.min = PasswordPolicy.intArg(NAME, 1, args);
        }

        @Override
        public String validate(String password) {
            int count = 0;
            for (char c : password.toCharArray()) {
                if (!Character.isUpperCase(c)) continue;
                ++count;
            }
            return count < this.min ? "Invalid password: must contain at least " + count + " upper case characters" : null;
        }
    }

    private static class LowerCase
    implements Policy {
        private static final String NAME = "lowerCase";
        private int min;

        public LowerCase(String[] args) {
            this.min = PasswordPolicy.intArg(NAME, 1, args);
        }

        @Override
        public String validate(String password) {
            int count = 0;
            for (char c : password.toCharArray()) {
                if (!Character.isLowerCase(c)) continue;
                ++count;
            }
            return count < this.min ? "Invalid password: must contain at least " + count + " lower case characters" : null;
        }
    }

    private static class Digits
    implements Policy {
        private static final String NAME = "digits";
        private int min;

        public Digits(String[] args) {
            this.min = PasswordPolicy.intArg(NAME, 1, args);
        }

        @Override
        public String validate(String password) {
            int count = 0;
            for (char c : password.toCharArray()) {
                if (!Character.isDigit(c)) continue;
                ++count;
            }
            return count < this.min ? "Invalid password: must contain at least " + count + " numerical digits" : null;
        }
    }

    private static class Length
    implements Policy {
        private static final String NAME = "length";
        private int min;

        public Length(String[] args) {
            this.min = PasswordPolicy.intArg(NAME, 8, args);
        }

        @Override
        public String validate(String password) {
            return password.length() < this.min ? "Invalid password: minimum length " + this.min : null;
        }
    }

    private static interface Policy {
        public String validate(String var1);
    }
}

