/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.query.clustered;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.NoSuchElementException;
import java.util.UUID;
import org.apache.lucene.search.ScoreDoc;
import org.apache.lucene.search.Sort;
import org.apache.lucene.search.SortField;
import org.apache.lucene.util.PriorityQueue;
import org.infinispan.AdvancedCache;
import org.infinispan.commons.util.ReflectionUtil;
import org.infinispan.query.ResultIterator;
import org.infinispan.query.clustered.ClusteredDoc;
import org.infinispan.query.clustered.ClusteredTopDocs;
import org.infinispan.query.clustered.ISPNEagerTopDocs;
import org.infinispan.query.clustered.ISPNPriorityQueueFactory;

public class DistributedIterator
implements ResultIterator {
    protected final AdvancedCache<?, ?> cache;
    private int currentIndex = -1;
    private final ArrayList<Object> orderedValues = new ArrayList();
    private final Sort sort;
    private final int fetchSize;
    private HashMap<UUID, ClusteredTopDocs> topDocsResponses;
    private PriorityQueue<ScoreDoc> hq;
    private final int resultSize;
    private final int maxResults;
    private final int firstResult;

    public DistributedIterator(Sort sort, int fetchSize, int resultSize, int maxResults, int firstResult, HashMap<UUID, ClusteredTopDocs> topDocsResponses, AdvancedCache<?, ?> cache) {
        this.sort = sort;
        this.fetchSize = fetchSize;
        this.resultSize = resultSize;
        this.maxResults = maxResults;
        this.firstResult = firstResult;
        this.cache = cache;
        this.setTopDocs(topDocsResponses);
        this.goToFirstResult();
    }

    private void goToFirstResult() {
        for (int i = 0; i < this.firstResult; ++i) {
            ClusteredDoc scoreDoc = (ClusteredDoc)this.hq.pop();
            if (scoreDoc == null) {
                return;
            }
            this.rechargeQueue(scoreDoc);
        }
    }

    private void setTopDocs(HashMap<UUID, ClusteredTopDocs> topDocsResponses) {
        this.topDocsResponses = topDocsResponses;
        if (this.sort != null) {
            SortField[] arr$ = this.sort.getSort();
            int len$ = arr$.length;
            for (int i$ = 0; i$ < len$; ++i$) {
                SortField sf;
                boolean reverse = (Boolean)ReflectionUtil.getValue((Object)(sf = arr$[i$]), (String)"reverse");
                ReflectionUtil.setValue((Object)sf, (String)"reverse", (Object)(!reverse ? 1 : 0));
            }
            this.hq = ISPNPriorityQueueFactory.getFieldDocSortedHitQueue(topDocsResponses.size(), this.sort.getSort());
        } else {
            this.hq = ISPNPriorityQueueFactory.getHitQueue(topDocsResponses.size());
        }
        for (ClusteredTopDocs ctp : topDocsResponses.values()) {
            if (!ctp.hasNext()) continue;
            this.hq.add((Object)ctp.getNext());
        }
    }

    @Override
    public void close() {
    }

    @Override
    public Object next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException("Out of boundaries");
        }
        ++this.currentIndex;
        return this.current();
    }

    private Object current() {
        if (this.orderedValues.size() > this.currentIndex) {
            return this.orderedValues.get(this.currentIndex);
        }
        this.loadTo(this.currentIndex);
        return this.orderedValues.get(this.currentIndex);
    }

    private void loadTo(int index) {
        for (int fetched = 0; this.orderedValues.size() <= index || fetched < this.fetchSize; ++fetched) {
            ClusteredDoc scoreDoc = (ClusteredDoc)this.hq.pop();
            if (scoreDoc == null) {
                return;
            }
            ClusteredTopDocs topDoc = this.rechargeQueue(scoreDoc);
            Object value = this.fetchValue(scoreDoc, topDoc);
            this.orderedValues.add(value);
        }
    }

    private ClusteredTopDocs rechargeQueue(ClusteredDoc scoreDoc) {
        ClusteredTopDocs topDoc = this.topDocsResponses.get(scoreDoc.getNodeUuid());
        ScoreDoc score = topDoc.getNext();
        if (score != null) {
            this.hq.add((Object)score);
        }
        return topDoc;
    }

    protected Object fetchValue(ClusteredDoc scoreDoc, ClusteredTopDocs topDoc) {
        ISPNEagerTopDocs eagerTopDocs = (ISPNEagerTopDocs)topDoc.getTopDocs();
        return this.cache.get(eagerTopDocs.keys[scoreDoc.getIndex()]);
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException("Not supported as you are trying to change something in the cache.  Please use searchableCache.put()");
    }

    @Override
    public boolean hasNext() {
        int nextIndex = this.currentIndex + 1;
        return this.firstResult + nextIndex < this.resultSize && nextIndex < this.maxResults;
    }
}

