/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.identity.federation.web.handlers.saml2;

import java.io.IOException;
import java.security.GeneralSecurityException;
import java.security.KeyPair;
import java.security.PrivateKey;
import java.security.cert.X509Certificate;
import org.picketlink.common.exceptions.ConfigurationException;
import org.picketlink.common.exceptions.ProcessingException;
import org.picketlink.common.util.DocumentUtil;
import org.picketlink.common.util.StringUtil;
import org.picketlink.identity.federation.api.saml.v2.sig.SAML2Signature;
import org.picketlink.identity.federation.core.saml.v2.interfaces.SAML2HandlerRequest;
import org.picketlink.identity.federation.core.saml.v2.interfaces.SAML2HandlerResponse;
import org.picketlink.identity.federation.web.handlers.saml2.AbstractSignatureHandler;
import org.picketlink.identity.federation.web.util.RedirectBindingSignatureUtil;
import org.picketlink.identity.federation.web.util.RedirectBindingUtil;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public class SAML2SignatureGenerationHandler
extends AbstractSignatureHandler {
    @Override
    public void generateSAMLRequest(SAML2HandlerRequest request, SAML2HandlerResponse response) throws ProcessingException {
        Document samlDocument = response.getResultingDocument();
        if (samlDocument == null) {
            logger.trace("No document generated in the handler chain. Cannot generate signature");
            return;
        }
        this.sign(samlDocument, request, response);
    }

    @Override
    public void handleRequestType(SAML2HandlerRequest request, SAML2HandlerResponse response) throws ProcessingException {
        Document responseDocument = response.getResultingDocument();
        if (responseDocument == null) {
            logger.trace("No response document found");
            return;
        }
        this.sign(responseDocument, request, response);
    }

    @Override
    public void handleStatusResponseType(SAML2HandlerRequest request, SAML2HandlerResponse response) throws ProcessingException {
        Document responseDocument = response.getResultingDocument();
        if (responseDocument == null) {
            logger.trace("No response document found");
            return;
        }
        this.sign(responseDocument, request, response);
    }

    private void sign(Document samlDocument, SAML2HandlerRequest request, SAML2HandlerResponse response) throws ProcessingException {
        if (!this.isSupportsSignature(request)) {
            return;
        }
        KeyPair keypair = (KeyPair)this.handlerChainConfig.getParameter("KEYPAIR");
        X509Certificate x509Certificate = (X509Certificate)this.handlerChainConfig.getParameter("X509CERTIFICATE");
        if (keypair == null) {
            logger.samlHandlerKeyPairNotFound();
            throw logger.samlHandlerKeyPairNotFoundError();
        }
        if (response.isPostBindingForResponse()) {
            logger.trace("Going to sign response document with POST binding type");
            this.signPost(samlDocument, keypair, x509Certificate);
        } else {
            logger.trace("Going to sign response document with REDIRECT binding type");
            String destinationQueryString = this.signRedirect(samlDocument, response.getRelayState(), keypair, response.getSendRequest());
            response.setDestinationQueryStringWithSignature(destinationQueryString);
        }
    }

    private void signPost(Document samlDocument, KeyPair keypair, X509Certificate x509Certificate) throws ProcessingException {
        SAML2Signature samlSignature = new SAML2Signature();
        Node nextSibling = samlSignature.getNextSiblingOfIssuer(samlDocument);
        samlSignature.setNextSibling(nextSibling);
        if (x509Certificate != null) {
            samlSignature.setX509Certificate(x509Certificate);
        }
        samlSignature.signSAMLDocument(samlDocument, keypair);
    }

    private String signRedirect(Document samlDocument, String relayState, KeyPair keypair, boolean willSendRequest) throws ProcessingException {
        try {
            String samlMessage = DocumentUtil.getDocumentAsString((Document)samlDocument);
            String base64Request = RedirectBindingUtil.deflateBase64URLEncode(samlMessage.getBytes("UTF-8"));
            PrivateKey signingKey = keypair.getPrivate();
            if (StringUtil.isNotNull((String)relayState)) {
                relayState = RedirectBindingUtil.urlEncode(relayState);
            }
            String url = willSendRequest ? RedirectBindingSignatureUtil.getSAMLRequestURLWithSignature(base64Request, relayState, signingKey) : RedirectBindingSignatureUtil.getSAMLResponseURLWithSignature(base64Request, relayState, signingKey);
            return url;
        }
        catch (ConfigurationException ce) {
            logger.samlHandlerErrorSigningRedirectBindingMessage((Throwable)ce);
            throw logger.samlHandlerSigningRedirectBindingMessageError((Throwable)ce);
        }
        catch (GeneralSecurityException ce) {
            logger.samlHandlerErrorSigningRedirectBindingMessage((Throwable)ce);
            throw logger.samlHandlerSigningRedirectBindingMessageError((Throwable)ce);
        }
        catch (IOException ce) {
            logger.samlHandlerErrorSigningRedirectBindingMessage((Throwable)ce);
            throw logger.samlHandlerSigningRedirectBindingMessageError((Throwable)ce);
        }
    }
}

