/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.mongo.keycloak.adapters;

import java.util.ArrayList;
import java.util.List;
import org.jboss.logging.Logger;
import org.keycloak.models.ApplicationModel;
import org.keycloak.models.ClientModel;
import org.keycloak.models.RealmModel;
import org.keycloak.models.UserModel;
import org.keycloak.models.UserSessionModel;
import org.keycloak.models.mongo.api.context.MongoStoreInvocationContext;
import org.keycloak.models.mongo.keycloak.adapters.AbstractMongoAdapter;
import org.keycloak.models.mongo.keycloak.adapters.RealmAdapter;
import org.keycloak.models.mongo.keycloak.entities.MongoUserSessionEntity;

public class UserSessionAdapter
extends AbstractMongoAdapter<MongoUserSessionEntity>
implements UserSessionModel {
    private static final Logger logger = Logger.getLogger(RealmAdapter.class);
    private MongoUserSessionEntity entity;
    private RealmModel realm;

    public UserSessionAdapter(MongoUserSessionEntity entity, RealmModel realm, MongoStoreInvocationContext invContext) {
        super(invContext);
        this.entity = entity;
        this.realm = realm;
    }

    @Override
    protected MongoUserSessionEntity getMongoEntity() {
        return this.entity;
    }

    public String getId() {
        return this.entity.getId();
    }

    public void setId(String id) {
        this.entity.setId(id);
        this.updateMongoEntity();
    }

    public UserModel getUser() {
        return this.realm.getUserById(this.entity.getUser());
    }

    public void setUser(UserModel user) {
        this.entity.setUser(user.getId());
        this.updateMongoEntity();
    }

    public String getIpAddress() {
        return this.entity.getIpAddress();
    }

    public void setIpAddress(String ipAddress) {
        this.entity.setIpAddress(ipAddress);
        this.updateMongoEntity();
    }

    public int getStarted() {
        return this.entity.getStarted();
    }

    public void setStarted(int started) {
        this.entity.setStarted(started);
        this.updateMongoEntity();
    }

    public int getLastSessionRefresh() {
        return this.entity.getLastSessionRefresh();
    }

    public void setLastSessionRefresh(int seconds) {
        this.entity.setLastSessionRefresh(seconds);
        this.updateMongoEntity();
    }

    public void associateClient(ClientModel client) {
        this.getMongoStore().pushItemToList(this.entity, "associatedClientIds", client.getId(), true, this.invocationContext);
    }

    public List<ClientModel> getClientAssociations() {
        List<String> associatedClientIds = this.getMongoEntity().getAssociatedClientIds();
        ArrayList<ClientModel> clients = new ArrayList<ClientModel>();
        for (String clientId : associatedClientIds) {
            ApplicationModel client = this.realm.getApplicationById(clientId);
            if (client == null) {
                client = this.realm.getOAuthClientById(clientId);
            }
            if (client != null) {
                clients.add((ClientModel)client);
                continue;
            }
            logger.warnf("Not found associated client with Id: %s", (Object)clientId);
        }
        return clients;
    }

    public void removeAssociatedClient(ClientModel client) {
        this.getMongoStore().pullItemFromList(this.entity, "associatedClientIds", client.getId(), this.invocationContext);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || !(o instanceof UserSessionModel)) {
            return false;
        }
        UserSessionModel that = (UserSessionModel)o;
        return that.getId().equals(this.getId());
    }

    @Override
    public int hashCode() {
        return this.getId().hashCode();
    }
}

