/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.impl.jgroups;

import java.util.Collections;
import java.util.List;
import java.util.Properties;
import java.util.concurrent.locks.Lock;
import org.hibernate.search.backend.BackendFactory;
import org.hibernate.search.backend.IndexingMonitor;
import org.hibernate.search.backend.LuceneWork;
import org.hibernate.search.backend.impl.jgroups.JGroupsBackendQueueTask;
import org.hibernate.search.backend.impl.jgroups.JGroupsChannelProvider;
import org.hibernate.search.backend.impl.jgroups.MasterSelectorServiceProvider;
import org.hibernate.search.backend.impl.jgroups.MessageSender;
import org.hibernate.search.backend.impl.jgroups.NodeSelectorStrategy;
import org.hibernate.search.backend.impl.jgroups.NodeSelectorStrategyHolder;
import org.hibernate.search.backend.spi.BackendQueueProcessor;
import org.hibernate.search.engine.ServiceManager;
import org.hibernate.search.indexes.impl.DirectoryBasedIndexManager;
import org.hibernate.search.spi.WorkerBuildContext;
import org.hibernate.search.util.configuration.impl.ConfigurationParseHelper;
import org.hibernate.search.util.configuration.impl.MaskedProperty;
import org.hibernate.search.util.logging.impl.Log;
import org.hibernate.search.util.logging.impl.LoggerFactory;
import org.jgroups.Address;

public class JGroupsBackendQueueProcessor
implements BackendQueueProcessor {
    private static final String JGROUPS_CONFIGURATION_SPACE = "jgroups";
    public static final String BLOCK_WAITING_ACK = "block_waiting_ack";
    public static final String DELEGATE_BACKEND = "delegate_backend";
    public static final String MESSAGE_TIMEOUT_MS = "messages_timeout";
    public static final int DEFAULT_MESSAGE_TIMEOUT = 20000;
    private static final Log log = LoggerFactory.make();
    private final NodeSelectorStrategy selectionStrategy;
    protected MessageSender messageSender;
    protected String indexName;
    protected DirectoryBasedIndexManager indexManager;
    private Address address;
    private ServiceManager serviceManager;
    private JGroupsBackendQueueTask jgroupsProcessor;
    private BackendQueueProcessor delegatedBackend;

    public JGroupsBackendQueueProcessor(NodeSelectorStrategy selectionStrategy) {
        this.selectionStrategy = selectionStrategy;
    }

    @Override
    public void initialize(Properties props, WorkerBuildContext context, DirectoryBasedIndexManager indexManager) {
        this.indexManager = indexManager;
        this.indexName = indexManager.getIndexName();
        JGroupsBackendQueueProcessor.assertLegacyOptionsNotUsed(props, this.indexName);
        this.serviceManager = context.getServiceManager();
        this.messageSender = (MessageSender)this.serviceManager.requestService(JGroupsChannelProvider.class, context);
        NodeSelectorStrategyHolder masterNodeSelector = (NodeSelectorStrategyHolder)this.serviceManager.requestService(MasterSelectorServiceProvider.class, context);
        masterNodeSelector.setNodeSelectorStrategy(this.indexName, this.selectionStrategy);
        this.selectionStrategy.viewAccepted(this.messageSender.getView());
        boolean sync = BackendFactory.isConfiguredAsSync(props);
        MaskedProperty jgroupsProperties = new MaskedProperty(props, JGROUPS_CONFIGURATION_SPACE);
        boolean block = ConfigurationParseHelper.getBooleanValue(jgroupsProperties, BLOCK_WAITING_ACK, sync);
        long messageTimeout = ConfigurationParseHelper.getLongValue(jgroupsProperties, MESSAGE_TIMEOUT_MS, 20000L);
        log.jgroupsBlockWaitingForAck(this.indexName, block);
        this.jgroupsProcessor = new JGroupsBackendQueueTask(this, indexManager, masterNodeSelector, block, messageTimeout);
        String backend = ConfigurationParseHelper.getString(jgroupsProperties, DELEGATE_BACKEND, "lucene");
        this.delegatedBackend = BackendFactory.createBackend(backend, indexManager, context, props);
    }

    @Override
    public void close() {
        this.serviceManager.releaseService(MasterSelectorServiceProvider.class);
        this.serviceManager.releaseService(JGroupsChannelProvider.class);
        this.delegatedBackend.close();
    }

    MessageSender getMessageSender() {
        return this.messageSender;
    }

    public Address getAddress() {
        if (this.address == null && this.messageSender != null) {
            this.address = this.messageSender.getAddress();
        }
        return this.address;
    }

    @Override
    public void indexMappingChanged() {
    }

    @Override
    public void applyWork(List<LuceneWork> workList, IndexingMonitor monitor) {
        if (this.selectionStrategy.isIndexOwnerLocal()) {
            this.delegatedBackend.applyWork(workList, monitor);
        } else {
            if (workList == null) {
                throw new IllegalArgumentException("workList should not be null");
            }
            this.jgroupsProcessor.sendLuceneWorkList(workList);
        }
    }

    @Override
    public void applyStreamWork(LuceneWork singleOperation, IndexingMonitor monitor) {
        if (this.selectionStrategy.isIndexOwnerLocal()) {
            this.delegatedBackend.applyStreamWork(singleOperation, monitor);
        } else {
            this.jgroupsProcessor.sendLuceneWorkList(Collections.singletonList(singleOperation));
        }
    }

    @Override
    public Lock getExclusiveWriteLock() {
        return this.delegatedBackend.getExclusiveWriteLock();
    }

    private static void assertLegacyOptionsNotUsed(Properties props, String indexName) {
        MaskedProperty jgroupsCfg = new MaskedProperty(props, "worker.backend.jgroups");
        if (jgroupsCfg.containsKey("configurationFile") || jgroupsCfg.containsKey("configurationXml") || jgroupsCfg.containsKey("configurationString") || jgroupsCfg.containsKey("clusterName")) {
            throw log.legacyJGroupsConfigurationDefined(indexName);
        }
    }

    public boolean blocksForACK() {
        return this.jgroupsProcessor.blocksForACK();
    }

    public BackendQueueProcessor getDelegatedBackend() {
        return this.delegatedBackend;
    }

    public long getMessageTimeout() {
        return this.jgroupsProcessor.getMessageTimeout();
    }
}

