/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.domain.management.security;

import java.security.KeyStore;
import org.jboss.as.domain.management.security.AbstractKeyManagerService;
import org.jboss.as.domain.management.security.FileKeystore;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.service.StopContext;
import org.jboss.msc.value.InjectedValue;

class FileKeyManagerService
extends AbstractKeyManagerService {
    private final InjectedValue<String> relativeTo = new InjectedValue();
    private volatile String provider;
    private volatile String path;
    private volatile char[] keystorePassword;
    private volatile char[] keyPassword;
    private volatile String alias;
    private volatile FileKeystore keyStore;

    FileKeyManagerService(String provider, String path, char[] keystorePassword, char[] keyPassword, String alias) {
        super(keystorePassword, keyPassword);
        this.provider = provider;
        this.path = path;
        this.keystorePassword = keystorePassword;
        this.keyPassword = keyPassword;
        this.alias = alias;
    }

    public String getProvider() {
        return this.provider;
    }

    public void setProvider(String provider) {
        this.provider = provider;
    }

    public String getPath() {
        return this.path;
    }

    public void setPath(String path) {
        this.path = path;
    }

    @Override
    public char[] getKeystorePassword() {
        return this.keystorePassword;
    }

    @Override
    public void setKeystorePassword(char[] keystorePassword) {
        this.keystorePassword = keystorePassword;
    }

    @Override
    public char[] getKeyPassword() {
        return this.keyPassword;
    }

    @Override
    public void setKeyPassword(char[] keyPassword) {
        this.keyPassword = keyPassword;
    }

    public String getAlias() {
        return this.alias;
    }

    public void setAlias(String alias) {
        this.alias = alias;
    }

    @Override
    public void start(StartContext context) throws StartException {
        String relativeTo = (String)this.relativeTo.getOptionalValue();
        String file = relativeTo == null ? this.path : relativeTo + "/" + this.path;
        this.keyStore = FileKeystore.newKeyStore(this.provider, file, this.keystorePassword, this.keyPassword, this.alias);
        this.keyStore.load();
        super.start(context);
    }

    @Override
    public void stop(StopContext context) {
        super.stop(context);
        this.keyStore = null;
    }

    @Override
    protected KeyStore loadKeyStore() {
        return this.keyStore.getKeyStore();
    }

    public InjectedValue<String> getRelativeToInjector() {
        return this.relativeTo;
    }
}

