/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.server;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Collections;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.logging.LogManager;
import org.jboss.as.controller.RunningMode;
import org.jboss.as.server.Bootstrap;
import org.jboss.as.server.CommandLineArgumentUsageImpl;
import org.jboss.as.server.ServerEnvironment;
import org.jboss.as.server.ServerMessages;
import org.jboss.as.server.SystemExiter;
import org.jboss.as.version.ProductConfig;
import org.jboss.logmanager.Level;
import org.jboss.logmanager.Logger;
import org.jboss.logmanager.handlers.ConsoleHandler;
import org.jboss.modules.Module;
import org.jboss.modules.ModuleIdentifier;
import org.jboss.stdio.LoggingOutputStream;
import org.jboss.stdio.NullInputStream;
import org.jboss.stdio.SimpleStdioContextSelector;
import org.jboss.stdio.StdioContext;
import org.jboss.stdio.StdioContextSelector;
import org.wildfly.security.manager.WildFlySecurityManager;

public final class Main {
    private static final PrintStream STDOUT = System.out;
    private static final PrintStream STDERR = System.err;

    private static void usage() {
        CommandLineArgumentUsageImpl.printUsage(STDOUT);
    }

    private Main() {
    }

    public static void main(String[] args) {
        try {
            if (LogManager.getLogManager().getClass().getName().equals("org.jboss.logmanager.LogManager")) {
                try {
                    Class.forName(ConsoleHandler.class.getName(), true, ConsoleHandler.class.getClassLoader());
                }
                catch (Throwable ignored) {
                    // empty catch block
                }
                StdioContext.install();
                StdioContext context = StdioContext.create((InputStream)new NullInputStream(), (OutputStream)new LoggingOutputStream((java.util.logging.Logger)Logger.getLogger((String)"stdout"), (java.util.logging.Level)Level.INFO), (OutputStream)new LoggingOutputStream((java.util.logging.Logger)Logger.getLogger((String)"stderr"), (java.util.logging.Level)Level.ERROR));
                StdioContext.setStdioContextSelector((StdioContextSelector)new SimpleStdioContextSelector(context));
            }
            Module.registerURLStreamHandlerFactoryModule((Module)Module.getBootModuleLoader().loadModule(ModuleIdentifier.create((String)"org.jboss.vfs")));
            ServerEnvironment serverEnvironment = Main.determineEnvironment(args, WildFlySecurityManager.getSystemPropertiesPrivileged(), WildFlySecurityManager.getSystemEnvironmentPrivileged(), ServerEnvironment.LaunchType.STANDALONE);
            if (serverEnvironment != null) {
                Bootstrap bootstrap = Bootstrap.Factory.newInstance();
                Bootstrap.Configuration configuration = new Bootstrap.Configuration(serverEnvironment);
                configuration.setModuleLoader(Module.getBootModuleLoader());
                bootstrap.bootstrap(configuration, Collections.emptyList()).get();
                return;
            }
            Main.abort(null);
        }
        catch (Throwable t) {
            Main.abort(t);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void abort(Throwable t) {
        try {
            if (t != null) {
                t.printStackTrace(STDERR);
            }
        }
        finally {
            SystemExiter.exit(1);
        }
    }

    public static ServerEnvironment determineEnvironment(String[] args, Properties systemProperties, Map<String, String> systemEnvironment, ServerEnvironment.LaunchType launchType) {
        int argsLength = args.length;
        String serverConfig = null;
        String initialServerConfig = null;
        RunningMode runningMode = RunningMode.NORMAL;
        for (int i = 0; i < argsLength; ++i) {
            String arg = args[i];
            try {
                String value;
                if ("--version".equals(arg) || "-v".equals(arg) || "-version".equals(arg) || "-V".equals(arg)) {
                    ProductConfig productConfig = new ProductConfig(Module.getBootModuleLoader(), WildFlySecurityManager.getPropertyPrivileged((String)"jboss.home.dir", null), null);
                    STDOUT.println(productConfig.getPrettyVersionString());
                    return null;
                }
                if ("--help".equals(arg) || "-h".equals(arg) || "-help".equals(arg)) {
                    Main.usage();
                    return null;
                }
                if ("--server-config".equals(arg) || "-c".equals(arg) || "-server-config".equals(arg)) {
                    serverConfig = args[++i];
                    continue;
                }
                if (arg.startsWith("--server-config")) {
                    serverConfig = Main.parseValue(arg, "--server-config");
                    if (serverConfig != null) continue;
                    return null;
                }
                if (arg.startsWith("-c")) {
                    serverConfig = Main.parseValue(arg, "-c");
                    if (serverConfig != null) continue;
                    return null;
                }
                if (arg.startsWith("--read-only-server-config")) {
                    initialServerConfig = Main.parseValue(arg, "--read-only-server-config");
                    if (initialServerConfig != null) continue;
                    return null;
                }
                if (arg.startsWith("-server-config")) {
                    serverConfig = Main.parseValue(arg, "-server-config");
                    if (serverConfig != null) continue;
                    return null;
                }
                if ("--properties".equals(arg) || "-properties".equals(arg) || "-P".equals(arg)) {
                    if (Main.processProperties(arg, args[++i], systemProperties)) continue;
                    return null;
                }
                if (arg.startsWith("--properties")) {
                    String urlSpec = Main.parseValue(arg, "--properties");
                    if (urlSpec != null && Main.processProperties(arg, urlSpec, systemProperties)) continue;
                    return null;
                }
                if (arg.startsWith("-P")) {
                    String urlSpec = Main.parseValue(arg, "-P");
                    if (urlSpec != null && Main.processProperties(arg, urlSpec, systemProperties)) continue;
                    return null;
                }
                if (arg.startsWith("-properties")) {
                    String urlSpec = Main.parseValue(arg, "-properties");
                    if (urlSpec != null && Main.processProperties(arg, urlSpec, systemProperties)) continue;
                    return null;
                }
                if (arg.startsWith("-D")) {
                    String name;
                    int idx = arg.indexOf("=");
                    if (idx == -1) {
                        name = arg.substring(2);
                        value = "true";
                    } else {
                        name = arg.substring(2, idx);
                        value = arg.substring(idx + 1, arg.length());
                    }
                    systemProperties.setProperty(name, value);
                    continue;
                }
                if (arg.startsWith("-b")) {
                    int idx = arg.indexOf(61);
                    if (idx == arg.length() - 1) {
                        STDERR.println(ServerMessages.MESSAGES.noArgValue(arg));
                        Main.usage();
                        return null;
                    }
                    value = idx > -1 ? arg.substring(idx + 1) : args[++i];
                    value = Main.fixPossibleIPv6URL(value);
                    String propertyName = null;
                    propertyName = idx < 0 ? (arg.length() == 2 ? "jboss.bind.address" : "jboss.bind.address." + arg.substring(2)) : (idx == 2 ? "jboss.bind.address" : "jboss.bind.address." + arg.substring(2, idx));
                    systemProperties.setProperty(propertyName, value);
                    continue;
                }
                if (arg.startsWith("-u")) {
                    int idx = arg.indexOf(61);
                    if (idx == arg.length() - 1) {
                        STDERR.println(ServerMessages.MESSAGES.valueExpectedForCommandLineOption(arg));
                        Main.usage();
                        return null;
                    }
                    value = idx > -1 ? arg.substring(idx + 1) : args[++i];
                    value = Main.fixPossibleIPv6URL(value);
                    systemProperties.setProperty("jboss.default.multicast.address", value);
                    continue;
                }
                if ("--admin-only".equals(arg)) {
                    runningMode = RunningMode.ADMIN_ONLY;
                    continue;
                }
                if (arg.startsWith("-S")) {
                    String token = arg.substring(2);
                    Main.processSecurityProperties(token, systemProperties);
                    continue;
                }
                if (arg.equals("--debug")) {
                    String nextArg;
                    int next = i + 1;
                    if (next < argsLength && !(nextArg = args[next]).startsWith("-")) {
                        try {
                            Integer.parseInt(nextArg);
                            ++i;
                        }
                        catch (NumberFormatException ignore) {}
                    }
                    continue;
                }
                STDERR.println(ServerMessages.MESSAGES.invalidCommandLineOption(arg));
                Main.usage();
                return null;
            }
            catch (IndexOutOfBoundsException e) {
                STDERR.println(ServerMessages.MESSAGES.valueExpectedForCommandLineOption(arg));
                Main.usage();
                return null;
            }
        }
        if (serverConfig != null && initialServerConfig != null) {
            throw ServerMessages.MESSAGES.cannotHaveBothInitialServerConfigAndServerConfig();
        }
        String hostControllerName = null;
        ProductConfig productConfig = new ProductConfig(Module.getBootModuleLoader(), WildFlySecurityManager.getPropertyPrivileged((String)"jboss.home.dir", null), (Map)systemProperties);
        return new ServerEnvironment(hostControllerName, systemProperties, systemEnvironment, serverConfig, initialServerConfig, launchType, runningMode, productConfig);
    }

    private static String parseValue(String arg, String key) {
        String value = null;
        int splitPos = key.length();
        if (arg.length() <= splitPos + 1 || arg.charAt(splitPos) != '=') {
            Main.usage();
        } else {
            value = arg.substring(splitPos + 1);
        }
        return value;
    }

    private static String fixPossibleIPv6URL(String val) {
        String result = val;
        if (val != null && val.length() > 2 && val.charAt(0) == '[' && val.charAt(val.length() - 1) == ']' && val.contains(":")) {
            result = val.substring(1, val.length() - 1);
        }
        return result;
    }

    private static boolean processProperties(String arg, String urlSpec, Properties systemProperties) {
        URL url = null;
        try {
            url = Main.makeURL(urlSpec);
            systemProperties.load(url.openConnection().getInputStream());
            return true;
        }
        catch (MalformedURLException e) {
            STDERR.println(ServerMessages.MESSAGES.malformedCommandLineURL(urlSpec, arg));
            Main.usage();
            return false;
        }
        catch (IOException e) {
            STDERR.println(ServerMessages.MESSAGES.unableToLoadProperties(url));
            Main.usage();
            return false;
        }
    }

    private static URL makeURL(String urlspec) throws MalformedURLException {
        URL url;
        urlspec = urlspec.trim();
        try {
            url = new URL(urlspec);
            if (url.getProtocol().equals("file")) {
                File file = new File(url.getFile()).getCanonicalFile();
                url = file.toURI().toURL();
            }
        }
        catch (Exception e) {
            try {
                File file = new File(urlspec).getCanonicalFile();
                url = file.toURI().toURL();
            }
            catch (Exception n) {
                throw new MalformedURLException(n.toString());
            }
        }
        return url;
    }

    private static void processSecurityProperties(String secProperties, Properties systemProperties) {
        StringTokenizer tokens = new StringTokenizer(secProperties, ",");
        while (tokens != null && tokens.hasMoreTokens()) {
            String token = tokens.nextToken();
            int idx = token.indexOf(61);
            if (idx == token.length() - 1) {
                STDERR.println(ServerMessages.MESSAGES.valueExpectedForCommandLineOption(secProperties));
                Main.usage();
                return;
            }
            String value = token.substring(idx + 1);
            String key = token.substring(0, idx);
            systemProperties.setProperty(key, value);
        }
    }
}

