/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.bootstrap;

import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import javax.enterprise.context.spi.Context;
import javax.enterprise.inject.spi.Extension;
import org.jboss.weld.annotated.enhanced.EnhancedAnnotatedMethod;
import org.jboss.weld.annotated.enhanced.EnhancedAnnotatedType;
import org.jboss.weld.bean.RIBean;
import org.jboss.weld.bean.builtin.ExtensionBean;
import org.jboss.weld.bootstrap.BeanDeployment;
import org.jboss.weld.bootstrap.BeanDeploymentArchiveMapping;
import org.jboss.weld.bootstrap.ContextHolder;
import org.jboss.weld.bootstrap.MissingDependenciesRegistry;
import org.jboss.weld.bootstrap.ObserverInitializationContext;
import org.jboss.weld.bootstrap.events.ContainerLifecycleEvents;
import org.jboss.weld.bootstrap.spi.Deployment;
import org.jboss.weld.bootstrap.spi.Metadata;
import org.jboss.weld.event.ObserverFactory;
import org.jboss.weld.event.ObserverMethodImpl;
import org.jboss.weld.logging.BootstrapLogger;
import org.jboss.weld.manager.BeanManagerImpl;
import org.jboss.weld.resources.ClassTransformer;
import org.jboss.weld.resources.spi.ResourceLoadingException;
import org.jboss.weld.util.BeanMethods;
import org.jboss.weld.util.DeploymentStructures;
import org.jboss.weld.util.reflection.Formats;
import org.jboss.weld.util.reflection.Reflections;

public class ExtensionBeanDeployer {
    private final BeanManagerImpl beanManager;
    private final Set<Metadata<Extension>> extensions;
    private final Deployment deployment;
    private final BeanDeploymentArchiveMapping bdaMapping;
    private final Collection<ContextHolder<? extends Context>> contexts;
    private final ContainerLifecycleEvents containerLifecycleEventObservers;
    private final MissingDependenciesRegistry missingDependenciesRegistry;

    public ExtensionBeanDeployer(BeanManagerImpl manager, Deployment deployment, BeanDeploymentArchiveMapping bdaMapping, Collection<ContextHolder<? extends Context>> contexts) {
        this.beanManager = manager;
        this.extensions = new HashSet<Metadata<Extension>>();
        this.deployment = deployment;
        this.bdaMapping = bdaMapping;
        this.contexts = contexts;
        this.containerLifecycleEventObservers = (ContainerLifecycleEvents)this.beanManager.getServices().get(ContainerLifecycleEvents.class);
        this.missingDependenciesRegistry = (MissingDependenciesRegistry)this.beanManager.getServices().get(MissingDependenciesRegistry.class);
    }

    public ExtensionBeanDeployer deployBeans() {
        ClassTransformer classTransformer = (ClassTransformer)this.beanManager.getServices().get(ClassTransformer.class);
        for (Metadata<Extension> extension : this.extensions) {
            BeanDeployment beanDeployment;
            EnhancedAnnotatedType<Extension> enchancedAnnotatedType = this.getEnhancedAnnotatedType(classTransformer, extension, beanDeployment = DeploymentStructures.getOrCreateBeanDeployment(this.deployment, this.beanManager, this.bdaMapping, this.contexts, ((Extension)extension.getValue()).getClass()));
            if (enchancedAnnotatedType == null) continue;
            ExtensionBean bean = new ExtensionBean(beanDeployment.getBeanManager(), enchancedAnnotatedType, extension);
            HashSet observerMethodInitializers = new HashSet();
            this.createObserverMethods(bean, beanDeployment.getBeanManager(), enchancedAnnotatedType, observerMethodInitializers);
            beanDeployment.getBeanManager().addBean(bean);
            beanDeployment.getBeanDeployer().addExtension(bean);
            for (ObserverInitializationContext observerInitializationContext : observerMethodInitializers) {
                observerInitializationContext.initialize();
                beanDeployment.getBeanManager().addObserver(observerInitializationContext.getObserver());
                this.containerLifecycleEventObservers.processObserverMethod(observerInitializationContext.getObserver());
            }
        }
        return this;
    }

    private EnhancedAnnotatedType<Extension> getEnhancedAnnotatedType(ClassTransformer classTransformer, Metadata<Extension> extension, BeanDeployment beanDeployment) {
        Class<?> clazz = ((Extension)extension.getValue()).getClass();
        try {
            return (EnhancedAnnotatedType)Reflections.cast(classTransformer.getEnhancedAnnotatedType(clazz, beanDeployment.getBeanDeploymentArchive().getId()));
        }
        catch (ResourceLoadingException e) {
            String missingDependency = Formats.getNameOfMissingClassLoaderDependency(e);
            BootstrapLogger.LOG.ignoringExtensionClassDueToLoadingError(clazz.getName(), missingDependency);
            BootstrapLogger.LOG.catchingDebug(e);
            this.missingDependenciesRegistry.registerClassWithMissingDependency(clazz.getName(), missingDependency);
            return null;
        }
    }

    public void addExtensions(Iterable<Metadata<Extension>> extensions) {
        for (Metadata<Extension> extension : extensions) {
            this.addExtension(extension);
        }
    }

    public void addExtension(Metadata<Extension> extension) {
        this.extensions.add(extension);
    }

    protected <X> void createObserverMethods(RIBean<X> declaringBean, BeanManagerImpl beanManager, EnhancedAnnotatedType<? super X> annotatedClass, Set<ObserverInitializationContext<?, ?>> observerMethodInitializers) {
        for (EnhancedAnnotatedMethod<?, ? super X> enhancedAnnotatedMethod : BeanMethods.getObserverMethods(annotatedClass)) {
            this.createObserverMethod(declaringBean, beanManager, enhancedAnnotatedMethod, observerMethodInitializers);
        }
    }

    protected <T, X> void createObserverMethod(RIBean<X> declaringBean, BeanManagerImpl beanManager, EnhancedAnnotatedMethod<T, ? super X> method, Set<ObserverInitializationContext<?, ?>> observerMethodInitializers) {
        ObserverMethodImpl<T, ? super X> observer = ObserverFactory.create(method, declaringBean, beanManager);
        ObserverInitializationContext<T, ? super X> observerMethodInitializer = ObserverInitializationContext.of(observer, method);
        observerMethodInitializers.add(observerMethodInitializer);
    }
}

