/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.facet.index;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import org.apache.lucene.util.encoding.IntEncoder;

public class CategoryListPayloadStream {
    private ByteArrayOutputStream baos = new ByteArrayOutputStream(50);
    private IntEncoder encoder;

    public CategoryListPayloadStream(IntEncoder encoder) {
        this.encoder = encoder;
        this.encoder.reInit(this.baos);
    }

    public void appendIntToStream(int intValue) throws IOException {
        this.encoder.encode(intValue);
    }

    public byte[] convertStreamToByteArray() {
        try {
            this.encoder.close();
            return this.baos.toByteArray();
        }
        catch (IOException e) {
            return new byte[0];
        }
    }

    public void reset() throws IOException {
        this.encoder.close();
        this.baos.reset();
        this.encoder.reInit(this.baos);
    }
}

