/*
 * Decompiled with CFR 0.152.
 */
package org.apache.log4j.spi;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamField;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Collections;
import java.util.Hashtable;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Category;
import org.apache.log4j.JBossLevelMapping;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;
import org.apache.log4j.helpers.Loader;
import org.apache.log4j.helpers.LogLog;
import org.apache.log4j.spi.LocationInfo;
import org.apache.log4j.spi.ThrowableInformation;
import org.jboss.logmanager.ExtLogRecord;
import org.jboss.modules.Module;

public class LoggingEvent
implements Serializable {
    static final long serialVersionUID = -868428216207166145L;
    private static final Field logRecordField;
    private static final ObjectStreamField[] serialPersistentFields;
    private static long startTime;
    public final String categoryName;
    public final long timeStamp;
    public final transient String fqnOfCategoryClass;
    public transient Priority level;
    private transient Category logger;
    private final transient ExtLogRecord logRecord;
    private transient ThrowableInformation cachedThrowableInformation;
    private transient LocationInfo cachedLocationInfo;
    static final Integer[] PARAM_ARRAY;
    static final String TO_LEVEL = "toLevel";
    static final Class[] TO_LEVEL_PARAMS;
    static final Hashtable methodCache;

    public LoggingEvent(String fqnOfCategoryClass, Category logger, Priority level, Object message, Throwable throwable) {
        this.fqnOfCategoryClass = fqnOfCategoryClass;
        this.logger = logger;
        this.level = level;
        this.logRecord = new ExtLogRecord(JBossLevelMapping.getLevelFor(level), message == null ? null : message.toString(), ExtLogRecord.FormatStyle.NO_FORMAT, fqnOfCategoryClass);
        if (logger != null) {
            this.categoryName = logger.getName();
            this.logRecord.setLoggerName(this.categoryName);
        } else {
            this.categoryName = null;
        }
        if (throwable != null) {
            this.logRecord.setThrown(throwable);
        }
        this.timeStamp = System.currentTimeMillis();
        this.logRecord.setMillis(this.timeStamp);
    }

    public LoggingEvent(String fqnOfCategoryClass, Category logger, long timeStamp, Priority level, Object message, Throwable throwable) {
        this.fqnOfCategoryClass = fqnOfCategoryClass;
        this.logger = logger;
        this.level = level;
        this.logRecord = new ExtLogRecord(JBossLevelMapping.getLevelFor(level), message == null ? null : message.toString(), ExtLogRecord.FormatStyle.NO_FORMAT, fqnOfCategoryClass);
        if (logger != null) {
            this.categoryName = logger.getName();
            this.logRecord.setLoggerName(this.categoryName);
        } else {
            this.categoryName = null;
        }
        if (throwable != null) {
            this.logRecord.setThrown(throwable);
        }
        this.timeStamp = timeStamp;
        this.logRecord.setMillis(this.timeStamp);
    }

    public LoggingEvent(String fqnOfCategoryClass, Category logger, long timeStamp, Level level, Object message, String threadName, ThrowableInformation throwable, String ndc, LocationInfo info, Map properties) {
        this.fqnOfCategoryClass = fqnOfCategoryClass;
        this.logger = logger;
        this.level = level;
        this.logRecord = new ExtLogRecord(JBossLevelMapping.getLevelFor(level), message == null ? null : message.toString(), ExtLogRecord.FormatStyle.NO_FORMAT, fqnOfCategoryClass);
        if (logger != null) {
            this.categoryName = logger.getName();
            this.logRecord.setLoggerName(this.categoryName);
        } else {
            this.categoryName = null;
        }
        if (throwable != null) {
            this.cachedThrowableInformation = throwable;
            this.logRecord.setThrown(this.cachedThrowableInformation.getThrowable());
        }
        this.timeStamp = timeStamp;
        if (threadName != null) {
            this.logRecord.setThreadName(threadName);
        }
        if (ndc != null) {
            this.logRecord.setNdc(ndc);
        }
        if (info != null) {
            this.cachedLocationInfo = info;
            this.logRecord.setSourceClassName(info.getClassName());
            this.logRecord.setSourceMethodName(info.getMethodName());
            this.logRecord.setSourceFileName(info.getFileName());
            try {
                this.logRecord.setSourceLineNumber(Integer.parseInt(info.getLineNumber(), 10));
            }
            catch (NumberFormatException ignored) {
                this.logRecord.setSourceLineNumber(-1);
            }
        }
        if (properties != null) {
            this.logRecord.setMdc(properties);
        }
    }

    public LoggingEvent(ExtLogRecord logRecord, Category logger) {
        this.logRecord = logRecord;
        this.fqnOfCategoryClass = logRecord.getLoggerClassName();
        this.logger = logger;
        this.level = JBossLevelMapping.getPriorityFor(logRecord.getLevel());
        this.categoryName = logRecord.getLoggerName();
        this.timeStamp = logRecord.getMillis();
    }

    public LocationInfo getLocationInformation() {
        if (this.cachedLocationInfo == null) {
            this.cachedLocationInfo = new LocationInfo(this.logRecord.getSourceFileName(), this.logRecord.getSourceClassName(), this.logRecord.getSourceMethodName(), Integer.toString(this.logRecord.getSourceLineNumber()));
        }
        return this.cachedLocationInfo;
    }

    public Level getLevel() {
        return (Level)this.level;
    }

    public String getLoggerName() {
        return this.categoryName;
    }

    public Category getLogger() {
        return this.logger;
    }

    public Object getMessage() {
        return this.logRecord.getMessage();
    }

    public String getNDC() {
        return this.logRecord.getNdc();
    }

    public Object getMDC(String key) {
        return this.logRecord.getMdc(key);
    }

    public void getMDCCopy() {
        this.logRecord.copyMdc();
    }

    public String getRenderedMessage() {
        return this.logRecord.getFormattedMessage();
    }

    public static long getStartTime() {
        return startTime;
    }

    public String getThreadName() {
        return this.logRecord.getThreadName();
    }

    public ThrowableInformation getThrowableInformation() {
        if (this.cachedThrowableInformation == null) {
            this.cachedThrowableInformation = new ThrowableInformation(this.logRecord.getThrown(), this.logger);
        }
        return this.cachedThrowableInformation;
    }

    public String[] getThrowableStrRep() {
        return this.getThrowableInformation().getThrowableStrRep();
    }

    private void readObject(ObjectInputStream ois) throws IOException, ClassNotFoundException {
        ThrowableInformation throwableInfo;
        ObjectInputStream.GetField getField = ois.readFields();
        int levelId = ois.readInt();
        String levelClassName = (String)ois.readObject();
        Level level = null;
        if (levelClassName == null) {
            level = Level.toLevel(levelId);
        } else {
            Class<Level> levelClass = Loader.loadClass(levelClassName).asSubclass(Level.class);
            try {
                Method method = levelClass.getDeclaredMethod(TO_LEVEL, Integer.TYPE);
                level = (Level)method.invoke(null, levelId);
            }
            catch (Exception e) {
                LogLog.warn("Level deserialization failed, reverting to default.", e);
                level = Level.toLevel(levelId);
            }
        }
        String categoryName = (String)getField.get("categoryName", null);
        Hashtable mdcCopy = (Hashtable)getField.get("mdcCopy", null);
        String ndc = (String)getField.get("ndc", null);
        String renderedMessage = (String)getField.get("renderedMessage", null);
        long timeStamp = getField.get("timeStamp", -1L);
        String threadName = (String)getField.get("threadName", null);
        this.cachedThrowableInformation = throwableInfo = (ThrowableInformation)getField.get("throwableInfo", ThrowableInformation.class);
        throwableInfo.getThrowableStrRep();
        ExtLogRecord record = new ExtLogRecord(JBossLevelMapping.getLevelFor(level), renderedMessage, ExtLogRecord.FormatStyle.NO_FORMAT, Logger.class.getName());
        if (categoryName != null) {
            record.setLoggerName(categoryName.toString());
        }
        record.setMdc((Map)(mdcCopy == null ? Collections.emptyMap() : mdcCopy));
        record.setNdc(ndc == null ? "" : ndc);
        record.setMillis(timeStamp);
        record.setThreadName(threadName == null ? "<unknown>" : threadName);
        record.setThrown(throwableInfo == null ? null : throwableInfo.getThrowable());
        record.disableCallerCalculation();
        this.cachedLocationInfo = new LocationInfo(null, null);
        try {
            logRecordField.set(this, record);
        }
        catch (IllegalAccessException e) {
            throw new IllegalAccessError(e.getMessage());
        }
    }

    private void writeObject(ObjectOutputStream oos) throws IOException {
        ObjectOutputStream.PutField putField = oos.putFields();
        putField.put("categoryName", this.logRecord.getLoggerName());
        putField.put("mdcCopy", new Hashtable(this.logRecord.getMdcCopy()));
        putField.put("ndc", this.logRecord.getNdc());
        putField.put("renderedMessage", this.logRecord.getFormattedMessage());
        putField.put("timeStamp", this.logRecord.getMillis());
        putField.put("threadName", this.logRecord.getThreadName());
        this.getThrowableStrRep();
        putField.put("throwableInfo", this.getThrowableInformation());
        oos.writeFields();
        Level level = this.getLevel();
        oos.writeInt(level.toInt());
        Class<?> levelClass = level.getClass();
        oos.writeObject(levelClass == Level.class ? null : levelClass);
    }

    public final void setProperty(String propName, String propValue) {
        this.logRecord.putMdc(propName, propValue);
    }

    public final String getProperty(String key) {
        return this.logRecord.getMdc(key);
    }

    public final boolean locationInformationExists() {
        return this.cachedLocationInfo != null;
    }

    public final long getTimeStamp() {
        return this.logRecord.getMillis();
    }

    public Set getPropertyKeySet() {
        return this.getProperties().keySet();
    }

    public Map getProperties() {
        return this.logRecord.getMdcCopy();
    }

    public String getFQNOfLoggerClass() {
        return this.fqnOfCategoryClass;
    }

    public Object removeProperty(String propName) {
        return this.logRecord.putMdc(propName, null);
    }

    public ExtLogRecord getLogRecord() {
        return this.logRecord;
    }

    static {
        serialPersistentFields = new ObjectStreamField[]{new ObjectStreamField("categoryName", String.class), new ObjectStreamField("locationInfo", LocationInfo.class), new ObjectStreamField("mdcCopy", Hashtable.class), new ObjectStreamField("mdcCopyLookupRequired", Boolean.TYPE), new ObjectStreamField("ndc", String.class), new ObjectStreamField("ndcLookupRequired", Boolean.TYPE), new ObjectStreamField("renderedMessage", String.class), new ObjectStreamField("timeStamp", Long.TYPE), new ObjectStreamField("threadName", String.class), new ObjectStreamField("throwableInfo", ThrowableInformation.class)};
        long time = 0L;
        try {
            time = Module.getStartTime();
        }
        catch (Throwable ignored) {
            time = System.currentTimeMillis();
        }
        startTime = time;
        logRecordField = AccessController.doPrivileged(new PrivilegedAction<Field>(){

            @Override
            public Field run() {
                Field field;
                try {
                    field = LoggingEvent.class.getDeclaredField("logRecord");
                }
                catch (NoSuchFieldException e) {
                    throw new NoSuchFieldError(e.getMessage());
                }
                field.setAccessible(true);
                return field;
            }
        });
        PARAM_ARRAY = new Integer[1];
        TO_LEVEL_PARAMS = new Class[]{Integer.TYPE};
        methodCache = new Hashtable(3);
    }
}

