/*
 * Decompiled with CFR 0.152.
 */
package org.hornetq.core.client.impl;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectStreamException;
import java.io.Serializable;
import java.lang.reflect.Array;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import org.hornetq.api.core.DiscoveryGroupConfiguration;
import org.hornetq.api.core.HornetQException;
import org.hornetq.api.core.HornetQExceptionType;
import org.hornetq.api.core.HornetQIllegalStateException;
import org.hornetq.api.core.HornetQInterruptedException;
import org.hornetq.api.core.Interceptor;
import org.hornetq.api.core.Pair;
import org.hornetq.api.core.TransportConfiguration;
import org.hornetq.api.core.client.ClientSessionFactory;
import org.hornetq.api.core.client.ClusterTopologyListener;
import org.hornetq.api.core.client.HornetQClient;
import org.hornetq.api.core.client.loadbalance.ConnectionLoadBalancingPolicy;
import org.hornetq.core.client.HornetQClientLogger;
import org.hornetq.core.client.HornetQClientMessageBundle;
import org.hornetq.core.client.impl.AfterConnectInternalListener;
import org.hornetq.core.client.impl.ClientSessionFactoryImpl;
import org.hornetq.core.client.impl.ClientSessionFactoryInternal;
import org.hornetq.core.client.impl.ServerLocatorInternal;
import org.hornetq.core.client.impl.Topology;
import org.hornetq.core.client.impl.TopologyMemberImpl;
import org.hornetq.core.cluster.DiscoveryEntry;
import org.hornetq.core.cluster.DiscoveryGroup;
import org.hornetq.core.cluster.DiscoveryListener;
import org.hornetq.core.protocol.ClientPacketDecoder;
import org.hornetq.core.protocol.core.impl.PacketDecoder;
import org.hornetq.core.remoting.FailureListener;
import org.hornetq.spi.core.remoting.Connector;
import org.hornetq.utils.ClassloadingUtil;
import org.hornetq.utils.HornetQThreadFactory;
import org.hornetq.utils.UUIDGenerator;

public final class ServerLocatorImpl
implements ServerLocatorInternal,
DiscoveryListener,
Serializable {
    private final Set<ClusterTopologyListener> topologyListeners = new HashSet<ClusterTopologyListener>();
    private static final long serialVersionUID = -1615857864410205260L;
    private final boolean ha;
    private boolean finalizeCheck = true;
    private boolean clusterConnection;
    private transient String identity;
    private final Set<ClientSessionFactoryInternal> factories = new HashSet<ClientSessionFactoryInternal>();
    private final Set<ClientSessionFactoryInternal> connectingFactories = new HashSet<ClientSessionFactoryInternal>();
    private volatile TransportConfiguration[] initialConnectors;
    private final DiscoveryGroupConfiguration discoveryGroupConfiguration;
    private final StaticConnector staticConnector = new StaticConnector();
    private final Topology topology;
    private String topologyArrayGuard = new String();
    private volatile Pair<TransportConfiguration, TransportConfiguration>[] topologyArray;
    private volatile boolean receivedTopology;
    private boolean compressLargeMessage;
    private transient boolean shutdownPool;
    private transient ExecutorService threadPool;
    private transient ScheduledExecutorService scheduledThreadPool;
    private transient DiscoveryGroup discoveryGroup;
    private transient ConnectionLoadBalancingPolicy loadBalancingPolicy;
    private boolean cacheLargeMessagesClient;
    private long clientFailureCheckPeriod;
    private long connectionTTL;
    private long callTimeout;
    private long callFailoverTimeout;
    private int minLargeMessageSize;
    private int consumerWindowSize;
    private int consumerMaxRate;
    private int confirmationWindowSize;
    private int producerWindowSize;
    private int producerMaxRate;
    private boolean blockOnAcknowledge;
    private boolean blockOnDurableSend;
    private boolean blockOnNonDurableSend;
    private boolean autoGroup;
    private boolean preAcknowledge;
    private String connectionLoadBalancingPolicyClassName;
    private int ackBatchSize;
    private boolean useGlobalPools;
    private int scheduledThreadPoolMaxSize;
    private int threadPoolMaxSize;
    private long retryInterval;
    private double retryIntervalMultiplier;
    private long maxRetryInterval;
    private int reconnectAttempts;
    private int initialConnectAttempts;
    private boolean failoverOnInitialConnection;
    private int initialMessagePacketSize;
    private String stateGuard = new String();
    private transient STATE state;
    private transient CountDownLatch latch;
    private final List<Interceptor> incomingInterceptors = new CopyOnWriteArrayList<Interceptor>();
    private final List<Interceptor> outgoingInterceptors = new CopyOnWriteArrayList<Interceptor>();
    private static ExecutorService globalThreadPool;
    private Executor startExecutor;
    private static ScheduledExecutorService globalScheduledThreadPool;
    private AfterConnectInternalListener afterConnectListener;
    private String groupID;
    private String nodeID;
    private TransportConfiguration clusterTransportConfiguration;
    private transient PacketDecoder packetDecoder = ClientPacketDecoder.INSTANCE;
    private final Exception traceException = new Exception();
    public static Runnable finalizeCallback;

    public static synchronized void clearThreadPools() {
        if (globalThreadPool != null) {
            globalThreadPool.shutdown();
            try {
                if (!globalThreadPool.awaitTermination(10L, TimeUnit.SECONDS)) {
                    throw new IllegalStateException("Couldn't finish the globalThreadPool");
                }
            }
            catch (InterruptedException e) {
                throw new HornetQInterruptedException((Throwable)e);
            }
            finally {
                globalThreadPool = null;
            }
        }
        if (globalScheduledThreadPool != null) {
            globalScheduledThreadPool.shutdown();
            try {
                if (!globalScheduledThreadPool.awaitTermination(10L, TimeUnit.SECONDS)) {
                    throw new IllegalStateException("Couldn't finish the globalScheduledThreadPool");
                }
            }
            catch (InterruptedException e) {
                throw new HornetQInterruptedException((Throwable)e);
            }
            finally {
                globalScheduledThreadPool = null;
            }
        }
    }

    private static synchronized ExecutorService getGlobalThreadPool() {
        if (globalThreadPool == null) {
            HornetQThreadFactory factory = new HornetQThreadFactory("HornetQ-client-global-threads", true, ServerLocatorImpl.getThisClassLoader());
            globalThreadPool = Executors.newCachedThreadPool((ThreadFactory)factory);
        }
        return globalThreadPool;
    }

    private static synchronized ScheduledExecutorService getGlobalScheduledThreadPool() {
        if (globalScheduledThreadPool == null) {
            HornetQThreadFactory factory = new HornetQThreadFactory("HornetQ-client-global-scheduled-threads", true, ServerLocatorImpl.getThisClassLoader());
            globalScheduledThreadPool = Executors.newScheduledThreadPool(5, (ThreadFactory)factory);
        }
        return globalScheduledThreadPool;
    }

    private synchronized void setThreadPools() {
        if (this.threadPool != null) {
            return;
        }
        if (this.useGlobalPools) {
            this.threadPool = ServerLocatorImpl.getGlobalThreadPool();
            this.scheduledThreadPool = ServerLocatorImpl.getGlobalScheduledThreadPool();
        } else {
            this.shutdownPool = true;
            HornetQThreadFactory factory = new HornetQThreadFactory("HornetQ-client-factory-threads-" + System.identityHashCode(this), true, ServerLocatorImpl.getThisClassLoader());
            this.threadPool = this.threadPoolMaxSize == -1 ? Executors.newCachedThreadPool((ThreadFactory)factory) : Executors.newFixedThreadPool(this.threadPoolMaxSize, (ThreadFactory)factory);
            factory = new HornetQThreadFactory("HornetQ-client-factory-pinger-threads-" + System.identityHashCode(this), true, ServerLocatorImpl.getThisClassLoader());
            this.scheduledThreadPool = Executors.newScheduledThreadPool(this.scheduledThreadPoolMaxSize, (ThreadFactory)factory);
        }
    }

    private static ClassLoader getThisClassLoader() {
        return AccessController.doPrivileged(new PrivilegedAction<ClassLoader>(){

            @Override
            public ClassLoader run() {
                return ClientSessionFactoryImpl.class.getClassLoader();
            }
        });
    }

    private void instantiateLoadBalancingPolicy() {
        if (this.connectionLoadBalancingPolicyClassName == null) {
            throw new IllegalStateException("Please specify a load balancing policy class name on the session factory");
        }
        AccessController.doPrivileged(new PrivilegedAction<Object>(){

            @Override
            public Object run() {
                ServerLocatorImpl.this.loadBalancingPolicy = (ConnectionLoadBalancingPolicy)ClassloadingUtil.newInstanceFromClassLoader((String)ServerLocatorImpl.this.connectionLoadBalancingPolicyClassName);
                return null;
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void initialise() throws HornetQException {
        if (this.state == STATE.INITIALIZED) {
            return;
        }
        String string = this.stateGuard;
        synchronized (string) {
            if (this.state == STATE.CLOSING) {
                throw new HornetQIllegalStateException();
            }
            try {
                this.state = STATE.INITIALIZED;
                this.latch = new CountDownLatch(1);
                this.setThreadPools();
                this.instantiateLoadBalancingPolicy();
                if (this.discoveryGroupConfiguration != null) {
                    this.discoveryGroup = ServerLocatorImpl.createDiscoveryGroup(this.nodeID, this.discoveryGroupConfiguration);
                    this.discoveryGroup.registerListener(this);
                    this.discoveryGroup.start();
                }
            }
            catch (Exception e) {
                this.state = null;
                throw HornetQClientMessageBundle.BUNDLE.failedToInitialiseSessionFactory(e);
            }
        }
    }

    private static DiscoveryGroup createDiscoveryGroup(String nodeID, DiscoveryGroupConfiguration config) throws Exception {
        DiscoveryGroup group = new DiscoveryGroup(nodeID, config.getName(), config.getRefreshTimeout(), config.getBroadcastEndpointFactoryConfiguration().createBroadcastEndpointFactory(), null);
        return group;
    }

    private ServerLocatorImpl(Topology topology, boolean useHA, DiscoveryGroupConfiguration discoveryGroupConfiguration, TransportConfiguration[] transportConfigs) {
        this.traceException.fillInStackTrace();
        this.topology = topology == null ? new Topology(this) : topology;
        this.ha = useHA;
        this.discoveryGroupConfiguration = discoveryGroupConfiguration;
        this.initialConnectors = transportConfigs != null ? transportConfigs : null;
        this.nodeID = UUIDGenerator.getInstance().generateStringUUID();
        this.clientFailureCheckPeriod = HornetQClient.DEFAULT_CLIENT_FAILURE_CHECK_PERIOD;
        this.connectionTTL = HornetQClient.DEFAULT_CONNECTION_TTL;
        this.callTimeout = 30000L;
        this.callFailoverTimeout = -1L;
        this.minLargeMessageSize = 102400;
        this.consumerWindowSize = 0x100000;
        this.consumerMaxRate = -1;
        this.confirmationWindowSize = -1;
        this.producerWindowSize = 65536;
        this.producerMaxRate = -1;
        this.blockOnAcknowledge = false;
        this.blockOnDurableSend = true;
        this.blockOnNonDurableSend = false;
        this.autoGroup = false;
        this.preAcknowledge = false;
        this.ackBatchSize = 0x100000;
        this.connectionLoadBalancingPolicyClassName = HornetQClient.DEFAULT_CONNECTION_LOAD_BALANCING_POLICY_CLASS_NAME;
        this.useGlobalPools = true;
        this.scheduledThreadPoolMaxSize = 5;
        this.threadPoolMaxSize = -1;
        this.retryInterval = 2000L;
        this.retryIntervalMultiplier = HornetQClient.DEFAULT_RETRY_INTERVAL_MULTIPLIER;
        this.maxRetryInterval = HornetQClient.DEFAULT_MAX_RETRY_INTERVAL;
        this.reconnectAttempts = 0;
        this.initialConnectAttempts = 1;
        this.failoverOnInitialConnection = false;
        this.cacheLargeMessagesClient = false;
        this.initialMessagePacketSize = 1500;
        this.cacheLargeMessagesClient = false;
        this.compressLargeMessage = false;
        this.clusterConnection = false;
    }

    public ServerLocatorImpl(boolean useHA, DiscoveryGroupConfiguration groupConfiguration) {
        this(new Topology(null), useHA, groupConfiguration, null);
        if (useHA) {
            this.topology.setOwner(this);
        }
    }

    public ServerLocatorImpl(boolean useHA, TransportConfiguration ... transportConfigs) {
        this(new Topology(null), useHA, (DiscoveryGroupConfiguration)null, transportConfigs);
        if (useHA) {
            this.topology.setOwner(this);
        }
    }

    public ServerLocatorImpl(Topology topology, boolean useHA, DiscoveryGroupConfiguration groupConfiguration) {
        this(topology, useHA, groupConfiguration, null);
    }

    public ServerLocatorImpl(Topology topology, boolean useHA, TransportConfiguration ... transportConfigs) {
        this(topology, useHA, (DiscoveryGroupConfiguration)null, transportConfigs);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void resetToInitialConnectors() {
        String string = this.topologyArrayGuard;
        synchronized (string) {
            this.receivedTopology = false;
            this.topologyArray = null;
            this.topology.clear();
        }
    }

    private ServerLocatorImpl(ServerLocatorImpl locator) {
        this.ha = locator.ha;
        this.finalizeCheck = locator.finalizeCheck;
        this.clusterConnection = locator.clusterConnection;
        this.initialConnectors = locator.initialConnectors;
        this.discoveryGroupConfiguration = locator.discoveryGroupConfiguration;
        this.topology = locator.topology;
        this.topologyArray = locator.topologyArray;
        this.receivedTopology = locator.receivedTopology;
        this.compressLargeMessage = locator.compressLargeMessage;
        this.cacheLargeMessagesClient = locator.cacheLargeMessagesClient;
        this.clientFailureCheckPeriod = locator.clientFailureCheckPeriod;
        this.connectionTTL = locator.connectionTTL;
        this.callTimeout = locator.callTimeout;
        this.callFailoverTimeout = locator.callFailoverTimeout;
        this.minLargeMessageSize = locator.minLargeMessageSize;
        this.consumerWindowSize = locator.consumerWindowSize;
        this.consumerMaxRate = locator.consumerMaxRate;
        this.confirmationWindowSize = locator.confirmationWindowSize;
        this.producerWindowSize = locator.producerWindowSize;
        this.producerMaxRate = locator.producerMaxRate;
        this.blockOnAcknowledge = locator.blockOnAcknowledge;
        this.blockOnDurableSend = locator.blockOnDurableSend;
        this.blockOnNonDurableSend = locator.blockOnNonDurableSend;
        this.autoGroup = locator.autoGroup;
        this.preAcknowledge = locator.preAcknowledge;
        this.connectionLoadBalancingPolicyClassName = locator.connectionLoadBalancingPolicyClassName;
        this.ackBatchSize = locator.ackBatchSize;
        this.useGlobalPools = locator.useGlobalPools;
        this.scheduledThreadPoolMaxSize = locator.scheduledThreadPoolMaxSize;
        this.threadPoolMaxSize = locator.threadPoolMaxSize;
        this.retryInterval = locator.retryInterval;
        this.retryIntervalMultiplier = locator.retryIntervalMultiplier;
        this.maxRetryInterval = locator.maxRetryInterval;
        this.reconnectAttempts = locator.reconnectAttempts;
        this.initialConnectAttempts = locator.initialConnectAttempts;
        this.failoverOnInitialConnection = locator.failoverOnInitialConnection;
        this.initialMessagePacketSize = locator.initialMessagePacketSize;
        this.startExecutor = locator.startExecutor;
        this.afterConnectListener = locator.afterConnectListener;
        this.groupID = locator.groupID;
        this.nodeID = locator.nodeID;
        this.clusterTransportConfiguration = locator.clusterTransportConfiguration;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized TransportConfiguration selectConnector() {
        Pair<TransportConfiguration, TransportConfiguration>[] usedTopology;
        String string = this.topologyArrayGuard;
        synchronized (string) {
            usedTopology = this.topologyArray;
        }
        if (usedTopology != null) {
            int pos = this.loadBalancingPolicy.select(usedTopology.length);
            Pair<TransportConfiguration, TransportConfiguration> pair = usedTopology[pos];
            return (TransportConfiguration)pair.getA();
        }
        int pos = this.loadBalancingPolicy.select(this.initialConnectors.length);
        return this.initialConnectors[pos];
    }

    @Override
    public void start(Executor executor) throws Exception {
        this.initialise();
        this.startExecutor = executor;
        if (executor != null) {
            executor.execute(new Runnable(){

                @Override
                public void run() {
                    block2: {
                        try {
                            ServerLocatorImpl.this.connect();
                        }
                        catch (Exception e) {
                            if (ServerLocatorImpl.this.isClosed()) break block2;
                            HornetQClientLogger.LOGGER.errorConnectingToNodes(e);
                        }
                    }
                }
            });
        }
    }

    @Override
    public void disableFinalizeCheck() {
        this.finalizeCheck = false;
    }

    @Override
    public ClientSessionFactoryInternal connect() throws HornetQException {
        return this.connect(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ClientSessionFactoryInternal connect(boolean skipWarnings) throws HornetQException {
        ServerLocatorImpl serverLocatorImpl = this;
        synchronized (serverLocatorImpl) {
            if (this.getNumInitialConnectors() > 0 && this.discoveryGroup == null) {
                ClientSessionFactoryInternal sf = (ClientSessionFactoryInternal)this.staticConnector.connect(skipWarnings);
                this.addFactory(sf);
                return sf;
            }
        }
        return (ClientSessionFactoryInternal)this.createSessionFactory();
    }

    @Override
    public ClientSessionFactoryInternal connectNoWarnings() throws HornetQException {
        return this.connect(true);
    }

    @Override
    public void setAfterConnectionInternalListener(AfterConnectInternalListener listener) {
        this.afterConnectListener = listener;
    }

    @Override
    public AfterConnectInternalListener getAfterConnectInternalListener() {
        return this.afterConnectListener;
    }

    @Override
    public ClientSessionFactory createSessionFactory(String nodeID) throws Exception {
        TopologyMemberImpl topologyMember = this.topology.getMember(nodeID);
        if (HornetQClientLogger.LOGGER.isTraceEnabled()) {
            HornetQClientLogger.LOGGER.trace("Creating connection factory towards " + nodeID + " = " + topologyMember + ", topology=" + this.topology.describe());
        }
        if (topologyMember == null) {
            return null;
        }
        if (topologyMember.getLive() != null) {
            ClientSessionFactoryInternal factory = (ClientSessionFactoryInternal)this.createSessionFactory(topologyMember.getLive());
            if (topologyMember.getBackup() != null) {
                factory.setBackupConnector(topologyMember.getLive(), topologyMember.getBackup());
            }
            return factory;
        }
        if (topologyMember.getLive() == null && topologyMember.getBackup() != null) {
            ClientSessionFactoryInternal factory = (ClientSessionFactoryInternal)this.createSessionFactory(topologyMember.getBackup());
            return factory;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ClientSessionFactory createSessionFactory(TransportConfiguration transportConfiguration) throws Exception {
        this.assertOpen();
        this.initialise();
        ClientSessionFactoryImpl factory = new ClientSessionFactoryImpl(this, transportConfiguration, this.callTimeout, this.callFailoverTimeout, this.clientFailureCheckPeriod, this.connectionTTL, this.retryInterval, this.retryIntervalMultiplier, this.maxRetryInterval, this.reconnectAttempts, this.threadPool, this.scheduledThreadPool, this.incomingInterceptors, this.outgoingInterceptors, this.packetDecoder);
        this.addToConnecting(factory);
        try {
            try {
                factory.connect(this.reconnectAttempts, this.failoverOnInitialConnection);
            }
            catch (HornetQException e1) {
                factory.close();
                throw e1;
            }
            this.addFactory(factory);
            ClientSessionFactoryImpl clientSessionFactoryImpl = factory;
            return clientSessionFactoryImpl;
        }
        finally {
            this.removeFromConnecting(factory);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ClientSessionFactory createSessionFactory(TransportConfiguration transportConfiguration, int reconnectAttempts, boolean failoverOnInitialConnection) throws Exception {
        this.assertOpen();
        this.initialise();
        ClientSessionFactoryImpl factory = new ClientSessionFactoryImpl(this, transportConfiguration, this.callTimeout, this.callFailoverTimeout, this.clientFailureCheckPeriod, this.connectionTTL, this.retryInterval, this.retryIntervalMultiplier, this.maxRetryInterval, reconnectAttempts, this.threadPool, this.scheduledThreadPool, this.incomingInterceptors, this.outgoingInterceptors, this.packetDecoder);
        this.addToConnecting(factory);
        try {
            try {
                factory.connect(reconnectAttempts, failoverOnInitialConnection);
            }
            catch (HornetQException e1) {
                factory.close();
                throw e1;
            }
            this.addFactory(factory);
            ClientSessionFactoryImpl clientSessionFactoryImpl = factory;
            return clientSessionFactoryImpl;
        }
        finally {
            this.removeFromConnecting(factory);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeFromConnecting(ClientSessionFactoryInternal factory) {
        Set<ClientSessionFactoryInternal> set = this.connectingFactories;
        synchronized (set) {
            this.connectingFactories.remove(factory);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addToConnecting(ClientSessionFactoryInternal factory) {
        Set<ClientSessionFactoryInternal> set = this.connectingFactories;
        synchronized (set) {
            this.assertOpen();
            this.connectingFactories.add(factory);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ClientSessionFactory createSessionFactory() throws HornetQException {
        long timeout;
        boolean ok;
        this.assertOpen();
        this.initialise();
        if (this.getNumInitialConnectors() == 0 && this.discoveryGroup != null && !(ok = this.discoveryGroup.waitForBroadcast(timeout = this.clusterConnection ? 0L : this.discoveryGroupConfiguration.getDiscoveryInitialWaitTimeout()))) {
            throw HornetQClientMessageBundle.BUNDLE.connectionTimedOutInInitialBroadcast();
        }
        ClientSessionFactory factory = null;
        ServerLocatorImpl serverLocatorImpl = this;
        synchronized (serverLocatorImpl) {
            boolean hasTimedOut;
            boolean retry;
            int attempts = 0;
            do {
                retry = false;
                TransportConfiguration tc = this.selectConnector();
                if (tc == null) {
                    throw HornetQClientMessageBundle.BUNDLE.noTCForSessionFactory();
                }
                try {
                    factory = new ClientSessionFactoryImpl(this, tc, this.callTimeout, this.callFailoverTimeout, this.clientFailureCheckPeriod, this.connectionTTL, this.retryInterval, this.retryIntervalMultiplier, this.maxRetryInterval, this.reconnectAttempts, this.threadPool, this.scheduledThreadPool, this.incomingInterceptors, this.outgoingInterceptors, this.packetDecoder);
                    try {
                        this.addToConnecting((ClientSessionFactoryInternal)factory);
                        factory.connect(this.initialConnectAttempts, this.failoverOnInitialConnection);
                    }
                    finally {
                        this.removeFromConnecting((ClientSessionFactoryInternal)factory);
                    }
                }
                catch (HornetQException e) {
                    factory.close();
                    factory = null;
                    if (e.getType() == HornetQExceptionType.NOT_CONNECTED) {
                        ++attempts;
                        String string = this.topologyArrayGuard;
                        synchronized (string) {
                            if (this.topologyArray != null && attempts == this.topologyArray.length) {
                                throw HornetQClientMessageBundle.BUNDLE.cannotConnectToServers();
                            }
                            if (this.topologyArray == null && attempts == this.getNumInitialConnectors()) {
                                throw HornetQClientMessageBundle.BUNDLE.cannotConnectToServers();
                            }
                        }
                        retry = true;
                        continue;
                    }
                    throw e;
                }
            } while (retry);
            long timeout2 = System.currentTimeMillis() + this.callTimeout;
            while (!this.isClosed() && !this.receivedTopology && timeout2 > System.currentTimeMillis()) {
                try {
                    this.wait(1000L);
                }
                catch (InterruptedException e) {
                    throw new HornetQInterruptedException((Throwable)e);
                }
            }
            boolean bl = hasTimedOut = timeout2 > System.currentTimeMillis();
            if (!hasTimedOut && !this.receivedTopology) {
                if (factory != null) {
                    factory.cleanup();
                }
                throw HornetQClientMessageBundle.BUNDLE.connectionTimedOutOnReceiveTopology(this.discoveryGroup);
            }
            this.addFactory((ClientSessionFactoryInternal)factory);
            return factory;
        }
    }

    @Override
    public boolean isHA() {
        return this.ha;
    }

    @Override
    public boolean isCacheLargeMessagesClient() {
        return this.cacheLargeMessagesClient;
    }

    @Override
    public void setCacheLargeMessagesClient(boolean cached) {
        this.cacheLargeMessagesClient = cached;
    }

    @Override
    public long getClientFailureCheckPeriod() {
        return this.clientFailureCheckPeriod;
    }

    @Override
    public void setClientFailureCheckPeriod(long clientFailureCheckPeriod) {
        this.checkWrite();
        this.clientFailureCheckPeriod = clientFailureCheckPeriod;
    }

    @Override
    public long getConnectionTTL() {
        return this.connectionTTL;
    }

    @Override
    public void setConnectionTTL(long connectionTTL) {
        this.checkWrite();
        this.connectionTTL = connectionTTL;
    }

    @Override
    public long getCallTimeout() {
        return this.callTimeout;
    }

    @Override
    public void setCallTimeout(long callTimeout) {
        this.checkWrite();
        this.callTimeout = callTimeout;
    }

    @Override
    public long getCallFailoverTimeout() {
        return this.callFailoverTimeout;
    }

    @Override
    public void setCallFailoverTimeout(long callFailoverTimeout) {
        this.checkWrite();
        this.callFailoverTimeout = callFailoverTimeout;
    }

    @Override
    public int getMinLargeMessageSize() {
        return this.minLargeMessageSize;
    }

    @Override
    public void setMinLargeMessageSize(int minLargeMessageSize) {
        this.checkWrite();
        this.minLargeMessageSize = minLargeMessageSize;
    }

    @Override
    public int getConsumerWindowSize() {
        return this.consumerWindowSize;
    }

    @Override
    public void setConsumerWindowSize(int consumerWindowSize) {
        this.checkWrite();
        this.consumerWindowSize = consumerWindowSize;
    }

    @Override
    public int getConsumerMaxRate() {
        return this.consumerMaxRate;
    }

    @Override
    public void setConsumerMaxRate(int consumerMaxRate) {
        this.checkWrite();
        this.consumerMaxRate = consumerMaxRate;
    }

    @Override
    public int getConfirmationWindowSize() {
        return this.confirmationWindowSize;
    }

    @Override
    public void setConfirmationWindowSize(int confirmationWindowSize) {
        this.checkWrite();
        this.confirmationWindowSize = confirmationWindowSize;
    }

    @Override
    public int getProducerWindowSize() {
        return this.producerWindowSize;
    }

    @Override
    public void setProducerWindowSize(int producerWindowSize) {
        this.checkWrite();
        this.producerWindowSize = producerWindowSize;
    }

    @Override
    public int getProducerMaxRate() {
        return this.producerMaxRate;
    }

    @Override
    public void setProducerMaxRate(int producerMaxRate) {
        this.checkWrite();
        this.producerMaxRate = producerMaxRate;
    }

    @Override
    public boolean isBlockOnAcknowledge() {
        return this.blockOnAcknowledge;
    }

    @Override
    public void setBlockOnAcknowledge(boolean blockOnAcknowledge) {
        this.checkWrite();
        this.blockOnAcknowledge = blockOnAcknowledge;
    }

    @Override
    public boolean isBlockOnDurableSend() {
        return this.blockOnDurableSend;
    }

    @Override
    public void setBlockOnDurableSend(boolean blockOnDurableSend) {
        this.checkWrite();
        this.blockOnDurableSend = blockOnDurableSend;
    }

    @Override
    public boolean isBlockOnNonDurableSend() {
        return this.blockOnNonDurableSend;
    }

    @Override
    public void setBlockOnNonDurableSend(boolean blockOnNonDurableSend) {
        this.checkWrite();
        this.blockOnNonDurableSend = blockOnNonDurableSend;
    }

    @Override
    public boolean isAutoGroup() {
        return this.autoGroup;
    }

    @Override
    public void setAutoGroup(boolean autoGroup) {
        this.checkWrite();
        this.autoGroup = autoGroup;
    }

    @Override
    public boolean isPreAcknowledge() {
        return this.preAcknowledge;
    }

    @Override
    public void setPreAcknowledge(boolean preAcknowledge) {
        this.checkWrite();
        this.preAcknowledge = preAcknowledge;
    }

    @Override
    public int getAckBatchSize() {
        return this.ackBatchSize;
    }

    @Override
    public void setAckBatchSize(int ackBatchSize) {
        this.checkWrite();
        this.ackBatchSize = ackBatchSize;
    }

    @Override
    public boolean isUseGlobalPools() {
        return this.useGlobalPools;
    }

    @Override
    public void setUseGlobalPools(boolean useGlobalPools) {
        this.checkWrite();
        this.useGlobalPools = useGlobalPools;
    }

    @Override
    public int getScheduledThreadPoolMaxSize() {
        return this.scheduledThreadPoolMaxSize;
    }

    @Override
    public void setScheduledThreadPoolMaxSize(int scheduledThreadPoolMaxSize) {
        this.checkWrite();
        this.scheduledThreadPoolMaxSize = scheduledThreadPoolMaxSize;
    }

    @Override
    public int getThreadPoolMaxSize() {
        return this.threadPoolMaxSize;
    }

    @Override
    public void setThreadPoolMaxSize(int threadPoolMaxSize) {
        this.checkWrite();
        this.threadPoolMaxSize = threadPoolMaxSize;
    }

    @Override
    public long getRetryInterval() {
        return this.retryInterval;
    }

    @Override
    public void setRetryInterval(long retryInterval) {
        this.checkWrite();
        this.retryInterval = retryInterval;
    }

    @Override
    public long getMaxRetryInterval() {
        return this.maxRetryInterval;
    }

    @Override
    public void setMaxRetryInterval(long retryInterval) {
        this.checkWrite();
        this.maxRetryInterval = retryInterval;
    }

    @Override
    public double getRetryIntervalMultiplier() {
        return this.retryIntervalMultiplier;
    }

    @Override
    public void setRetryIntervalMultiplier(double retryIntervalMultiplier) {
        this.checkWrite();
        this.retryIntervalMultiplier = retryIntervalMultiplier;
    }

    @Override
    public int getReconnectAttempts() {
        return this.reconnectAttempts;
    }

    @Override
    public void setReconnectAttempts(int reconnectAttempts) {
        this.checkWrite();
        this.reconnectAttempts = reconnectAttempts;
    }

    @Override
    public void setInitialConnectAttempts(int initialConnectAttempts) {
        this.checkWrite();
        this.initialConnectAttempts = initialConnectAttempts;
    }

    @Override
    public int getInitialConnectAttempts() {
        return this.initialConnectAttempts;
    }

    @Override
    public boolean isFailoverOnInitialConnection() {
        return this.failoverOnInitialConnection;
    }

    @Override
    public void setFailoverOnInitialConnection(boolean failover) {
        this.checkWrite();
        this.failoverOnInitialConnection = failover;
    }

    @Override
    public String getConnectionLoadBalancingPolicyClassName() {
        return this.connectionLoadBalancingPolicyClassName;
    }

    @Override
    public void setConnectionLoadBalancingPolicyClassName(String loadBalancingPolicyClassName) {
        this.checkWrite();
        this.connectionLoadBalancingPolicyClassName = loadBalancingPolicyClassName;
    }

    @Override
    public TransportConfiguration[] getStaticTransportConfigurations() {
        if (this.initialConnectors == null) {
            return new TransportConfiguration[0];
        }
        return Arrays.copyOf(this.initialConnectors, this.initialConnectors.length);
    }

    @Override
    public DiscoveryGroupConfiguration getDiscoveryGroupConfiguration() {
        return this.discoveryGroupConfiguration;
    }

    @Override
    @Deprecated
    public void addInterceptor(Interceptor interceptor) {
        this.addIncomingInterceptor(interceptor);
    }

    @Override
    public void addIncomingInterceptor(Interceptor interceptor) {
        this.incomingInterceptors.add(interceptor);
    }

    @Override
    public void addOutgoingInterceptor(Interceptor interceptor) {
        this.outgoingInterceptors.add(interceptor);
    }

    @Override
    @Deprecated
    public boolean removeInterceptor(Interceptor interceptor) {
        return this.removeIncomingInterceptor(interceptor);
    }

    @Override
    public boolean removeIncomingInterceptor(Interceptor interceptor) {
        return this.incomingInterceptors.remove(interceptor);
    }

    @Override
    public boolean removeOutgoingInterceptor(Interceptor interceptor) {
        return this.outgoingInterceptors.remove(interceptor);
    }

    @Override
    public int getInitialMessagePacketSize() {
        return this.initialMessagePacketSize;
    }

    @Override
    public void setInitialMessagePacketSize(int size) {
        this.checkWrite();
        this.initialMessagePacketSize = size;
    }

    @Override
    public void setGroupID(String groupID) {
        this.checkWrite();
        this.groupID = groupID;
    }

    @Override
    public String getGroupID() {
        return this.groupID;
    }

    @Override
    public boolean isCompressLargeMessage() {
        return this.compressLargeMessage;
    }

    @Override
    public void setCompressLargeMessage(boolean avoid) {
        this.compressLargeMessage = avoid;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkWrite() {
        String string = this.stateGuard;
        synchronized (string) {
            if (this.state != null && this.state != STATE.CLOSED) {
                throw new IllegalStateException("Cannot set attribute on SessionFactory after it has been used");
            }
        }
    }

    private int getNumInitialConnectors() {
        if (this.initialConnectors == null) {
            return 0;
        }
        return this.initialConnectors.length;
    }

    @Override
    public void setIdentity(String identity) {
        this.identity = identity;
    }

    @Override
    public void setNodeID(String nodeID) {
        this.nodeID = nodeID;
    }

    @Override
    public String getNodeID() {
        return this.nodeID;
    }

    @Override
    public void setClusterConnection(boolean clusterConnection) {
        this.clusterConnection = clusterConnection;
    }

    @Override
    public boolean isClusterConnection() {
        return this.clusterConnection;
    }

    @Override
    public TransportConfiguration getClusterTransportConfiguration() {
        return this.clusterTransportConfiguration;
    }

    @Override
    public void setClusterTransportConfiguration(TransportConfiguration tc) {
        this.clusterTransportConfiguration = tc;
    }

    protected void finalize() throws Throwable {
        if (this.finalizeCheck) {
            this.close();
        }
        super.finalize();
    }

    @Override
    public void cleanup() {
        this.doClose(false);
    }

    @Override
    public void close() {
        this.doClose(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doClose(boolean sendClose) {
        HashSet<ClientSessionFactoryInternal> clonedFactory;
        Set<ClientSessionFactoryInternal> set = this.stateGuard;
        synchronized (set) {
            if (this.state == STATE.CLOSED) {
                if (HornetQClientLogger.LOGGER.isDebugEnabled()) {
                    HornetQClientLogger.LOGGER.debug(this + " is already closed when calling closed");
                }
                return;
            }
            this.state = STATE.CLOSING;
        }
        if (this.latch != null) {
            this.latch.countDown();
        }
        set = this.connectingFactories;
        synchronized (set) {
            for (ClientSessionFactoryInternal clientSessionFactoryInternal : this.connectingFactories) {
                clientSessionFactoryInternal.causeExit();
            }
        }
        if (this.discoveryGroup != null) {
            set = this;
            synchronized (set) {
                try {
                    this.discoveryGroup.stop();
                }
                catch (Exception e) {
                    HornetQClientLogger.LOGGER.failedToStopDiscovery(e);
                }
            }
        }
        this.staticConnector.disconnect();
        set = this.connectingFactories;
        synchronized (set) {
            for (ClientSessionFactoryInternal clientSessionFactoryInternal : this.connectingFactories) {
                clientSessionFactoryInternal.causeExit();
            }
            for (ClientSessionFactoryInternal clientSessionFactoryInternal : this.connectingFactories) {
                clientSessionFactoryInternal.close();
            }
            this.connectingFactories.clear();
        }
        Iterator i$ = this.factories;
        synchronized (i$) {
            clonedFactory = new HashSet<ClientSessionFactoryInternal>(this.factories);
            this.factories.clear();
        }
        for (ClientSessionFactoryInternal clientSessionFactoryInternal : clonedFactory) {
            clientSessionFactoryInternal.causeExit();
        }
        for (ClientSessionFactory clientSessionFactory : clonedFactory) {
            if (sendClose) {
                clientSessionFactory.close();
                continue;
            }
            clientSessionFactory.cleanup();
        }
        if (this.shutdownPool) {
            if (this.threadPool != null) {
                this.threadPool.shutdown();
                try {
                    if (!this.threadPool.awaitTermination(10000L, TimeUnit.MILLISECONDS)) {
                        HornetQClientLogger.LOGGER.timedOutWaitingForTermination();
                    }
                }
                catch (InterruptedException e) {
                    throw new HornetQInterruptedException((Throwable)e);
                }
            }
            if (this.scheduledThreadPool != null) {
                this.scheduledThreadPool.shutdown();
                try {
                    if (!this.scheduledThreadPool.awaitTermination(10000L, TimeUnit.MILLISECONDS)) {
                        HornetQClientLogger.LOGGER.timedOutWaitingForScheduledPoolTermination();
                    }
                }
                catch (InterruptedException e) {
                    throw new HornetQInterruptedException((Throwable)e);
                }
            }
        }
        String string = this.stateGuard;
        synchronized (string) {
            this.state = STATE.CLOSED;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void notifyNodeDown(long eventTime, String nodeID) {
        if (!this.ha) {
            return;
        }
        if (HornetQClientLogger.LOGGER.isTraceEnabled()) {
            HornetQClientLogger.LOGGER.trace("nodeDown " + this + " nodeID=" + nodeID + " as being down", new Exception("trace"));
        }
        this.topology.removeMember(eventTime, nodeID);
        if (this.clusterConnection) {
            this.updateArraysAndPairs();
        } else {
            String string = this.topologyArrayGuard;
            synchronized (string) {
                if (this.topology.isEmpty()) {
                    this.receivedTopology = false;
                    this.topologyArray = null;
                } else {
                    this.updateArraysAndPairs();
                    if (this.topology.nodes() == 1 && this.topology.getMember(this.nodeID) != null) {
                        this.receivedTopology = false;
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void notifyNodeUp(long uniqueEventID, String nodeID, String nodeName, Pair<TransportConfiguration, TransportConfiguration> connectorPair, boolean last) {
        if (HornetQClientLogger.LOGGER.isTraceEnabled()) {
            HornetQClientLogger.LOGGER.trace("NodeUp " + this + "::nodeID=" + nodeID + ", connectorPair=" + connectorPair, new Exception("trace"));
        }
        TopologyMemberImpl member = new TopologyMemberImpl(nodeID, nodeName, (TransportConfiguration)connectorPair.getA(), (TransportConfiguration)connectorPair.getB());
        this.topology.updateMember(uniqueEventID, nodeID, member);
        TopologyMemberImpl actMember = this.topology.getMember(nodeID);
        if (actMember != null && actMember.getLive() != null && actMember.getBackup() != null) {
            HashSet<ClientSessionFactoryInternal> clonedFactories = new HashSet<ClientSessionFactoryInternal>();
            Set<ClientSessionFactoryInternal> set = this.factories;
            synchronized (set) {
                clonedFactories.addAll(this.factories);
            }
            for (ClientSessionFactory clientSessionFactory : clonedFactories) {
                ((ClientSessionFactoryInternal)clientSessionFactory).setBackupConnector(actMember.getLive(), actMember.getBackup());
            }
        }
        this.updateArraysAndPairs();
        if (last) {
            ServerLocatorImpl serverLocatorImpl = this;
            synchronized (serverLocatorImpl) {
                this.receivedTopology = true;
                this.notifyAll();
            }
        }
    }

    public String toString() {
        if (this.identity != null) {
            return "ServerLocatorImpl (identity=" + this.identity + ") [initialConnectors=" + Arrays.toString(this.initialConnectors == null ? new TransportConfiguration[]{} : this.initialConnectors) + ", discoveryGroupConfiguration=" + this.discoveryGroupConfiguration + "]";
        }
        return "ServerLocatorImpl [initialConnectors=" + Arrays.toString(this.initialConnectors == null ? new TransportConfiguration[]{} : this.initialConnectors) + ", discoveryGroupConfiguration=" + this.discoveryGroupConfiguration + "]";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateArraysAndPairs() {
        String string = this.topologyArrayGuard;
        synchronized (string) {
            Collection<TopologyMemberImpl> membersCopy = this.topology.getMembers();
            Pair[] topologyArrayLocal = (Pair[])Array.newInstance(Pair.class, membersCopy.size());
            int count = 0;
            for (TopologyMemberImpl pair : membersCopy) {
                topologyArrayLocal[count++] = pair.getConnector();
            }
            this.topologyArray = topologyArrayLocal;
        }
    }

    @Override
    public synchronized void connectorsChanged(List<DiscoveryEntry> newConnectors) {
        if (this.receivedTopology) {
            return;
        }
        TransportConfiguration[] newInitialconnectors = (TransportConfiguration[])Array.newInstance(TransportConfiguration.class, newConnectors.size());
        int count = 0;
        for (DiscoveryEntry entry : newConnectors) {
            newInitialconnectors[count++] = entry.getConnector();
            if (!this.ha || this.topology.getMember(entry.getNodeID()) != null) continue;
            TopologyMemberImpl member = new TopologyMemberImpl(entry.getNodeID(), null, entry.getConnector(), null);
            this.topology.updateMember(0L, entry.getNodeID(), member);
        }
        TransportConfiguration[] transportConfigurationArray = this.initialConnectors = newInitialconnectors.length == 0 ? null : newInitialconnectors;
        if (this.clusterConnection && !this.receivedTopology && this.getNumInitialConnectors() > 0) {
            Runnable connectRunnable = new Runnable(){

                @Override
                public void run() {
                    try {
                        ServerLocatorImpl.this.connect();
                    }
                    catch (HornetQException e) {
                        HornetQClientLogger.LOGGER.errorConnectingToNodes((Exception)((Object)e));
                    }
                }
            };
            if (this.startExecutor != null) {
                this.startExecutor.execute(connectRunnable);
            } else {
                connectRunnable.run();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void factoryClosed(ClientSessionFactory factory) {
        Set<ClientSessionFactoryInternal> set = this.factories;
        synchronized (set) {
            this.factories.remove(factory);
            if (!this.clusterConnection && this.factories.isEmpty()) {
                String string = this.topologyArrayGuard;
                synchronized (string) {
                    this.receivedTopology = false;
                    this.topologyArray = null;
                }
            }
        }
    }

    @Override
    public Topology getTopology() {
        return this.topology;
    }

    @Override
    public void setPacketDecoder(PacketDecoder packetDecoder) {
        this.packetDecoder = packetDecoder;
    }

    @Override
    public void addClusterTopologyListener(ClusterTopologyListener listener) {
        this.topology.addClusterTopologyListener(listener);
    }

    @Override
    public void removeClusterTopologyListener(ClusterTopologyListener listener) {
        this.topology.removeClusterTopologyListener(listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addFactory(ClientSessionFactoryInternal factory) {
        if (factory == null) {
            return;
        }
        if (this.isClosed()) {
            factory.close();
            return;
        }
        TransportConfiguration backup = null;
        if (this.ha) {
            backup = this.topology.getBackupForConnector((Connector)factory.getConnector());
        }
        factory.setBackupConnector(factory.getConnectorConfiguration(), backup);
        Set<ClientSessionFactoryInternal> set = this.factories;
        synchronized (set) {
            this.factories.add(factory);
        }
    }

    private void readObject(ObjectInputStream is) throws ClassNotFoundException, IOException {
        is.defaultReadObject();
        if (this.stateGuard == null) {
            this.stateGuard = new String();
        }
        if (this.topologyArrayGuard == null) {
            this.topologyArrayGuard = new String();
        }
        this.packetDecoder = ClientPacketDecoder.INSTANCE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void assertOpen() {
        String string = this.stateGuard;
        synchronized (string) {
            if (this.state != null && this.state != STATE.INITIALIZED) {
                throw new IllegalStateException("Server locator is closed (maybe it was garbage collected)");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isClosed() {
        String string = this.stateGuard;
        synchronized (string) {
            return this.state != STATE.INITIALIZED;
        }
    }

    private Object writeReplace() throws ObjectStreamException {
        ServerLocatorImpl clone = new ServerLocatorImpl(this);
        return clone;
    }

    static {
        finalizeCallback = null;
    }

    private final class StaticConnector
    implements Serializable {
        private static final long serialVersionUID = 6772279632415242634L;
        private List<Connector> connectors;

        private StaticConnector() {
        }

        public ClientSessionFactory connect(boolean skipWarnings) throws HornetQException {
            ServerLocatorImpl.this.assertOpen();
            ServerLocatorImpl.this.initialise();
            ClientSessionFactory csf = null;
            this.createConnectors();
            try {
                int retryNumber = 0;
                while (csf == null && !ServerLocatorImpl.this.isClosed()) {
                    ++retryNumber;
                    for (Connector conn : this.connectors) {
                        if (HornetQClientLogger.LOGGER.isDebugEnabled()) {
                            HornetQClientLogger.LOGGER.debug(this + "::Submitting connect towards " + conn);
                        }
                        if ((csf = conn.tryConnect()) == null) continue;
                        csf.getConnection().addFailureListener(new FailureListener(){

                            @Override
                            public void connectionFailed(HornetQException exception, boolean failedOver) {
                                if (ServerLocatorImpl.this.clusterConnection && exception.getType() == HornetQExceptionType.DISCONNECTED) {
                                    try {
                                        ServerLocatorImpl.this.start(ServerLocatorImpl.this.startExecutor);
                                    }
                                    catch (Exception e) {
                                        HornetQClientLogger.LOGGER.errorStartingLocator(e);
                                    }
                                }
                            }

                            public String toString() {
                                return "FailureListener('restarts cluster connections')";
                            }
                        });
                        if (HornetQClientLogger.LOGGER.isDebugEnabled()) {
                            HornetQClientLogger.LOGGER.debug("Returning " + csf + " after " + retryNumber + " retries on StaticConnector " + ServerLocatorImpl.this);
                        }
                        return csf;
                    }
                    if (ServerLocatorImpl.this.initialConnectAttempts >= 0 && retryNumber > ServerLocatorImpl.this.initialConnectAttempts) break;
                    if (!ServerLocatorImpl.this.latch.await(ServerLocatorImpl.this.retryInterval, TimeUnit.MILLISECONDS)) continue;
                    return null;
                }
            }
            catch (RejectedExecutionException e) {
                if (ServerLocatorImpl.this.isClosed() || skipWarnings) {
                    return null;
                }
                HornetQClientLogger.LOGGER.debug("Rejected execution", e);
                throw e;
            }
            catch (Exception e) {
                if (ServerLocatorImpl.this.isClosed() || skipWarnings) {
                    return null;
                }
                HornetQClientLogger.LOGGER.errorConnectingToNodes(e);
                throw HornetQClientMessageBundle.BUNDLE.cannotConnectToStaticConnectors(e);
            }
            if (ServerLocatorImpl.this.isClosed() || skipWarnings) {
                return null;
            }
            HornetQClientLogger.LOGGER.errorConnectingToNodes(ServerLocatorImpl.this.traceException);
            throw HornetQClientMessageBundle.BUNDLE.cannotConnectToStaticConnectors2();
        }

        private synchronized void createConnectors() {
            if (this.connectors != null) {
                for (Connector conn : this.connectors) {
                    if (conn == null) continue;
                    conn.disconnect();
                }
            }
            this.connectors = new ArrayList<Connector>();
            if (ServerLocatorImpl.this.initialConnectors != null) {
                for (TransportConfiguration initialConnector : ServerLocatorImpl.this.initialConnectors) {
                    ClientSessionFactoryImpl factory = new ClientSessionFactoryImpl(ServerLocatorImpl.this, initialConnector, ServerLocatorImpl.this.callTimeout, ServerLocatorImpl.this.callFailoverTimeout, ServerLocatorImpl.this.clientFailureCheckPeriod, ServerLocatorImpl.this.connectionTTL, ServerLocatorImpl.this.retryInterval, ServerLocatorImpl.this.retryIntervalMultiplier, ServerLocatorImpl.this.maxRetryInterval, ServerLocatorImpl.this.reconnectAttempts, ServerLocatorImpl.this.threadPool, ServerLocatorImpl.this.scheduledThreadPool, ServerLocatorImpl.this.incomingInterceptors, ServerLocatorImpl.this.outgoingInterceptors, ServerLocatorImpl.this.packetDecoder);
                    factory.disableFinalizeCheck();
                    this.connectors.add(new Connector(initialConnector, factory));
                }
            }
        }

        public synchronized void disconnect() {
            if (this.connectors != null) {
                for (Connector connector : this.connectors) {
                    connector.disconnect();
                }
            }
        }

        protected void finalize() throws Throwable {
            if (!ServerLocatorImpl.this.isClosed() && ServerLocatorImpl.this.finalizeCheck) {
                HornetQClientLogger.LOGGER.serverLocatorNotClosed(ServerLocatorImpl.this.traceException, System.identityHashCode(this));
                if (finalizeCallback != null) {
                    finalizeCallback.run();
                }
                ServerLocatorImpl.this.close();
            }
            super.finalize();
        }

        private final class Connector {
            private final TransportConfiguration initialConnector;
            private volatile ClientSessionFactoryInternal factory;

            public Connector(TransportConfiguration initialConnector, ClientSessionFactoryInternal factory) {
                this.initialConnector = initialConnector;
                this.factory = factory;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public ClientSessionFactory tryConnect() throws HornetQException {
                if (HornetQClientLogger.LOGGER.isDebugEnabled()) {
                    HornetQClientLogger.LOGGER.debug(this + "::Trying to connect to " + this.factory);
                }
                try {
                    ClientSessionFactoryInternal factoryToUse = this.factory;
                    if (factoryToUse != null) {
                        ServerLocatorImpl.this.addToConnecting(factoryToUse);
                        try {
                            factoryToUse.connect(1, false);
                        }
                        finally {
                            ServerLocatorImpl.this.removeFromConnecting(factoryToUse);
                        }
                    }
                    return factoryToUse;
                }
                catch (HornetQException e) {
                    HornetQClientLogger.LOGGER.debug(this + "::Exception on establish connector initial connection", e);
                    return null;
                }
            }

            public void disconnect() {
                if (this.factory != null) {
                    this.factory.causeExit();
                    this.factory.cleanup();
                    this.factory = null;
                }
            }

            public String toString() {
                return "Connector [initialConnector=" + this.initialConnector + "]";
            }
        }
    }

    private static enum STATE {
        INITIALIZED,
        CLOSED,
        CLOSING;

    }
}

