/*
 * Decompiled with CFR 0.152.
 */
package org.jberet.operations;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.ServiceLoader;
import java.util.Set;
import javax.batch.operations.JobExecutionAlreadyCompleteException;
import javax.batch.operations.JobExecutionIsRunningException;
import javax.batch.operations.JobExecutionNotMostRecentException;
import javax.batch.operations.JobExecutionNotRunningException;
import javax.batch.operations.JobOperator;
import javax.batch.operations.JobRestartException;
import javax.batch.operations.JobSecurityException;
import javax.batch.operations.JobStartException;
import javax.batch.operations.NoSuchJobException;
import javax.batch.operations.NoSuchJobExecutionException;
import javax.batch.operations.NoSuchJobInstanceException;
import javax.batch.runtime.BatchStatus;
import javax.batch.runtime.JobExecution;
import javax.batch.runtime.JobInstance;
import javax.batch.runtime.StepExecution;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.transaction.InvalidTransactionException;
import javax.transaction.SystemException;
import javax.transaction.Transaction;
import javax.transaction.TransactionManager;
import org.jberet._private.BatchMessages;
import org.jberet.creation.ArchiveXmlLoader;
import org.jberet.creation.ArtifactFactoryWrapper;
import org.jberet.job.model.Job;
import org.jberet.repository.JobRepository;
import org.jberet.repository.JobRepositoryFactory;
import org.jberet.runtime.JobExecutionImpl;
import org.jberet.runtime.JobInstanceImpl;
import org.jberet.runtime.context.JobContextImpl;
import org.jberet.runtime.runner.JobExecutionRunner;
import org.jberet.spi.ArtifactFactory;
import org.jberet.spi.BatchEnvironment;

public class JobOperatorImpl
implements JobOperator {
    final JobRepository repository;
    private BatchEnvironment batchEnvironment;
    private final ArtifactFactory artifactFactory;

    public JobOperatorImpl() {
        ServiceLoader<BatchEnvironment> serviceLoader = ServiceLoader.load(BatchEnvironment.class);
        Iterator<BatchEnvironment> it = serviceLoader.iterator();
        if (it.hasNext()) {
            this.batchEnvironment = it.next();
        }
        this.artifactFactory = new ArtifactFactoryWrapper(this.batchEnvironment.getArtifactFactory());
        this.repository = JobRepositoryFactory.getJobRepository(this.batchEnvironment);
    }

    public long start(String jobXMLName, final Properties jobParameters) throws JobStartException, JobSecurityException {
        final ClassLoader classLoader = this.batchEnvironment.getClassLoader();
        final Job jobDefined = ArchiveXmlLoader.loadJobXml(jobXMLName, classLoader, new ArrayList<Job>());
        this.repository.addJob(jobDefined);
        try {
            return this.invokeTransaction(new TransactionInvocation<Long>(){

                @Override
                public Long invoke() throws JobStartException, JobSecurityException {
                    JobInstanceImpl jobInstance = JobOperatorImpl.this.repository.createJobInstance(jobDefined, JobOperatorImpl.this.getApplicationName(), classLoader);
                    return JobOperatorImpl.this.startJobExecution(jobInstance, jobParameters, null);
                }
            });
        }
        catch (InvalidTransactionException e) {
            throw new JobStartException((Throwable)e);
        }
        catch (SystemException e) {
            throw new JobStartException((Throwable)e);
        }
    }

    public void stop(long executionId) throws NoSuchJobExecutionException, JobExecutionNotRunningException, JobSecurityException {
        JobExecutionImpl jobExecution = (JobExecutionImpl)this.repository.getJobExecution(executionId);
        if (jobExecution == null) {
            throw BatchMessages.MESSAGES.noSuchJobExecution(executionId);
        }
        BatchStatus s = jobExecution.getBatchStatus();
        if (s == BatchStatus.STOPPED || s == BatchStatus.FAILED || s == BatchStatus.ABANDONED || s == BatchStatus.COMPLETED) {
            throw BatchMessages.MESSAGES.jobExecutionNotRunningException(executionId, s);
        }
        if (s != BatchStatus.STOPPING) {
            jobExecution.setBatchStatus(BatchStatus.STOPPING);
            jobExecution.stop();
        }
    }

    public Set<String> getJobNames() throws JobSecurityException {
        HashSet<String> result = new HashSet<String>();
        for (Job e : this.repository.getJobs()) {
            result.add(e.getId());
        }
        return result;
    }

    public int getJobInstanceCount(String jobName) throws NoSuchJobException, JobSecurityException {
        int count = this.repository.getJobInstanceCount(jobName);
        if (count == 0) {
            throw BatchMessages.MESSAGES.noSuchJobException(jobName);
        }
        return count;
    }

    public List<JobInstance> getJobInstances(String jobName, int start, int count) throws NoSuchJobException, JobSecurityException {
        ArrayList<JobInstance> result = new ArrayList<JobInstance>();
        int pos = 0;
        List<JobInstance> instances = this.repository.getJobInstances(jobName);
        for (int i = instances.size() - 1; i >= 0; --i) {
            JobInstance e = instances.get(i);
            if (pos >= start) {
                if (result.size() >= count) break;
                result.add(e);
            }
            ++pos;
        }
        if (pos == 0) {
            throw BatchMessages.MESSAGES.noSuchJobException(jobName);
        }
        return result;
    }

    public List<Long> getRunningExecutions(String jobName) throws NoSuchJobException, JobSecurityException {
        ArrayList<Long> result = new ArrayList<Long>();
        boolean jobExists = false;
        for (JobExecution e : this.repository.getJobExecutions(null)) {
            if (!e.getJobName().equals(jobName)) continue;
            jobExists = true;
            BatchStatus s = e.getBatchStatus();
            if (s != BatchStatus.STARTING && s != BatchStatus.STARTED) continue;
            result.add(e.getExecutionId());
        }
        if (!jobExists) {
            throw BatchMessages.MESSAGES.noSuchJobException(jobName);
        }
        return result;
    }

    public Properties getParameters(long executionId) throws NoSuchJobExecutionException, JobSecurityException {
        return this.getJobExecution(executionId).getJobParameters();
    }

    public long restart(long executionId, final Properties restartParameters) throws JobExecutionAlreadyCompleteException, NoSuchJobExecutionException, JobExecutionNotMostRecentException, JobRestartException, JobSecurityException {
        long newExecutionId = 0L;
        final JobExecutionImpl originalToRestart = (JobExecutionImpl)this.getJobExecution(executionId);
        if (originalToRestart == null) {
            throw BatchMessages.MESSAGES.noSuchJobExecution(executionId);
        }
        BatchStatus previousStatus = originalToRestart.getBatchStatus();
        if (previousStatus == BatchStatus.COMPLETED) {
            throw BatchMessages.MESSAGES.jobExecutionAlreadyCompleteException(executionId);
        }
        if (previousStatus == BatchStatus.ABANDONED || previousStatus == BatchStatus.STARTED || previousStatus == BatchStatus.STARTING || previousStatus == BatchStatus.STOPPING) {
            throw BatchMessages.MESSAGES.jobRestartException(executionId, previousStatus);
        }
        if (previousStatus == BatchStatus.FAILED || previousStatus == BatchStatus.STOPPED) {
            final JobInstanceImpl jobInstance = (JobInstanceImpl)this.getJobInstance(executionId);
            List<JobExecution> executions = this.getJobExecutions(jobInstance);
            JobExecution mostRecentExecution = executions.get(executions.size() - 1);
            if (executionId != mostRecentExecution.getExecutionId()) {
                throw BatchMessages.MESSAGES.jobExecutionNotMostRecentException(executionId, jobInstance.getInstanceId());
            }
            String jobName = originalToRestart.getJobName();
            if (this.repository.getJob(jobName) == null) {
                Job jobDefined = ArchiveXmlLoader.loadJobXml(jobName, this.batchEnvironment.getClassLoader(), new ArrayList<Job>());
                this.repository.addJob(jobDefined);
            }
            if (jobInstance.getUnsubstitutedJob() == null) {
                jobInstance.setUnsubstitutedJob(this.repository.getJob(jobName));
            }
            try {
                newExecutionId = this.invokeTransaction(new TransactionInvocation<Long>(){

                    @Override
                    public Long invoke() throws JobStartException, JobSecurityException {
                        return JobOperatorImpl.this.startJobExecution(jobInstance, restartParameters, originalToRestart);
                    }
                });
            }
            catch (Exception e) {
                throw new JobRestartException((Throwable)e);
            }
        }
        return newExecutionId;
    }

    public void abandon(long executionId) throws NoSuchJobExecutionException, JobExecutionIsRunningException, JobSecurityException {
        JobExecutionImpl jobExecution = (JobExecutionImpl)this.getJobExecution(executionId);
        if (jobExecution == null) {
            throw BatchMessages.MESSAGES.noSuchJobExecution(executionId);
        }
        BatchStatus batchStatus = jobExecution.getBatchStatus();
        if (batchStatus != BatchStatus.COMPLETED && batchStatus != BatchStatus.FAILED && batchStatus != BatchStatus.STOPPED && batchStatus != BatchStatus.ABANDONED) {
            throw BatchMessages.MESSAGES.jobExecutionIsRunningException(executionId);
        }
        jobExecution.setBatchStatus(BatchStatus.ABANDONED);
    }

    public JobInstance getJobInstance(long executionId) throws NoSuchJobExecutionException, JobSecurityException {
        JobExecutionImpl jobExecution = (JobExecutionImpl)this.getJobExecution(executionId);
        return jobExecution.getJobInstance();
    }

    public List<JobExecution> getJobExecutions(JobInstance instance) throws NoSuchJobInstanceException, JobSecurityException {
        return this.repository.getJobExecutions(instance);
    }

    public JobExecution getJobExecution(long executionId) throws NoSuchJobExecutionException, JobSecurityException {
        return this.repository.getJobExecution(executionId);
    }

    public List<StepExecution> getStepExecutions(long jobExecutionId) throws NoSuchJobExecutionException, JobSecurityException {
        return this.repository.getStepExecutions(jobExecutionId);
    }

    private long startJobExecution(JobInstanceImpl jobInstance, Properties jobParameters, JobExecutionImpl originalToRestart) throws JobStartException, JobSecurityException {
        JobExecutionImpl jobExecution = this.repository.createJobExecution(jobInstance, jobParameters);
        JobContextImpl jobContext = new JobContextImpl(jobExecution, originalToRestart, this.artifactFactory, this.repository, this.batchEnvironment);
        JobExecutionRunner jobExecutionRunner = new JobExecutionRunner(jobContext);
        jobContext.getBatchEnvironment().submitTask(jobExecutionRunner);
        long jobExecutionId = jobExecution.getExecutionId();
        return jobExecutionId;
    }

    private String getApplicationName() {
        try {
            return (String)InitialContext.doLookup("java:app/AppName");
        }
        catch (NamingException e) {
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T> T invokeTransaction(TransactionInvocation<T> transactionInvocation) throws SystemException, InvalidTransactionException {
        TransactionManager tm = this.batchEnvironment.getTransactionManager();
        Transaction tx = tm.suspend();
        if (tx != null) {
            try {
                T t = transactionInvocation.invoke();
                return t;
            }
            finally {
                tm.resume(tx);
            }
        }
        return transactionInvocation.invoke();
    }

    private static interface TransactionInvocation<T> {
        public T invoke() throws JobStartException, JobSecurityException;
    }
}

