/*
 * Decompiled with CFR 0.152.
 */
package org.jberet.runtime;

import java.io.Serializable;
import java.util.List;
import javax.batch.runtime.BatchStatus;
import javax.batch.runtime.Metric;
import javax.batch.runtime.StepExecution;
import org.jberet.runtime.AbstractExecution;
import org.jberet.runtime.PartitionExecutionImpl;
import org.jberet.runtime.metric.StepMetrics;

public abstract class AbstractStepExecution
extends AbstractExecution
implements StepExecution {
    private static final long serialVersionUID = 1L;
    long id;
    String stepName;
    Serializable persistentUserData;
    Serializable readerCheckpointInfo;
    Serializable writerCheckpointInfo;
    Exception exception;
    StepMetrics stepMetrics = new StepMetrics();

    public abstract List<PartitionExecutionImpl> getPartitionExecutions();

    AbstractStepExecution() {
    }

    AbstractStepExecution(String stepName) {
        this.stepName = stepName;
        this.startTime = System.currentTimeMillis();
    }

    public void setId(long id) {
        this.id = id;
    }

    @Override
    protected AbstractStepExecution clone() throws CloneNotSupportedException {
        throw new CloneNotSupportedException();
    }

    public long getStepExecutionId() {
        return this.id;
    }

    public String getStepName() {
        return this.stepName;
    }

    public Serializable getPersistentUserData() {
        return this.persistentUserData;
    }

    public void setPersistentUserData(Serializable persistentUserData) {
        this.persistentUserData = persistentUserData;
    }

    public Metric[] getMetrics() {
        return this.stepMetrics.getMetrics();
    }

    public StepMetrics getStepMetrics() {
        return this.stepMetrics;
    }

    public Exception getException() {
        return this.exception;
    }

    public void setException(Exception exception) {
        this.exception = exception;
    }

    @Override
    public void setBatchStatus(BatchStatus batchStatus) {
        super.setBatchStatus(batchStatus);
        if (batchStatus == BatchStatus.COMPLETED || batchStatus == BatchStatus.FAILED || batchStatus == BatchStatus.STOPPED) {
            this.endTime = System.currentTimeMillis();
        }
    }

    public Serializable getReaderCheckpointInfo() {
        return this.readerCheckpointInfo;
    }

    public void setReaderCheckpointInfo(Serializable readerCheckpointInfo) {
        this.readerCheckpointInfo = readerCheckpointInfo;
    }

    public Serializable getWriterCheckpointInfo() {
        return this.writerCheckpointInfo;
    }

    public void setWriterCheckpointInfo(Serializable writerCheckpointInfo) {
        this.writerCheckpointInfo = writerCheckpointInfo;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof AbstractStepExecution)) {
            return false;
        }
        AbstractStepExecution that = (AbstractStepExecution)o;
        if (this.id != that.id) {
            return false;
        }
        return this.stepName.equals(that.stepName);
    }

    public int hashCode() {
        int result = (int)(this.id ^ this.id >>> 32);
        result = 31 * result + this.stepName.hashCode();
        return result;
    }
}

